/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.io.tg.TGStream;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGOutputStream
extends TGStream
implements TGOutputStreamBase {
    private DataOutputStream dataOutputStream;

    public boolean isSupportedExtension(String string) {
        return string.toLowerCase().equals(".tg");
    }

    public void init(TGFactory tGFactory, OutputStream outputStream) {
        this.dataOutputStream = new DataOutputStream(outputStream);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("TuxGuitar", "*.tg");
    }

    public void writeSong(TGSong tGSong) throws IOException {
        this.writeVersion();
        this.write(tGSong);
        this.dataOutputStream.flush();
        this.dataOutputStream.close();
    }

    private void writeVersion() {
        this.writeUnsignedByteString(TG_FORMAT_VERSION);
    }

    private void write(TGSong tGSong) {
        this.writeUnsignedByteString(tGSong.getName());
        this.writeUnsignedByteString(tGSong.getArtist());
        this.writeUnsignedByteString(tGSong.getAlbum());
        this.writeUnsignedByteString(tGSong.getAuthor());
        this.writeShort((short)tGSong.countMeasureHeaders());
        TGMeasureHeader tGMeasureHeader = null;
        Iterator iterator = tGSong.getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
            this.writeMeasureHeader(tGMeasureHeader2, tGMeasureHeader);
            tGMeasureHeader = tGMeasureHeader2;
        }
        this.writeByte(tGSong.countTracks());
        for (int i = 0; i < tGSong.countTracks(); ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            this.writeTrack(tGTrack);
        }
    }

    private void writeTrack(TGTrack tGTrack) {
        Object object;
        int n = 0;
        if (tGTrack.isSolo()) {
            n |= 1;
        }
        if (tGTrack.isMute()) {
            n |= 2;
        }
        if (!tGTrack.getLyrics().isEmpty()) {
            n |= 4;
        }
        this.writeHeader(n);
        this.writeUnsignedByteString(tGTrack.getName());
        this.writeChannel(tGTrack.getChannel());
        TGMeasure tGMeasure = null;
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            object = (TGMeasure)iterator.next();
            this.writeMeasure((TGMeasure)object, tGMeasure);
            tGMeasure = object;
        }
        this.writeByte(tGTrack.getStrings().size());
        object = tGTrack.getStrings().iterator();
        while (object.hasNext()) {
            TGString tGString = (TGString)object.next();
            this.writeInstrumentString(tGString);
        }
        this.writeByte(tGTrack.getOffset() - -24);
        this.writeRGBColor(tGTrack.getColor());
        if ((n & 4) != 0) {
            this.writeLyrics(tGTrack.getLyrics());
        }
    }

    private void writeMeasureHeader(TGMeasureHeader tGMeasureHeader, TGMeasureHeader tGMeasureHeader2) {
        int n = 0;
        if (tGMeasureHeader2 == null) {
            n |= 1;
            n |= 2;
            if (tGMeasureHeader.getTripletFeel() != 1) {
                n |= 0x40;
            }
        } else {
            int n2 = tGMeasureHeader.getTimeSignature().getNumerator();
            int n3 = tGMeasureHeader.getTimeSignature().getDenominator().getValue();
            int n4 = tGMeasureHeader2.getTimeSignature().getNumerator();
            int n5 = tGMeasureHeader2.getTimeSignature().getDenominator().getValue();
            if (n2 != n4 || n3 != n5) {
                n |= 1;
            }
            if (tGMeasureHeader.getTempo().getValue() != tGMeasureHeader2.getTempo().getValue()) {
                n |= 2;
            }
            if (tGMeasureHeader.getTripletFeel() != tGMeasureHeader2.getTripletFeel()) {
                n |= 0x40;
            }
        }
        n = tGMeasureHeader.isRepeatOpen() ? (n = n | 4) : n;
        n = tGMeasureHeader.getRepeatClose() > 0 ? (n = n | 8) : n;
        n = tGMeasureHeader.getRepeatAlternative() > 0 ? (n = n | 0x10) : n;
        n = tGMeasureHeader.hasMarker() ? (n = n | 0x20) : n;
        this.writeHeader(n);
        if ((n & 1) != 0) {
            this.writeTimeSignature(tGMeasureHeader.getTimeSignature());
        }
        if ((n & 2) != 0) {
            this.writeTempo(tGMeasureHeader.getTempo());
        }
        if ((n & 8) != 0) {
            this.writeShort((short)tGMeasureHeader.getRepeatClose());
        }
        if ((n & 0x10) != 0) {
            this.writeByte(tGMeasureHeader.getRepeatAlternative());
        }
        if ((n & 0x20) != 0) {
            this.writeMarker(tGMeasureHeader.getMarker());
        }
        if ((n & 0x40) != 0) {
            this.writeByte(tGMeasureHeader.getTripletFeel());
        }
    }

    private void writeMeasure(TGMeasure tGMeasure, TGMeasure tGMeasure2) {
        int n = 0;
        if (tGMeasure2 == null) {
            n |= 1;
            n |= 2;
        } else {
            if (tGMeasure.getClef() != tGMeasure2.getClef()) {
                n |= 1;
            }
            if (tGMeasure.getKeySignature() != tGMeasure2.getKeySignature()) {
                n |= 2;
            }
        }
        this.writeHeader(n);
        TGStream.TGBeatData tGBeatData = new TGStream.TGBeatData(this, tGMeasure);
        this.writeBeats(tGMeasure, tGBeatData);
        if ((n & 1) != 0) {
            this.writeByte(tGMeasure.getClef());
        }
        if ((n & 2) != 0) {
            this.writeByte(tGMeasure.getKeySignature());
        }
    }

    private void writeChannel(TGChannel tGChannel) {
        this.writeByte(tGChannel.getChannel());
        this.writeByte(tGChannel.getEffectChannel());
        this.writeByte(tGChannel.getInstrument());
        this.writeByte(tGChannel.getVolume());
        this.writeByte(tGChannel.getBalance());
        this.writeByte(tGChannel.getChorus());
        this.writeByte(tGChannel.getReverb());
        this.writeByte(tGChannel.getPhaser());
        this.writeByte(tGChannel.getTremolo());
    }

    private void writeBeats(TGMeasure tGMeasure, TGStream.TGBeatData tGBeatData) {
        int n = tGMeasure.countBeats();
        for (int i = 0; i < n; ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            this.writeBeat(tGBeat, tGBeatData, i + 1 < n);
        }
    }

    private void writeBeat(TGBeat tGBeat, TGStream.TGBeatData tGBeatData, boolean bl) {
        int n = bl ? 1 : 0;
        for (int i = 0; i < 2; ++i) {
            int n2;
            int n3 = i * 2;
            if (tGBeat.getVoice(i).isEmpty()) continue;
            n |= 16 << n3;
            int n4 = n2 = tGBeat.getVoice(i).isRestVoice() ? 0 : 1;
            if (!tGBeat.getVoice(i).getDuration().isEqual(tGBeatData.getVoice(i).getDuration())) {
                n2 |= 2;
                tGBeatData.getVoice(i).setDuration(tGBeat.getVoice(i).getDuration());
            }
            if (tGBeat.getVoice(i).getDirection() != 0) {
                if (tGBeat.getVoice(i).getDirection() == 1) {
                    n2 |= 4;
                } else if (tGBeat.getVoice(i).getDirection() == 2) {
                    n2 |= 8;
                }
            }
            if (tGBeatData.getVoice(i).getFlags() == n2) continue;
            n |= 32 << n3;
            tGBeatData.getVoice(i).setFlags(n2);
        }
        if (tGBeat.getStroke().getDirection() != 0) {
            n |= 2;
        }
        if (tGBeat.getChord() != null) {
            n |= 4;
        }
        if (tGBeat.getText() != null) {
            n |= 8;
        }
        this.writeHeader(n);
        this.writeVoices(n, tGBeat, tGBeatData);
        if ((n & 2) != 0) {
            this.writeStroke(tGBeat.getStroke());
        }
        if ((n & 4) != 0) {
            this.writeChord(tGBeat.getChord());
        }
        if ((n & 8) != 0) {
            this.writeText(tGBeat.getText());
        }
    }

    private void writeVoices(int n, TGBeat tGBeat, TGStream.TGBeatData tGBeatData) {
        for (int i = 0; i < 2; ++i) {
            int n2 = i * 2;
            if ((n & 16 << n2) == 0) continue;
            if ((n & 32 << n2) != 0) {
                this.writeHeader(tGBeatData.getVoice(i).getFlags());
            }
            if ((tGBeatData.getVoice(i).getFlags() & 2) != 0) {
                this.writeDuration(tGBeat.getVoice(i).getDuration());
            }
            if ((tGBeatData.getVoice(i).getFlags() & 1) == 0) continue;
            this.writeNotes(tGBeat.getVoice(i), tGBeatData);
        }
    }

    private void writeNotes(TGVoice tGVoice, TGStream.TGBeatData tGBeatData) {
        for (int i = 0; i < tGVoice.countNotes(); ++i) {
            TGNote tGNote = tGVoice.getNote(i);
            int n = i + 1 < tGVoice.countNotes() ? 1 : 0;
            int n2 = n = tGNote.isTiedNote() ? (n = n | 2) : n;
            if (tGNote.getVelocity() != tGBeatData.getVoice(tGVoice.getIndex()).getVelocity()) {
                tGBeatData.getVoice(tGVoice.getIndex()).setVelocity(tGNote.getVelocity());
                n |= 8;
            }
            n = tGNote.getEffect().hasAnyEffect() ? (n = n | 4) : n;
            this.writeHeader(n);
            this.writeNote(n, tGNote);
        }
    }

    private void writeNote(int n, TGNote tGNote) {
        this.writeByte(tGNote.getValue());
        this.writeByte(tGNote.getString());
        if ((n & 8) != 0) {
            this.writeByte(tGNote.getVelocity());
        }
        if ((n & 4) != 0) {
            this.writeNoteEffect(tGNote.getEffect());
        }
    }

    private void writeStroke(TGStroke tGStroke) {
        this.writeByte(tGStroke.getDirection());
        this.writeByte(tGStroke.getValue());
    }

    private void writeChord(TGChord tGChord) {
        this.writeByte(tGChord.countStrings());
        this.writeUnsignedByteString(tGChord.getName());
        this.writeByte(tGChord.getFirstFret());
        for (int i = 0; i < tGChord.countStrings(); ++i) {
            this.writeByte(tGChord.getFretValue(i));
        }
    }

    private void writeText(TGText tGText) {
        this.writeUnsignedByteString(tGText.getValue());
    }

    private void writeInstrumentString(TGString tGString) {
        this.writeByte(tGString.getValue());
    }

    private void writeTempo(TGTempo tGTempo) {
        this.writeShort((short)tGTempo.getValue());
    }

    private void writeTimeSignature(TGTimeSignature tGTimeSignature) {
        this.writeByte(tGTimeSignature.getNumerator());
        this.writeDuration(tGTimeSignature.getDenominator());
    }

    private void writeDuration(TGDuration tGDuration) {
        int n = 0;
        n = tGDuration.isDotted() ? (n = n | 1) : n;
        n = tGDuration.isDoubleDotted() ? (n = n | 2) : n;
        n = !tGDuration.getTupleto().isEqual(TGTupleto.NORMAL) ? (n = n | 4) : n;
        this.writeHeader(n);
        this.writeByte(tGDuration.getValue());
        if ((n & 4) != 0) {
            this.writeTupleto(tGDuration.getTupleto());
        }
    }

    private void writeTupleto(TGTupleto tGTupleto) {
        this.writeByte(tGTupleto.getEnters());
        this.writeByte(tGTupleto.getTimes());
    }

    private void writeNoteEffect(TGNoteEffect tGNoteEffect) {
        int n = 0;
        n = tGNoteEffect.isBend() ? (n = n | 1) : n;
        n = tGNoteEffect.isTremoloBar() ? (n = n | 2) : n;
        n = tGNoteEffect.isHarmonic() ? (n = n | 4) : n;
        n = tGNoteEffect.isGrace() ? (n = n | 8) : n;
        n = tGNoteEffect.isTrill() ? (n = n | 0x10) : n;
        n = tGNoteEffect.isTremoloPicking() ? (n = n | 0x20) : n;
        n = tGNoteEffect.isVibrato() ? (n = n | 0x40) : n;
        n = tGNoteEffect.isDeadNote() ? (n = n | 0x80) : n;
        n = tGNoteEffect.isSlide() ? (n = n | 0x100) : n;
        n = tGNoteEffect.isHammer() ? (n = n | 0x200) : n;
        n = tGNoteEffect.isGhostNote() ? (n = n | 0x400) : n;
        n = tGNoteEffect.isAccentuatedNote() ? (n = n | 0x800) : n;
        n = tGNoteEffect.isHeavyAccentuatedNote() ? (n = n | 0x1000) : n;
        n = tGNoteEffect.isPalmMute() ? (n = n | 0x2000) : n;
        n = tGNoteEffect.isStaccato() ? (n = n | 0x4000) : n;
        n = tGNoteEffect.isTapping() ? (n = n | 0x8000) : n;
        n = tGNoteEffect.isSlapping() ? (n = n | 0x10000) : n;
        n = tGNoteEffect.isPopping() ? (n = n | 0x20000) : n;
        n = tGNoteEffect.isFadeIn() ? (n = n | 0x40000) : n;
        this.writeHeader(n, 3);
        if ((n & 1) != 0) {
            this.writeBendEffect(tGNoteEffect.getBend());
        }
        if ((n & 2) != 0) {
            this.writeTremoloBarEffect(tGNoteEffect.getTremoloBar());
        }
        if ((n & 4) != 0) {
            this.writeHarmonicEffect(tGNoteEffect.getHarmonic());
        }
        if ((n & 8) != 0) {
            this.writeGraceEffect(tGNoteEffect.getGrace());
        }
        if ((n & 0x10) != 0) {
            this.writeTrillEffect(tGNoteEffect.getTrill());
        }
        if ((n & 0x20) != 0) {
            this.writeTremoloPickingEffect(tGNoteEffect.getTremoloPicking());
        }
    }

    private void writeBendEffect(TGEffectBend tGEffectBend) {
        this.writeByte(tGEffectBend.getPoints().size());
        Iterator iterator = tGEffectBend.getPoints().iterator();
        while (iterator.hasNext()) {
            TGEffectBend.BendPoint bendPoint = (TGEffectBend.BendPoint)iterator.next();
            this.writeByte(bendPoint.getPosition());
            this.writeByte(bendPoint.getValue());
        }
    }

    private void writeTremoloBarEffect(TGEffectTremoloBar tGEffectTremoloBar) {
        this.writeByte(tGEffectTremoloBar.getPoints().size());
        Iterator iterator = tGEffectTremoloBar.getPoints().iterator();
        while (iterator.hasNext()) {
            TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint = (TGEffectTremoloBar.TremoloBarPoint)iterator.next();
            this.writeByte(tremoloBarPoint.getPosition());
            this.writeByte(tremoloBarPoint.getValue() + 12);
        }
    }

    private void writeHarmonicEffect(TGEffectHarmonic tGEffectHarmonic) {
        this.writeByte(tGEffectHarmonic.getType());
        if (tGEffectHarmonic.getType() != 1) {
            this.writeByte(tGEffectHarmonic.getData());
        }
    }

    private void writeGraceEffect(TGEffectGrace tGEffectGrace) {
        int n = 0;
        n = tGEffectGrace.isDead() ? (n = n | 1) : n;
        n = tGEffectGrace.isOnBeat() ? (n = n | 2) : n;
        this.writeHeader(n);
        this.writeByte(tGEffectGrace.getFret());
        this.writeByte(tGEffectGrace.getDuration());
        this.writeByte(tGEffectGrace.getDynamic());
        this.writeByte(tGEffectGrace.getTransition());
    }

    private void writeTremoloPickingEffect(TGEffectTremoloPicking tGEffectTremoloPicking) {
        this.writeByte(tGEffectTremoloPicking.getDuration().getValue());
    }

    private void writeTrillEffect(TGEffectTrill tGEffectTrill) {
        this.writeByte(tGEffectTrill.getFret());
        this.writeByte(tGEffectTrill.getDuration().getValue());
    }

    private void writeMarker(TGMarker tGMarker) {
        this.writeUnsignedByteString(tGMarker.getTitle());
        this.writeRGBColor(tGMarker.getColor());
    }

    private void writeRGBColor(TGColor tGColor) {
        this.writeByte(tGColor.getR());
        this.writeByte(tGColor.getG());
        this.writeByte(tGColor.getB());
    }

    private void writeLyrics(TGLyric tGLyric) {
        this.writeShort((short)tGLyric.getFrom());
        this.writeIntegerString(tGLyric.getLyrics());
    }

    public void writeByte(int n) {
        try {
            this.dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeUnsignedByteString(String string) {
        try {
            String string2 = string == null ? new String() : (string.length() > 255 ? string.substring(0, 255) : string);
            this.dataOutputStream.write(string2.length());
            this.dataOutputStream.writeChars(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeIntegerString(String string) {
        try {
            this.dataOutputStream.writeInt(string.length());
            this.dataOutputStream.writeChars(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeHeader(int n) {
        try {
            this.dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeHeader(int n, int n2) {
        for (int i = n2; i > 0; --i) {
            this.writeHeader(n >>> 8 * i - 8 & 0xFF);
        }
    }

    public void writeShort(short s) {
        try {
            this.dataOutputStream.writeShort(s);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

