/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.base.MidiOutputPortProvider;
import org.herac.tuxguitar.player.base.MidiPercussion;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequenceParser;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.base.MidiSequencerEmpty;
import org.herac.tuxguitar.player.base.MidiSequencerProvider;
import org.herac.tuxguitar.player.base.MidiTransmitter;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGLock;

public class MidiPlayer {
    private static final int MAX_CHANNELS = 16;
    public static final int MAX_VOLUME = 10;
    private static final int TIMER_DELAY = 10;
    private TGSongManager songManager;
    private MidiSequencer sequencer;
    private MidiTransmitter outputTransmitter;
    private MidiOutputPort outputPort;
    private MidiPlayerMode mode;
    private String sequencerKey;
    private String outputPortKey;
    private List outputPortProviders;
    private List sequencerProviders;
    private int volume = 10;
    private boolean running;
    private boolean paused;
    private boolean changeTickPosition;
    private boolean metronomeEnabled;
    private int metronomeTrack;
    private int infoTrack;
    private boolean anySolo;
    protected long tickLength;
    protected long tickPosition;
    protected boolean starting;
    protected TGLock lock = new TGLock();

    public void init(TGSongManager tGSongManager) {
        this.songManager = tGSongManager;
        this.outputPortProviders = new ArrayList();
        this.sequencerProviders = new ArrayList();
        this.getSequencer();
        this.getMode();
        this.reset();
    }

    public MidiInstrument[] getInstruments() {
        return MidiInstrument.INSTRUMENT_LIST;
    }

    public MidiPercussion[] getPercussions() {
        return MidiPercussion.PERCUSSION_LIST;
    }

    public void reset() {
        this.stop();
        this.lock.lock();
        this.tickPosition = 960L;
        this.setChangeTickPosition(false);
        this.lock.unlock();
    }

    public void close() {
        try {
            this.closeSequencer();
            this.closeOutputPort();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void stop(boolean bl) {
        try {
            this.setPaused(bl);
            if (this.isRunning()) {
                this.getSequencer().stop();
            }
            this.setRunning(false);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void pause() {
        this.stop(true);
    }

    public synchronized void play() throws MidiPlayerException {
        try {
            this.setStarting(true);
            this.stop();
            this.lock.lock();
            this.checkOutput();
            this.systemReset();
            this.addSecuence();
            this.updatePrograms();
            this.updateControllers();
            this.updateDefaultControllers();
            this.setMetronomeEnabled(this.isMetronomeEnabled());
            this.changeTickPosition();
            this.setRunning(true);
            this.getSequencer().start();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public synchronized void run() {
                    try {
                        MidiPlayer.this.lock.lock();
                        MidiPlayer.this.setStarting(false);
                        MidiPlayer.this.tickLength = MidiPlayer.this.getSequencer().getTickLength();
                        MidiPlayer.this.tickPosition = MidiPlayer.this.getSequencer().getTickPosition();
                        Object object = new Object();
                        while (MidiPlayer.this.getSequencer().isRunning() && MidiPlayer.this.isRunning()) {
                            Object object2 = object;
                            synchronized (object2) {
                                if (MidiPlayer.this.isChangeTickPosition()) {
                                    MidiPlayer.this.changeTickPosition();
                                }
                                MidiPlayer.this.tickPosition = MidiPlayer.this.getSequencer().getTickPosition();
                                object.wait(10L);
                            }
                        }
                        if (MidiPlayer.this.isRunning()) {
                            if (MidiPlayer.this.tickPosition >= MidiPlayer.this.tickLength - 480L) {
                                MidiPlayer.this.finish();
                            } else {
                                MidiPlayer.this.stop(MidiPlayer.this.isPaused());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        MidiPlayer.this.setStarting(false);
                        MidiPlayer.this.reset();
                        throwable.printStackTrace();
                    }
                    finally {
                        MidiPlayer.this.lock.unlock();
                    }
                }
            }).start();
        }
        catch (Throwable throwable) {
            this.setStarting(false);
            this.reset();
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void finish() {
        try {
            if (this.getMode().isLoop()) {
                this.setStarting(true);
                this.reset();
                this.getMode().notifyLoop();
                this.play();
                return;
            }
            this.reset();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void checkOutput() throws Throwable {
        if (this.getOutputPort() != null) {
            this.getOutputPort().check();
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int n) {
        this.volume = n;
        if (this.isRunning()) {
            this.updateControllers();
        }
    }

    protected boolean isStarting() {
        return this.starting;
    }

    protected void setStarting(boolean bl) {
        this.starting = bl;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRunning() {
        try {
            return this.running || this.getSequencer().isRunning() || this.isStarting();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
            return false;
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    protected boolean isChangeTickPosition() {
        return this.changeTickPosition;
    }

    private void setChangeTickPosition(boolean bl) {
        this.changeTickPosition = bl;
    }

    public void setTickPosition(long l) {
        this.tickPosition = l;
        this.setChangeTickPosition(true);
    }

    public long getTickPosition() {
        return this.tickPosition;
    }

    protected void changeTickPosition() {
        try {
            if (this.isRunning()) {
                this.getSequencer().setTickPosition(this.tickPosition);
            }
            this.setChangeTickPosition(false);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void systemReset() {
        try {
            this.getOutputTransmitter().sendSystemReset();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void addSecuence() {
        try {
            MidiSequenceParser midiSequenceParser = new MidiSequenceParser(this.songManager, 4, this.getMode().getCurrentPercent(), 0);
            MidiSequenceHandler midiSequenceHandler = this.getSequencer().createSequence(this.songManager.getSong().countTracks() + 2);
            midiSequenceParser.parse(midiSequenceHandler);
            this.infoTrack = midiSequenceHandler.getInfoTrack();
            this.metronomeTrack = midiSequenceHandler.getMetronomeTrack();
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    private void updateDefaultControllers() {
        try {
            for (int i = 0; i < 16; ++i) {
                this.getOutputTransmitter().sendControlChange(i, 101, 0);
                this.getOutputTransmitter().sendControlChange(i, 100, 0);
                this.getOutputTransmitter().sendControlChange(i, 6, 12);
                this.getOutputTransmitter().sendControlChange(i, 38, 0);
            }
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void updatePrograms() {
        try {
            Iterator iterator = this.songManager.getSong().getTracks();
            while (iterator.hasNext()) {
                TGTrack tGTrack = (TGTrack)iterator.next();
                this.getOutputTransmitter().sendProgramChange(tGTrack.getChannel().getChannel(), tGTrack.getChannel().getInstrument());
                if (tGTrack.getChannel().getChannel() == tGTrack.getChannel().getEffectChannel()) continue;
                this.getOutputTransmitter().sendProgramChange(tGTrack.getChannel().getEffectChannel(), tGTrack.getChannel().getInstrument());
            }
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void updateControllers() {
        this.anySolo = false;
        boolean bl = false;
        Iterator iterator = this.songManager.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.updateController(tGTrack);
            this.anySolo = !this.anySolo ? tGTrack.isSolo() : this.anySolo;
            bl = bl || tGTrack.isPercussionTrack();
        }
        if (!bl && this.isMetronomeEnabled()) {
            int n = (int)((double)this.getVolume() / 10.0 * 127.0);
            int n2 = 64;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            this.updateController(9, n, n2, n3, n4, n5, n6, 127);
        }
        this.afterUpdate();
    }

    private void updateController(TGTrack tGTrack) {
        try {
            int n = (int)((double)this.getVolume() / 10.0 * (double)tGTrack.getChannel().getVolume());
            short s = tGTrack.getChannel().getBalance();
            short s2 = tGTrack.getChannel().getChorus();
            short s3 = tGTrack.getChannel().getReverb();
            short s4 = tGTrack.getChannel().getPhaser();
            short s5 = tGTrack.getChannel().getTremolo();
            this.updateController(tGTrack.getChannel().getChannel(), n, s, s2, s3, s4, s5, 127);
            if (tGTrack.getChannel().getChannel() != tGTrack.getChannel().getEffectChannel()) {
                this.updateController(tGTrack.getChannel().getEffectChannel(), n, s, s2, s3, s4, s5, 127);
            }
            this.getSequencer().setMute(tGTrack.getNumber(), tGTrack.isMute());
            this.getSequencer().setSolo(tGTrack.getNumber(), tGTrack.isSolo());
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    private void updateController(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        try {
            this.getOutputTransmitter().sendControlChange(n, 7, n2);
            this.getOutputTransmitter().sendControlChange(n, 10, n3);
            this.getOutputTransmitter().sendControlChange(n, 93, n4);
            this.getOutputTransmitter().sendControlChange(n, 91, n5);
            this.getOutputTransmitter().sendControlChange(n, 95, n6);
            this.getOutputTransmitter().sendControlChange(n, 92, n7);
            this.getOutputTransmitter().sendControlChange(n, 11, n8);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    private void afterUpdate() {
        try {
            this.getSequencer().setSolo(this.infoTrack, this.anySolo);
            this.getSequencer().setSolo(this.metronomeTrack, this.isMetronomeEnabled() && this.anySolo);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public boolean isMetronomeEnabled() {
        return this.metronomeEnabled;
    }

    public void setMetronomeEnabled(boolean bl) {
        try {
            this.metronomeEnabled = bl;
            this.getSequencer().setMute(this.metronomeTrack, !this.isMetronomeEnabled());
            this.getSequencer().setSolo(this.metronomeTrack, this.isMetronomeEnabled() && this.anySolo);
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void playBeat(TGTrack tGTrack, List list) {
        short s = tGTrack.getChannel().getChannel();
        short s2 = tGTrack.getChannel().getInstrument();
        int n = (int)((double)this.getVolume() / 10.0 * (double)tGTrack.getChannel().getVolume());
        short s3 = tGTrack.getChannel().getBalance();
        short s4 = tGTrack.getChannel().getChorus();
        short s5 = tGTrack.getChannel().getReverb();
        short s6 = tGTrack.getChannel().getPhaser();
        short s7 = tGTrack.getChannel().getTremolo();
        int n2 = list.size();
        int[][] nArray = new int[n2][2];
        for (int i = 0; i < n2; ++i) {
            TGNote tGNote = (TGNote)list.get(i);
            nArray[i][0] = tGTrack.getOffset() + (tGNote.getValue() + ((TGString)tGTrack.getStrings().get(tGNote.getString() - 1)).getValue());
            nArray[i][1] = tGNote.getVelocity();
        }
        this.playBeat(s, s2, n, s3, s4, s5, s6, s7, nArray);
    }

    public void playBeat(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[][] nArray) {
        this.playBeat(n, n2, n3, n4, n5, n6, n7, n8, nArray, 500L, 0);
    }

    public void playBeat(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[][] nArray, long l, int n9) {
        try {
            int n10;
            this.getOutputTransmitter().sendProgramChange(n, n2);
            this.getOutputTransmitter().sendControlChange(n, 7, n3);
            this.getOutputTransmitter().sendControlChange(n, 10, n4);
            this.getOutputTransmitter().sendControlChange(n, 93, n5);
            this.getOutputTransmitter().sendControlChange(n, 91, n6);
            this.getOutputTransmitter().sendControlChange(n, 95, n7);
            this.getOutputTransmitter().sendControlChange(n, 92, n8);
            for (n10 = 0; n10 < nArray.length; ++n10) {
                this.getOutputTransmitter().sendNoteOn(n, nArray[n10][0], nArray[n10][1]);
                if (n9 <= 0) continue;
                Thread.sleep(n9);
            }
            Thread.sleep(l);
            for (n10 = 0; n10 < nArray.length; ++n10) {
                this.getOutputTransmitter().sendNoteOff(n, nArray[n10][0], nArray[n10][1]);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public MidiPlayerMode getMode() {
        if (this.mode == null) {
            this.mode = new MidiPlayerMode();
        }
        return this.mode;
    }

    public MidiTransmitter getOutputTransmitter() {
        if (this.outputTransmitter == null) {
            this.outputTransmitter = new MidiTransmitter();
        }
        return this.outputTransmitter;
    }

    public MidiOutputPort getOutputPort() {
        return this.outputPort;
    }

    public MidiSequencer getSequencer() {
        if (this.sequencer == null) {
            this.sequencer = new MidiSequencerEmpty();
        }
        return this.sequencer;
    }

    public boolean loadSequencer(MidiSequencer midiSequencer) {
        try {
            this.closeSequencer();
            this.sequencer = midiSequencer;
            this.sequencer.open();
            this.sequencer.setTransmitter(this.getOutputTransmitter());
        }
        catch (Throwable throwable) {
            this.sequencer = null;
            return false;
        }
        return true;
    }

    public boolean loadOutputPort(MidiOutputPort midiOutputPort) {
        try {
            this.closeOutputPort();
            this.outputPort = midiOutputPort;
            this.outputPort.open();
            this.getOutputTransmitter().addReceiver(this.outputPort.getKey(), this.outputPort.getReceiver());
        }
        catch (Throwable throwable) {
            this.outputPort = null;
            return false;
        }
        return true;
    }

    public void openOutputPort(String string) {
        this.openOutputPort(string, false);
    }

    public void openOutputPort(String string, boolean bl) {
        this.outputPortKey = string;
        this.openOutputPort(this.listOutputPorts(), bl);
    }

    public void openOutputPort(List list, boolean bl) {
        try {
            if (this.outputPortKey != null && !this.isOutputPortOpen(this.outputPortKey)) {
                this.closeOutputPort();
                for (int i = 0; i < list.size(); ++i) {
                    MidiOutputPort midiOutputPort = (MidiOutputPort)list.get(i);
                    if (!midiOutputPort.getKey().equals(this.outputPortKey) || !this.loadOutputPort(midiOutputPort)) continue;
                    return;
                }
            }
            if (this.getOutputPort() == null && !list.isEmpty() && bl) {
                this.loadOutputPort((MidiOutputPort)list.get(0));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void openSequencer(String string) {
        this.openSequencer(string, false);
    }

    public void openSequencer(String string, boolean bl) {
        try {
            this.sequencerKey = string;
            this.openSequencer(this.listSequencers(), bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void openSequencer(List list, boolean bl) throws MidiPlayerException {
        try {
            if (this.sequencerKey != null && !this.isSequencerOpen(this.sequencerKey)) {
                this.closeSequencer();
                for (int i = 0; i < list.size(); ++i) {
                    MidiSequencer midiSequencer = (MidiSequencer)list.get(i);
                    if (!midiSequencer.getKey().equals(this.sequencerKey) || !this.loadSequencer(midiSequencer)) continue;
                    return;
                }
            }
            if (this.getSequencer() instanceof MidiSequencerEmpty && !list.isEmpty() && bl) {
                this.loadSequencer((MidiSequencer)list.get(0));
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public List listOutputPorts() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.outputPortProviders.iterator();
        while (iterator.hasNext()) {
            try {
                MidiOutputPortProvider midiOutputPortProvider = (MidiOutputPortProvider)iterator.next();
                arrayList.addAll(midiOutputPortProvider.listPorts());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    public List listSequencers() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.sequencerProviders.iterator();
        while (iterator.hasNext()) {
            try {
                MidiSequencerProvider midiSequencerProvider = (MidiSequencerProvider)iterator.next();
                arrayList.addAll(midiSequencerProvider.listSequencers());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    public void closeSequencer() throws MidiPlayerException {
        try {
            if (this.isRunning()) {
                this.stop();
            }
            this.lock.lock();
            if (this.sequencer != null) {
                this.sequencer.close();
                this.sequencer = null;
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public void closeOutputPort() {
        try {
            if (this.isRunning()) {
                this.stop();
            }
            this.lock.lock();
            if (this.outputPort != null) {
                this.getOutputTransmitter().removeReceiver(this.outputPort.getKey());
                this.outputPort.close();
                this.outputPort = null;
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isSequencerOpen(String string) {
        if (string != null) {
            String string2 = this.getSequencer().getKey();
            if (string2 == null) {
                return false;
            }
            return string2.equals(string);
        }
        return false;
    }

    public boolean isOutputPortOpen(String string) {
        if (string != null && this.getOutputPort() != null) {
            String string2 = this.getOutputPort().getKey();
            if (string2 == null) {
                return false;
            }
            return string2.equals(string);
        }
        return false;
    }

    public void addOutputPortProvider(MidiOutputPortProvider midiOutputPortProvider) throws MidiPlayerException {
        this.addOutputPortProvider(midiOutputPortProvider, false);
    }

    public void addOutputPortProvider(MidiOutputPortProvider midiOutputPortProvider, boolean bl) throws MidiPlayerException {
        this.outputPortProviders.add(midiOutputPortProvider);
        this.openOutputPort(midiOutputPortProvider.listPorts(), bl);
    }

    public void addSequencerProvider(MidiSequencerProvider midiSequencerProvider) throws MidiPlayerException {
        this.addSequencerProvider(midiSequencerProvider, false);
    }

    public void addSequencerProvider(MidiSequencerProvider midiSequencerProvider, boolean bl) throws MidiPlayerException {
        this.sequencerProviders.add(midiSequencerProvider);
        this.openSequencer(midiSequencerProvider.listSequencers(), bl);
    }

    public void removeOutputPortProvider(MidiOutputPortProvider midiOutputPortProvider) throws MidiPlayerException {
        this.outputPortProviders.remove(midiOutputPortProvider);
        MidiOutputPort midiOutputPort = this.getOutputPort();
        if (midiOutputPort != null) {
            Iterator iterator = midiOutputPortProvider.listPorts().iterator();
            while (iterator.hasNext()) {
                MidiOutputPort midiOutputPort2 = (MidiOutputPort)iterator.next();
                if (!midiOutputPort2.getKey().equals(midiOutputPort.getKey())) continue;
                this.closeOutputPort();
                break;
            }
        }
    }

    public void removeSequencerProvider(MidiSequencerProvider midiSequencerProvider) throws MidiPlayerException {
        this.sequencerProviders.remove(midiSequencerProvider);
        MidiSequencer midiSequencer = this.getSequencer();
        if (!(midiSequencer instanceof MidiSequencerEmpty) && midiSequencer != null) {
            Iterator iterator = midiSequencerProvider.listSequencers().iterator();
            while (iterator.hasNext()) {
                MidiSequencer midiSequencer2 = (MidiSequencer)iterator.next();
                if (!midiSequencer.getKey().equals(midiSequencer2.getKey())) continue;
                this.closeSequencer();
                break;
            }
        }
    }
}

