/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

public class MidiPlayerMode {
    public static final int DEFAULT_TEMPO_PERCENT = 100;
    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_CUSTOM = 2;
    private int type = 1;
    private boolean loop = false;
    private int singlePercent = 100;
    private int customPercentFrom = 100;
    private int customPercentTo = 100;
    private int customPercentIncrement = 0;
    private int currentPercent;

    public MidiPlayerMode() {
        this.reset();
    }

    public void reset() {
        if (this.getType() == 1) {
            this.currentPercent = this.getSinglePercent();
        } else if (this.getType() == 2) {
            this.currentPercent = this.getCustomPercentFrom();
        }
    }

    public void notifyLoop() {
        if (this.getType() == 1) {
            this.currentPercent = this.getSinglePercent();
        } else if (this.getType() == 2) {
            this.currentPercent = Math.min(this.getCustomPercentTo(), this.getCurrentPercent() + this.getCustomPercentIncrement());
        }
    }

    public int getCurrentPercent() {
        return this.currentPercent;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean bl) {
        this.loop = bl;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getCustomPercentFrom() {
        return this.customPercentFrom;
    }

    public void setCustomPercentFrom(int n) {
        this.customPercentFrom = n;
    }

    public int getCustomPercentIncrement() {
        return this.customPercentIncrement;
    }

    public void setCustomPercentIncrement(int n) {
        this.customPercentIncrement = n;
    }

    public int getCustomPercentTo() {
        return this.customPercentTo;
    }

    public void setCustomPercentTo(int n) {
        this.customPercentTo = n;
    }

    public int getSinglePercent() {
        return this.singlePercent;
    }

    public void setSinglePercent(int n) {
        this.singlePercent = n;
    }
}

