/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.sequencer.MidiEvent;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequencerImpl;

public class MidiEventPlayer {
    private MidiSequencerImpl sequencer;
    private List events;
    private long tick;
    private long lastTick;
    private boolean reset;

    public MidiEventPlayer(MidiSequencerImpl midiSequencerImpl) {
        this.sequencer = midiSequencerImpl;
        this.events = new ArrayList();
        this.reset();
    }

    public void process() throws MidiPlayerException {
        this.lastTick = this.tick;
        this.tick = this.sequencer.getTickPosition();
        for (int i = 0; i < this.events.size(); ++i) {
            MidiEvent midiEvent = (MidiEvent)this.events.get(i);
            if (!this.shouldSend(midiEvent, this.tick, this.lastTick)) continue;
            this.sequencer.sendEvent(midiEvent);
        }
        this.reset = false;
    }

    private boolean shouldSend(MidiEvent midiEvent, long l, long l2) {
        if (midiEvent.getTick() > l) {
            return false;
        }
        if (midiEvent.getTrack() != -1) {
            if (this.sequencer.getMidiTrackController().isMute(midiEvent.getTrack())) {
                return false;
            }
            if (this.sequencer.getMidiTrackController().isAnySolo() && !this.sequencer.getMidiTrackController().isSolo(midiEvent.getTrack())) {
                return false;
            }
        }
        if (this.reset) {
            if (midiEvent.getType() == 1) {
                return true;
            }
            if (midiEvent.getType() == 5) {
                return true;
            }
            if (midiEvent.getType() == 4) {
                return true;
            }
        }
        return midiEvent.getTick() > l2;
    }

    public void addEvent(MidiEvent midiEvent) {
        this.events.add(midiEvent);
    }

    public void clearEvents() {
        this.events.clear();
    }

    public void reset() {
        this.tick = this.sequencer.getTickPosition() - 1L;
        this.reset = true;
    }
}

