/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.helpers.TGSongSegment;
import org.herac.tuxguitar.song.helpers.TGTrackSegment;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.managers.TGTrackManager;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGSongSegmentHelper {
    private TGSongManager sm;

    public TGSongSegmentHelper(TGSongManager tGSongManager) {
        this.sm = tGSongManager;
    }

    public TGSongSegment copyMeasures(int n, int n2) {
        TGSongSegment tGSongSegment = new TGSongSegment();
        int n3 = Math.max(1, n);
        int n4 = Math.min(this.sm.getSong().countMeasureHeaders(), n2);
        for (int i = n3; i <= n4; ++i) {
            tGSongSegment.getHeaders().add(this.sm.getMeasureHeader(i));
        }
        Iterator iterator = this.sm.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            ArrayList<TGMeasure> arrayList = new ArrayList<TGMeasure>();
            for (int i = n3; i <= n4; ++i) {
                arrayList.add(this.sm.getTrackManager().getMeasure(tGTrack, i));
            }
            tGSongSegment.addTrack(tGTrack.getNumber(), arrayList);
        }
        return tGSongSegment.clone(this.sm.getFactory());
    }

    public TGSongSegment copyMeasures(int n, int n2, TGTrack tGTrack) {
        TGSongSegment tGSongSegment = new TGSongSegment();
        ArrayList<TGMeasure> arrayList = new ArrayList<TGMeasure>();
        int n3 = Math.max(1, n);
        int n4 = Math.min(this.sm.getSong().countMeasureHeaders(), n2);
        for (int i = n3; i <= n4; ++i) {
            tGSongSegment.getHeaders().add(this.sm.getMeasureHeader(i));
            arrayList.add(this.sm.getTrackManager().getMeasure(tGTrack, i));
        }
        tGSongSegment.addTrack(tGTrack.getNumber(), arrayList);
        return tGSongSegment.clone(this.sm.getFactory());
    }

    public void insertMeasures(TGSongSegment tGSongSegment, int n, long l, int n2) {
        Object object;
        ArrayList<TGMeasureHeader> arrayList = new ArrayList<TGMeasureHeader>();
        this.sm.moveMeasureHeaders(tGSongSegment.getHeaders(), l, 0, false);
        int n3 = n;
        Iterator iterator = tGSongSegment.getHeaders().iterator();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            tGMeasureHeader.setNumber(n3);
            arrayList.add(tGMeasureHeader);
            ++n3;
        }
        long l2 = ((TGMeasureHeader)arrayList.get(0)).getStart();
        long l3 = ((TGMeasureHeader)arrayList.get(arrayList.size() - 1)).getStart() + ((TGMeasureHeader)arrayList.get(arrayList.size() - 1)).getLength();
        List list = this.sm.getMeasureHeadersBeforeEnd(l2);
        this.sm.moveMeasureHeaders(list, l3 - l2, arrayList.size(), true);
        iterator = tGSongSegment.getHeaders().iterator();
        while (iterator.hasNext()) {
            object = (TGMeasureHeader)iterator.next();
            this.sm.addMeasureHeader(((TGMeasureHeader)object).getNumber() - 1, (TGMeasureHeader)object);
        }
        iterator = this.sm.getSong().getTracks();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure;
            Object object2;
            object = (TGTrack)iterator.next();
            List list2 = null;
            Iterator iterator2 = tGSongSegment.getTracks().iterator();
            while (iterator2.hasNext()) {
                object2 = (TGTrackSegment)iterator2.next();
                if ((n2 > 0 && tGSongSegment.getTracks().size() == 1 ? n2 : ((TGTrackSegment)object2).getTrack()) != ((TGTrack)object).getNumber()) continue;
                list2 = ((TGTrackSegment)object2).getMeasures();
                break;
            }
            if (list2 == null) {
                object2 = this.sm.getTrackManager();
                tGMeasure = n > 1 ? ((TGTrackManager)object2).getMeasure((TGTrack)object, n - 1) : ((TGTrackManager)object2).getMeasure((TGTrack)object, n3);
                int n4 = tGMeasure != null ? tGMeasure.getClef() : 1;
                int n5 = tGMeasure != null ? tGMeasure.getKeySignature() : 0;
                list2 = this.getEmptyMeasures(tGSongSegment.getHeaders().size(), n4, n5);
            }
            for (int i = 0; i < list2.size(); ++i) {
                tGMeasure = (TGMeasure)list2.get(i);
                tGMeasure.setHeader((TGMeasureHeader)arrayList.get(i));
                this.sm.getMeasureManager().moveAllBeats(tGMeasure, l);
            }
            this.insertMeasures((TGTrack)object, list2);
        }
    }

    public void insertMeasures(TGTrack tGTrack, List list) {
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TGMeasure tGMeasure = (TGMeasure)iterator.next();
                this.sm.getMeasureManager().removeNotesAfterString(tGMeasure, tGTrack.stringCount());
                this.sm.getTrackManager().addMeasure(tGTrack, tGMeasure.getNumber() - 1, tGMeasure);
            }
        }
    }

    public void replaceMeasures(TGSongSegment tGSongSegment, long l, int n) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.sm.moveMeasureHeaders(tGSongSegment.getHeaders(), l, 0, false);
        Iterator iterator = tGSongSegment.getHeaders().iterator();
        while (iterator.hasNext()) {
            object3 = (TGMeasureHeader)iterator.next();
            object2 = this.sm.replaceMeasureHeader((TGMeasureHeader)object3);
            object = this.sm.getMeasureHeadersAfter(((TGMeasureHeader)object2).getNumber()).iterator();
            long l2 = ((TGMeasureHeader)object2).getStart() + ((TGMeasureHeader)object2).getLength();
            while (object.hasNext()) {
                TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)object.next();
                this.sm.moveMeasureComponents(tGMeasureHeader, l2 - tGMeasureHeader.getStart());
                this.sm.moveMeasureHeader(tGMeasureHeader, l2 - tGMeasureHeader.getStart(), 0);
                l2 = tGMeasureHeader.getStart() + tGMeasureHeader.getLength();
            }
            arrayList.add(object2);
        }
        object3 = tGSongSegment.getTracks().iterator();
        while (object3.hasNext()) {
            object2 = (TGTrackSegment)object3.next();
            object = this.sm.getTrack(n > 0 && tGSongSegment.getTracks().size() == 1 ? n : ((TGTrackSegment)object2).getTrack());
            if (object == null) continue;
            for (int i = 0; i < ((TGTrackSegment)object2).getMeasures().size(); ++i) {
                TGMeasure tGMeasure = (TGMeasure)((TGTrackSegment)object2).getMeasures().get(i);
                tGMeasure.setHeader((TGMeasureHeader)arrayList.get(i));
                this.sm.getMeasureManager().removeNotesAfterString(tGMeasure, ((TGTrack)object).stringCount());
                this.sm.getMeasureManager().moveAllBeats(tGMeasure, l);
                this.sm.getTrackManager().replaceMeasure((TGTrack)object, tGMeasure);
            }
        }
    }

    private List getEmptyMeasures(int n, int n2, int n3) {
        ArrayList<TGMeasure> arrayList = new ArrayList<TGMeasure>();
        for (int i = 0; i < n; ++i) {
            TGMeasure tGMeasure = this.sm.getFactory().newMeasure(null);
            tGMeasure.setClef(n2);
            tGMeasure.setKeySignature(n3);
            arrayList.add(tGMeasure);
        }
        return arrayList;
    }
}

