/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class TGTempo {
    private static final int SECOND_IN_MILLIS = 1000;
    private int value = 120;

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public long getInMillis() {
        double d = 60.0 / (double)this.getValue() * 1000.0;
        return (long)d;
    }

    public long getInUSQ() {
        double d = 60.0 / (double)this.getValue() * 1000.0 * 1000.0;
        return (long)d;
    }

    public static TGTempo fromUSQ(TGFactory tGFactory, int n) {
        double d = 60000.0 / ((double)n / 1000.0);
        TGTempo tGTempo = tGFactory.newTempo();
        tGTempo.setValue((int)d);
        return tGTempo;
    }

    public TGTempo clone(TGFactory tGFactory) {
        TGTempo tGTempo = tGFactory.newTempo();
        this.copy(tGTempo);
        return tGTempo;
    }

    public void copy(TGTempo tGTempo) {
        tGTempo.setValue(this.getValue());
    }
}

