/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.herac.tuxguitar.song.models.TGVoice;

public class LilypondOutputStream {
    private static final String LILYPOND_VERSION = "2.10.5";
    private static final String[] LILYPOND_SHARP_NOTES = new String[]{"c", "cis", "d", "dis", "e", "f", "fis", "g", "gis", "a", "ais", "b"};
    private static final String[] LILYPOND_FLAT_NOTES = new String[]{"c", "des", "d", "ees", "e", "f", "ges", "g", "aes", "a", "bes", "b"};
    private static final String[] LILYPOND_KEY_SIGNATURES = new String[]{"c", "g", "d", "a", "e", "b", "fis", "cis", "f", "bes", "ees", "aes", "des", "ges", "ces"};
    private static final String INDENT = new String("   ");
    private TGSongManager manager;
    private PrintWriter writer;
    private LilypondSettings settings;
    private LilypondTempData temp;

    public LilypondOutputStream(OutputStream outputStream, LilypondSettings lilypondSettings) {
        this.writer = new PrintWriter(outputStream);
        this.temp = new LilypondTempData();
        this.settings = lilypondSettings;
    }

    public void writeSong(TGSong tGSong) {
        this.manager = new TGSongManager();
        this.manager.setSong(tGSong);
        this.addVersion();
        this.addPaper(tGSong);
        this.addLayout();
        this.addSongDefinitions(tGSong);
        this.addSong(tGSong);
        this.writer.flush();
        this.writer.close();
    }

    private void addVersion() {
        this.writer.println("\\version \"2.10.5\"");
    }

    private void addPaper(TGSong tGSong) {
        this.writer.println("\\paper {");
        this.writer.println(this.indent(1) + "indent = #" + (this.addTrackTitleOnGroup(tGSong) ? 30 : 0));
        this.writer.println(this.indent(1) + "printallheaders = #" + this.getLilypondBoolean(true));
        this.writer.println(this.indent(1) + "ragged-right = #" + this.getLilypondBoolean(false));
        this.writer.println(this.indent(1) + "ragged-bottom = #" + this.getLilypondBoolean(true));
        this.writer.println("}");
    }

    private void addHeader(TGSong tGSong, String string, int n) {
        this.writer.println(this.indent(n) + "\\header {");
        this.writer.println(this.indent(n + 1) + "title = \"" + tGSong.getName() + "\" ");
        this.writer.println(this.indent(n + 1) + "composer = \"" + tGSong.getAuthor() + "\" ");
        if (this.settings.isTrackNameEnabled() && !this.addTrackTitleOnGroup(tGSong) && string != null) {
            this.writer.println(this.indent(n + 1) + "instrument = \"" + string + "\" ");
        }
        this.writer.println(this.indent(n) + "}");
    }

    private void addLayout() {
        this.writer.println("\\layout {");
        this.writer.println(this.indent(1) + "\\context { \\Score");
        this.writer.println(this.indent(2) + "\\override MetronomeMark #'padding = #'5");
        this.writer.println(this.indent(1) + "}");
        this.writer.println(this.indent(1) + "\\context { \\Staff");
        this.writer.println(this.indent(2) + "\\override TimeSignature #'style = #'numbered");
        this.writer.println(this.indent(2) + "\\override StringNumber #'transparent = #" + this.getLilypondBoolean(true));
        this.writer.println(this.indent(1) + "}");
        this.writer.println(this.indent(1) + "\\context { \\TabStaff");
        this.writer.println(this.indent(2) + "\\override TimeSignature #'style = #'numbered");
        this.writer.println(this.indent(2) + "\\override Stem #'transparent = #" + this.getLilypondBoolean(this.settings.isScoreEnabled()));
        this.writer.println(this.indent(2) + "\\override Beam #'transparent = #" + this.getLilypondBoolean(this.settings.isScoreEnabled()));
        this.writer.println(this.indent(1) + "}");
        this.writer.println(this.indent(1) + "\\context { \\StaffGroup");
        this.writer.println(this.indent(2) + "\\consists \"Instrument_name_engraver\"");
        this.writer.println(this.indent(1) + "}");
        this.writer.println("}");
    }

    private void addSongDefinitions(TGSong tGSong) {
        for (int i = 0; i < tGSong.countTracks(); ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            String string = this.trackID(i, "");
            this.temp.reset();
            this.addMusic(tGTrack, string);
            this.addLyrics(tGTrack, string);
            this.addScoreStaff(tGTrack, string);
            this.addTabStaff(tGTrack, string);
            this.addStaffGroup(tGTrack, string);
        }
    }

    private void addSong(TGSong tGSong) {
        int n = tGSong.countTracks();
        if (this.settings.isTrackGroupEnabled() && n > 1) {
            this.writer.println("\\score {");
            if (this.settings.getTrack() == -1) {
                this.writer.println(this.indent(1) + "<<");
            }
        }
        for (int i = 0; i < n; ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            if (this.settings.getTrack() != -1 && this.settings.getTrack() != tGTrack.getNumber()) continue;
            if (!this.settings.isTrackGroupEnabled() || n == 1) {
                this.writer.println("\\score {");
            }
            this.writer.println(this.indent(1) + "\\" + this.trackID(i, "StaffGroup"));
            if (this.settings.isTrackGroupEnabled() && n != 1) continue;
            this.addHeader(tGSong, tGTrack.getName(), 1);
            this.writer.println("}");
        }
        if (this.settings.isTrackGroupEnabled() && n > 1) {
            if (this.settings.getTrack() == -1) {
                this.writer.println(this.indent(1) + ">>");
            }
            this.addHeader(tGSong, null, 1);
            this.writer.println("}");
        }
    }

    private void addMusic(TGTrack tGTrack, String string) {
        this.writer.println(string + "Music = #(define-music-function (parser location inTab) (boolean?)");
        this.writer.println("#{");
        TGMeasure tGMeasure = null;
        int n = tGTrack.countMeasures();
        for (int i = 0; i < n; ++i) {
            TGMeasure tGMeasure2 = tGTrack.getMeasure(i);
            TGMeasure tGMeasure3 = new TGVoiceJoiner(this.manager.getFactory(), tGMeasure2).process();
            int n2 = this.settings.getMeasureFrom();
            int n3 = this.settings.getMeasureTo();
            if (n2 > tGMeasure3.getNumber() && n2 != -1 || n3 < tGMeasure3.getNumber() && n3 != -1) continue;
            this.addMeasure(tGMeasure3, tGMeasure, 1, i == n - 1);
            tGMeasure = tGMeasure3;
        }
        this.writer.println(this.indent(1) + "\\bar \"|.\"");
        this.writer.println(this.indent(1) + "\\pageBreak");
        this.writer.println("#})");
    }

    private void addScoreStaff(TGTrack tGTrack, String string) {
        boolean bl = this.settings.isLyricsEnabled() && !this.settings.isTablatureEnabled() && !tGTrack.getLyrics().isEmpty();
        boolean bl2 = this.settings.isChordDiagramEnabled();
        boolean bl3 = this.settings.isTextEnabled();
        this.writer.println(string + "Staff = \\new " + (bl ? "Voice = \"" + string + "Staff\" <<" : "Staff {"));
        if (!bl2) {
            this.writer.println(this.indent(1) + "\\removeWithTag #'chords");
        }
        if (!bl3) {
            this.writer.println(this.indent(1) + "\\removeWithTag #'texts");
        }
        this.writer.println(this.indent(1) + "\\" + string + "Music #" + this.getLilypondBoolean(false));
        if (bl) {
            this.writer.println(this.indent(1) + "\\new Lyrics \\lyricsto \"" + string + "Staff\" \\" + string + "Lyrics");
        }
        this.writer.println(bl ? ">>" : "}");
    }

    private void addTabStaff(TGTrack tGTrack, String string) {
        boolean bl = this.settings.isLyricsEnabled() && !tGTrack.getLyrics().isEmpty();
        boolean bl2 = this.settings.isChordDiagramEnabled() && !this.settings.isScoreEnabled();
        boolean bl3 = this.settings.isTextEnabled() && !this.settings.isScoreEnabled();
        this.writer.println(string + "TabStaff = \\new " + (bl ? "TabVoice = \"" + string + "TabStaff\" <<" : "TabStaff {"));
        this.addTuning(tGTrack, 1);
        if (!bl2) {
            this.writer.println(this.indent(1) + "\\removeWithTag #'chords");
        }
        if (!bl3) {
            this.writer.println(this.indent(1) + "\\removeWithTag #'texts");
        }
        this.writer.println(this.indent(1) + "\\" + string + "Music #" + this.getLilypondBoolean(true));
        if (bl) {
            this.writer.println(this.indent(1) + "\\new Lyrics \\lyricsto \"" + string + "TabStaff\" \\" + string + "Lyrics");
        }
        this.writer.println(bl ? ">>" : "}");
    }

    private void addLyrics(TGTrack tGTrack, String string) {
        this.writer.println(string + "Lyrics = \\lyricmode {");
        this.writer.println(this.indent(1) + "\\set ignoreMelismata = #" + this.getLilypondBoolean(true));
        int n = this.temp.getSkippedLyricBeats().size();
        if (n > 0) {
            this.writer.print(this.indent(1));
            for (int i = 0; i < n; ++i) {
                this.writer.print("\\skip " + (String)this.temp.getSkippedLyricBeats().get(i) + " ");
            }
            this.writer.println();
        }
        this.writer.println(this.indent(1) + tGTrack.getLyrics().getLyrics());
        this.writer.println(this.indent(1) + "\\unset ignoreMelismata");
        this.writer.println("}");
    }

    private void addTuning(TGTrack tGTrack, int n) {
        this.writer.print(this.indent(n) + "\\set TabStaff.stringTunings = #'(");
        Iterator iterator = tGTrack.getStrings().iterator();
        while (iterator.hasNext()) {
            TGString tGString = (TGString)iterator.next();
            this.writer.print(tGString.getValue() - 60 + " ");
        }
        this.writer.println(")");
    }

    private void addStaffGroup(TGTrack tGTrack, String string) {
        this.writer.println(string + "StaffGroup = \\new StaffGroup <<");
        if (this.addTrackTitleOnGroup(tGTrack.getSong())) {
            this.writer.println(this.indent(1) + "\\set StaffGroup.instrumentName = #\"" + tGTrack.getName() + "\"");
        }
        if (this.settings.isScoreEnabled()) {
            this.writer.println(this.indent(1) + "\\" + string + "Staff");
        }
        if (this.settings.isTablatureEnabled()) {
            this.writer.println(this.indent(1) + "\\" + string + "TabStaff");
        }
        this.writer.println(">>");
    }

    private void addMeasure(TGMeasure tGMeasure, TGMeasure tGMeasure2, int n, boolean bl) {
        if (tGMeasure2 == null || tGMeasure.getTempo().getValue() != tGMeasure2.getTempo().getValue()) {
            this.addTempo(tGMeasure.getTempo(), n);
        }
        if (tGMeasure2 == null || tGMeasure.getClef() != tGMeasure2.getClef()) {
            this.addClef(tGMeasure.getClef(), n);
        }
        if (tGMeasure2 == null || tGMeasure.getKeySignature() != tGMeasure2.getKeySignature()) {
            this.addKeySignature(tGMeasure.getKeySignature(), n);
        }
        if (tGMeasure2 == null || !tGMeasure.getTimeSignature().isEqual(tGMeasure2.getTimeSignature())) {
            this.addTimeSignature(tGMeasure.getTimeSignature(), n);
        }
        if (tGMeasure.isRepeatOpen()) {
            this.addRepeatOpen(tGMeasure.getHeader(), n);
        } else if (tGMeasure.getNumber() == 1) {
            this.checkRepeatCount(tGMeasure.getHeader());
            if (this.temp.getRepeatCount() > 0) {
                this.addRepeatOpen(tGMeasure.getHeader(), n);
            }
        }
        if (!tGMeasure.isRepeatOpen() && tGMeasure.getHeader().getRepeatAlternative() > 0) {
            this.addRepeatAlternativeOpen(n);
        }
        this.addMeasureComponents(tGMeasure, this.temp.isRepeatOpen() || this.temp.isRepeatAlternativeOpen() ? n + 1 : n);
        if (this.temp.isRepeatAlternativeOpen() && this.temp.getRepeatAlternativeNumber() >= this.temp.getRepeatCount()) {
            this.addRepeatClose(n);
            this.addRepeatAlternativeClose(n);
        }
        if (tGMeasure.getRepeatClose() > 0) {
            this.addRepeatClose(n);
        }
        if (bl) {
            this.addRepeatClose(n);
            this.addRepeatAlternativeClose(n);
        }
    }

    private void addRepeatOpen(TGMeasureHeader tGMeasureHeader, int n) {
        this.addRepeatClose(n);
        this.addRepeatAlternativeClose(n);
        this.checkRepeatCount(tGMeasureHeader);
        this.writer.println(this.indent(n) + "\\repeat volta " + this.temp.getRepeatCount() + " {");
        this.temp.setRepeatOpen(true);
    }

    private void addRepeatClose(int n) {
        if (this.temp.isRepeatOpen()) {
            this.writer.println(this.indent(n) + "}");
        }
        this.temp.setRepeatOpen(false);
        if (!this.temp.isRepeatAlternativeOpen()) {
            this.temp.setRepeatCount(0);
        }
    }

    private void addRepeatAlternativeOpen(int n) {
        if (this.temp.isRepeatOpen() && !this.temp.isRepeatAlternativeOpen()) {
            this.temp.setRepeatAlternativeOpen(true);
            this.addRepeatClose(n);
            this.writer.println(this.indent(n) + "\\alternative {");
        }
        if (this.temp.isRepeatAlternativeOpen()) {
            if (this.temp.getRepeatAlternativeNumber() > 0) {
                this.writer.println(this.indent(n) + "}");
            }
            this.writer.println(this.indent(n) + "{");
            this.temp.setRepeatAlternativeNumber(this.temp.getRepeatAlternativeNumber() + 1);
        }
    }

    private void addRepeatAlternativeClose(int n) {
        if (this.temp.isRepeatAlternativeOpen()) {
            if (this.temp.getRepeatAlternativeNumber() > 0) {
                this.writer.println(this.indent(n) + "}");
            }
            this.writer.println(this.indent(n) + "}");
        }
        this.temp.setRepeatAlternativeOpen(false);
        this.temp.setRepeatAlternativeNumber(0);
        if (!this.temp.isRepeatOpen()) {
            this.temp.setRepeatCount(0);
        }
    }

    private void addTempo(TGTempo tGTempo, int n) {
        this.writer.println(this.indent(n) + "\\tempo 4=" + tGTempo.getValue());
    }

    private void addTimeSignature(TGTimeSignature tGTimeSignature, int n) {
        this.writer.println(this.indent(n) + "\\time " + tGTimeSignature.getNumerator() + "/" + tGTimeSignature.getDenominator().getValue());
    }

    private void addKeySignature(int n, int n2) {
        if (n >= 0 && n < LILYPOND_KEY_SIGNATURES.length) {
            this.writer.println(this.indent(n2) + "\\key " + LILYPOND_KEY_SIGNATURES[n] + " \\major");
        }
    }

    private void addClef(int n, int n2) {
        String string = "";
        if (n == 1) {
            string = "treble";
        } else if (n == 2) {
            string = "bass";
        } else if (n == 4) {
            string = "alto";
        } else if (n == 3) {
            string = "tenor";
        }
        if (string != "") {
            this.writer.println(this.indent(n2) + "\\clef #(if $inTab \"tab\" \"" + string + "_8\")");
        }
    }

    private void addMeasureComponents(TGMeasure tGMeasure, int n) {
        this.writer.print(this.indent(n));
        this.addComponents(tGMeasure);
        this.writer.println();
    }

    private void addComponents(TGMeasure tGMeasure) {
        int n = tGMeasure.getKeySignature();
        TGBeat tGBeat = null;
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat2 = tGMeasure.getBeat(i);
            TGVoice tGVoice = tGBeat2.getVoice(0);
            TGTupleto tGTupleto = tGVoice.getDuration().getTupleto();
            if (tGBeat != null && this.temp.isTupletOpen() && !tGTupleto.isEqual(tGBeat.getVoice(0).getDuration().getTupleto())) {
                this.writer.print("} ");
                this.temp.setTupletOpen(false);
            }
            if (!this.temp.isTupletOpen() && !tGTupleto.isEqual(TGTupleto.NORMAL)) {
                this.writer.print("\\times " + tGTupleto.getTimes() + "/" + tGTupleto.getEnters() + " {");
                this.temp.setTupletOpen(true);
            }
            this.addBeat(n, tGBeat2);
            tGBeat = tGBeat2;
        }
        if (this.temp.isTupletOpen()) {
            this.writer.print("} ");
            this.temp.setTupletOpen(false);
        }
    }

    private void addBeat(int n, TGBeat tGBeat) {
        TGVoice tGVoice = tGBeat.getVoice(0);
        if (tGVoice.isRestVoice()) {
            this.writer.print("r");
            this.addDuration(tGVoice.getDuration());
        } else {
            int n2 = tGVoice.countNotes();
            if (n2 > 1) {
                this.writer.print("<");
            }
            for (int i = 0; i < n2; ++i) {
                TGNote tGNote = tGVoice.getNote(i);
                int n3 = tGBeat.getMeasure().getTrack().getString(tGNote.getString()).getValue() + tGNote.getValue();
                this.addKey(n, n3);
                if (n2 <= 1) {
                    this.addDuration(tGVoice.getDuration());
                }
                this.addString(tGNote.getString());
                if (this.isAnyTiedTo(tGNote)) {
                    this.writer.print("~");
                }
                if (n2 <= 1) continue;
                this.writer.print(" ");
            }
            if (n2 > 1) {
                this.writer.print(">");
                this.addDuration(tGVoice.getDuration());
            }
            if (tGBeat.isChordBeat()) {
                this.writer.print("-\\tag #'chords ^\\markup \\fret-diagram #\"");
                TGChord tGChord = tGBeat.getChord();
                for (int i = 0; i < tGChord.countStrings(); ++i) {
                    this.writer.print(i + 1 + "-" + this.getLilypondChordFret(tGChord.getFretValue(i)) + ";");
                }
                this.writer.print("\"");
            }
            if (tGBeat.isTextBeat()) {
                this.writer.print("-\\tag #'texts ^\\markup {\"" + tGBeat.getText().getValue() + "\"}");
            }
            if (tGBeat.getMeasure().getTrack().getLyrics().getFrom() > tGBeat.getMeasure().getNumber()) {
                this.temp.addSkippedLyricBeat(this.getLilypondDuration(tGVoice.getDuration()));
            }
            this.writer.print(" ");
        }
    }

    private void addKey(int n, int n2) {
        int n3;
        String[] stringArray = n <= 7 ? LILYPOND_SHARP_NOTES : LILYPOND_FLAT_NOTES;
        this.writer.print(stringArray[n2 % 12]);
        for (n3 = 4; n3 < n2 / 12; ++n3) {
            this.writer.print("'");
        }
        for (n3 = n2 / 12; n3 < 4; ++n3) {
            this.writer.print(",");
        }
    }

    private void addString(int n) {
        this.writer.print("\\" + n);
    }

    private void addDuration(TGDuration tGDuration) {
        this.writer.print(this.getLilypondDuration(tGDuration));
    }

    private void checkRepeatCount(TGMeasureHeader tGMeasureHeader) {
        boolean bl = false;
        TGMeasureHeader tGMeasureHeader2 = tGMeasureHeader;
        while (!(tGMeasureHeader2 == null || tGMeasureHeader2.isRepeatOpen() && tGMeasureHeader2.getNumber() != tGMeasureHeader.getNumber())) {
            if (tGMeasureHeader2.getNumber() > tGMeasureHeader.getNumber() && tGMeasureHeader2.getRepeatAlternative() > 0) {
                bl = true;
                this.temp.setRepeatCount(this.temp.getRepeatCount() + 1);
            } else if (!bl && tGMeasureHeader2.getRepeatClose() > 0) {
                this.temp.setRepeatCount(tGMeasureHeader2.getRepeatClose() + 1);
                break;
            }
            tGMeasureHeader2 = this.manager.getNextMeasureHeader(tGMeasureHeader2);
        }
    }

    private boolean addTrackTitleOnGroup(TGSong tGSong) {
        return this.settings.isTrackNameEnabled() && this.settings.isTrackGroupEnabled() && this.settings.getTrack() == -1 && tGSong.countTracks() > 1;
    }

    private boolean isAnyTiedTo(TGNote tGNote) {
        TGMeasure tGMeasure = tGNote.getVoice().getBeat().getMeasure();
        TGBeat tGBeat = this.manager.getMeasureManager().getNextBeat(tGMeasure.getBeats(), tGNote.getVoice().getBeat());
        while (tGMeasure != null) {
            while (tGBeat != null) {
                TGVoice tGVoice = tGBeat.getVoice(0);
                if (tGVoice.isRestVoice()) {
                    return false;
                }
                Iterator iterator = tGVoice.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNote tGNote2 = (TGNote)iterator.next();
                    if (tGNote2.getString() != tGNote.getString()) continue;
                    return tGNote2.isTiedNote();
                }
                tGBeat = this.manager.getMeasureManager().getNextBeat(tGMeasure.getBeats(), tGBeat);
            }
            tGMeasure = this.manager.getTrackManager().getNextMeasure(tGMeasure);
            if (tGMeasure == null) continue;
            tGBeat = this.manager.getMeasureManager().getFirstBeat(tGMeasure.getBeats());
        }
        return false;
    }

    private String indent(int n) {
        String string = new String();
        for (int i = 0; i < n; ++i) {
            string = string + INDENT;
        }
        return string;
    }

    private String getLilypondBoolean(boolean bl) {
        return bl ? "#t" : "#f";
    }

    private String getLilypondDuration(TGDuration tGDuration) {
        String string = Integer.toString(tGDuration.getValue());
        if (tGDuration.isDotted()) {
            string = string + ".";
        } else if (tGDuration.isDoubleDotted()) {
            string = string + "..";
        }
        return string;
    }

    private String getLilypondChordFret(int n) {
        if (n < 0) {
            return "x";
        }
        if (n == 0) {
            return "o";
        }
        return Integer.toString(n);
    }

    private String toBase26(int n) {
        String string = new String();
        int n2 = n;
        while (n2 > 25) {
            string = (char)(n2 % 26 + 65) + string;
            n2 = n2 / 26 - 1;
        }
        return (char)(n2 + 65) + string;
    }

    private String trackID(int n, String string) {
        return "Track" + this.toBase26(n) + string;
    }

    public class TGVoiceJoiner {
        private TGFactory factory;
        private TGMeasure measure;

        public TGVoiceJoiner(TGFactory tGFactory, TGMeasure tGMeasure) {
            this.factory = tGFactory;
            this.measure = tGMeasure.clone(tGFactory, tGMeasure.getHeader());
            this.measure.setTrack(tGMeasure.getTrack());
        }

        public TGMeasure process() {
            this.orderBeats();
            this.joinBeats();
            return this.measure;
        }

        public void joinBeats() {
            TGBeat tGBeat = null;
            boolean bl = true;
            long l = this.measure.getStart();
            long l2 = l + this.measure.getLength();
            for (int i = 0; i < this.measure.countBeats(); ++i) {
                TGVoice tGVoice;
                TGBeat tGBeat2 = this.measure.getBeat(i);
                TGVoice tGVoice2 = tGBeat2.getVoice(0);
                for (int j = 1; j < tGBeat2.countVoices(); ++j) {
                    TGVoice tGVoice3 = tGBeat2.getVoice(j);
                    if (tGVoice3.isEmpty()) continue;
                    for (int k = 0; k < tGVoice3.countNotes(); ++k) {
                        TGNote tGNote = tGVoice3.getNote(k);
                        tGVoice2.addNote(tGNote);
                    }
                }
                if (tGVoice2.isEmpty()) {
                    this.measure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                long l3 = tGBeat2.getStart();
                if (tGBeat != null) {
                    long l4 = tGBeat.getStart();
                    tGVoice = null;
                    for (int j = 0; j < tGBeat.countVoices(); ++j) {
                        long l5;
                        TGVoice tGVoice4 = tGBeat.getVoice(j);
                        if (tGVoice4.isEmpty() || l4 + (l5 = tGVoice4.getDuration().getTime()) > l3 || tGVoice != null && l5 <= tGVoice.getTime()) continue;
                        tGVoice = tGVoice4.getDuration();
                    }
                    if (tGVoice != null) {
                        tGVoice.copy(tGBeat.getVoice(0).getDuration());
                    } else {
                        if (tGVoice2.isRestVoice()) {
                            this.measure.removeBeat(tGBeat2);
                            bl = false;
                            break;
                        }
                        TGDuration tGDuration = TGDuration.fromTime((TGFactory)this.factory, (long)(l3 - l4));
                        tGDuration.copy(tGBeat.getVoice(0).getDuration());
                    }
                }
                TGDuration tGDuration = null;
                for (int j = 0; j < tGBeat2.countVoices(); ++j) {
                    long l6;
                    tGVoice = tGBeat2.getVoice(j);
                    if (tGVoice.isEmpty() || l3 + (l6 = tGVoice.getDuration().getTime()) > l2 || tGDuration != null && l6 <= tGDuration.getTime()) continue;
                    tGDuration = tGVoice.getDuration();
                }
                if (tGDuration == null) {
                    if (tGVoice2.isRestVoice()) {
                        this.measure.removeBeat(tGBeat2);
                        bl = false;
                        break;
                    }
                    TGDuration tGDuration2 = TGDuration.fromTime((TGFactory)this.factory, (long)(l2 - l3));
                    tGDuration2.copy(tGVoice2.getDuration());
                }
                tGBeat = tGBeat2;
            }
            if (!bl) {
                this.joinBeats();
            }
        }

        public void orderBeats() {
            for (int i = 0; i < this.measure.countBeats(); ++i) {
                TGBeat tGBeat = null;
                for (int j = i; j < this.measure.countBeats(); ++j) {
                    TGBeat tGBeat2 = this.measure.getBeat(j);
                    if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
                    tGBeat = tGBeat2;
                }
                this.measure.moveBeat(i, tGBeat);
            }
        }
    }

    protected class LilypondTempData {
        private int repeatCount;
        private int repeatAlternativeNumber;
        private boolean repeatOpen;
        private boolean repeatAlternativeOpen;
        private boolean tupletOpen;
        private List skippedLyricBeats = new ArrayList();

        protected LilypondTempData() {
            this.reset();
        }

        public void reset() {
            this.repeatCount = 0;
            this.repeatOpen = false;
            this.tupletOpen = false;
            this.skippedLyricBeats.clear();
        }

        public int getRepeatCount() {
            return this.repeatCount;
        }

        public void setRepeatCount(int n) {
            this.repeatCount = n;
        }

        public boolean isRepeatOpen() {
            return this.repeatOpen;
        }

        public void setRepeatOpen(boolean bl) {
            this.repeatOpen = bl;
        }

        public int getRepeatAlternativeNumber() {
            return this.repeatAlternativeNumber;
        }

        public void setRepeatAlternativeNumber(int n) {
            this.repeatAlternativeNumber = n;
        }

        public boolean isRepeatAlternativeOpen() {
            return this.repeatAlternativeOpen;
        }

        public void setRepeatAlternativeOpen(boolean bl) {
            this.repeatAlternativeOpen = bl;
        }

        public boolean isTupletOpen() {
            return this.tupletOpen;
        }

        public void setTupletOpen(boolean bl) {
            this.tupletOpen = bl;
        }

        public void addSkippedLyricBeat(String string) {
            this.skippedLyricBeats.add(string);
        }

        public List getSkippedLyricBeats() {
            return this.skippedLyricBeats;
        }
    }
}

