/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import java.io.OutputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGSongExporter;
import org.herac.tuxguitar.io.lilypond.LilypondOutputStream;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;
import org.herac.tuxguitar.io.lilypond.LilypondSettingsDialog;
import org.herac.tuxguitar.song.models.TGSong;

public class LilypondSongExporter
implements TGSongExporter {
    private LilypondSettings settings;

    public String getExportName() {
        return "Lilypond";
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Lilypond", "*.ly");
    }

    public boolean configure(boolean bl) {
        this.settings = bl ? LilypondSettings.getDefaults() : new LilypondSettingsDialog().open();
        return this.settings != null;
    }

    public void exportSong(OutputStream outputStream, TGSong tGSong) {
        if (this.settings != null) {
            new LilypondOutputStream(outputStream, this.settings).writeSong(tGSong);
        }
    }
}

