/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PixMap;
import org.eclipse.swt.internal.carbon.Rect;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    boolean disposed;
    boolean warnings;
    int colorspace;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    Point dpi;
    Callback drawPatternCallback;
    Callback axialShadingCallback;
    Callback releaseCallback;
    int drawPatternProc;
    int axialShadingProc;
    int releaseProc;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    int axialShadingProc(int n, int n2, int n3) {
        Object object = OS.JNIGetObject(n);
        if (object instanceof Pattern) {
            return ((Pattern)object).axialShadingProc(n, n2, n3);
        }
        return 0;
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    void createPatternCallbacks() {
        if (this.drawPatternCallback == null) {
            this.drawPatternCallback = new Callback(this, "drawPatternProc", 2);
            this.drawPatternProc = this.drawPatternCallback.getAddress();
            if (this.drawPatternProc == 0) {
                SWT.error(3);
            }
        }
        if (this.axialShadingCallback == null) {
            this.axialShadingCallback = new Callback(this, "axialShadingProc", 3);
            this.axialShadingProc = this.axialShadingCallback.getAddress();
            if (this.axialShadingProc == 0) {
                SWT.error(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == object) {
                    this.objects[n] = null;
                    this.errors[n] = null;
                    return;
                }
                ++n;
            }
        }
    }

    protected void destroy() {
    }

    int drawPatternProc(int n, int n2) {
        Object object = OS.JNIGetObject(n);
        if (object instanceof Pattern) {
            return ((Pattern)object).drawPatternProc(n, n2);
        }
        return 0;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int n = OS.GetMainDevice();
        int[] nArray = new int[1];
        OS.memmove(nArray, n, 4);
        GDevice gDevice = new GDevice();
        OS.memmove(gDevice, nArray[0], 62);
        return new Rectangle(gDevice.left, gDevice.top, gDevice.right - gDevice.left, gDevice.bottom - gDevice.top);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n = 0;
                int n2 = this.objects.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.objects[n3] != null) {
                        ++n;
                    }
                    ++n3;
                }
                n3 = 0;
                deviceData.objects = new Object[n];
                deviceData.errors = new Error[n];
                int n4 = 0;
                while (n4 < n2) {
                    if (this.objects[n4] != null) {
                        deviceData.objects[n3] = this.objects[n4];
                        deviceData.errors[n3] = this.errors[n4];
                        ++n3;
                    }
                    ++n4;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int n = OS.GetMainDevice();
        Rect rect = new Rect();
        OS.GetAvailableWindowPositioningBounds(n, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int getDepth() {
        this.checkDevice();
        int n = OS.GetMainDevice();
        int[] nArray = new int[1];
        OS.memmove(nArray, n, 4);
        GDevice gDevice = new GDevice();
        OS.memmove(gDevice, nArray[0], 62);
        return OS.GetPixDepth(gDevice.gdPMap);
    }

    public Point getDPI() {
        this.checkDevice();
        int n = OS.GetMainDevice();
        int[] nArray = new int[1];
        OS.memmove(nArray, n, 4);
        GDevice gDevice = new GDevice();
        OS.memmove(gDevice, nArray[0], 62);
        OS.memmove(nArray, gDevice.gdPMap, 4);
        PixMap pixMap = new PixMap();
        OS.memmove(pixMap, nArray[0], 50);
        return new Point(OS.Fix2Long(pixMap.hRes), OS.Fix2Long(pixMap.vRes));
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        if (!bl) {
            return new FontData[0];
        }
        int n = 0;
        int[] nArray = new int[1];
        CFRange cFRange = new CFRange();
        OS.ATSUGetFontIDs(null, 0, nArray);
        FontData[] fontDataArray = new FontData[nArray[0]];
        int n2 = OS.ATSFontIteratorCreate(2, 0, 0, 0, nArray);
        int n3 = nArray[0];
        while (n2 == 0) {
            int n4;
            n2 = OS.ATSFontIteratorNext(n3, nArray);
            if (n2 != 0 || OS.ATSFontGetName(n4 = nArray[0], 0, nArray) != 0) continue;
            cFRange.length = OS.CFStringGetLength(nArray[0]);
            char[] cArray = new char[cFRange.length];
            OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
            OS.CFRelease(nArray[0]);
            String string2 = new String(cArray);
            int n5 = 0;
            int n6 = 256;
            if (OS.ATSUFindFontName(n4, 1, n5, -1, -1, 0, null, nArray, null) != 0) {
                n5 = -1;
                n6 = 0;
                if (OS.ATSUFindFontName(n4, 1, n5, -1, -1, 0, null, nArray, null) != 0) continue;
            }
            byte[] byArray = new byte[nArray[0]];
            OS.ATSUFindFontName(n4, 1, n5, -1, -1, byArray.length, byArray, nArray, null);
            int n7 = OS.CFStringCreateWithBytes(0, byArray, byArray.length, n6, false);
            if (n7 == 0) continue;
            cFRange.length = OS.CFStringGetLength(n7);
            if (cFRange.length != 0) {
                cArray = new char[cFRange.length];
                OS.CFStringGetCharacters(n7, cFRange, cArray);
                String string3 = new String(cArray);
                if (!string3.startsWith(".") && (string == null || Compatibility.equalsIgnoreCase(string, string3))) {
                    int n8 = 0;
                    if (string2.indexOf("Italic") != -1) {
                        n8 |= 2;
                    }
                    if (string2.indexOf("Bold") != -1) {
                        n8 |= 1;
                    }
                    FontData fontData = new FontData(string3, 0, n8);
                    fontData.atsName = string2;
                    if (n == fontDataArray.length) {
                        FontData[] fontDataArray2 = new FontData[n + 4];
                        System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n);
                        fontDataArray = fontDataArray2;
                    }
                    fontDataArray[n++] = fontData;
                }
            }
            OS.CFRelease(n7);
        }
        if (n3 != 0) {
            nArray[0] = n3;
            OS.ATSFontIteratorRelease(nArray);
        }
        if (n == fontDataArray.length) {
            return fontDataArray;
        }
        FontData[] fontDataArray3 = new FontData[n];
        System.arraycopy(fontDataArray, 0, fontDataArray3, 0, n);
        return fontDataArray3;
    }

    Point getScreenDPI() {
        int n = OS.GetMainDevice();
        int[] nArray = new int[1];
        OS.memmove(nArray, n, 4);
        GDevice gDevice = new GDevice();
        OS.memmove(gDevice, nArray[0], 62);
        OS.memmove(nArray, gDevice.gdPMap, 4);
        PixMap pixMap = new PixMap();
        OS.memmove(pixMap, nArray[0], 50);
        return new Point(OS.Fix2Long(pixMap.hRes), OS.Fix2Long(pixMap.vRes));
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        switch (n) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warnings;
    }

    protected void init() {
        this.colorspace = OS.CGColorSpaceCreateDeviceRGB();
        if (this.colorspace == 0) {
            SWT.error(2);
        }
        this.releaseCallback = new Callback(this, "releaseProc", 3);
        this.releaseProc = this.releaseCallback.getAddress();
        if (this.releaseProc == 0) {
            SWT.error(3);
        }
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        boolean bl = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        byte[] byArray = new byte[256];
        short[] sArray = new short[1];
        byte[] byArray2 = new byte[1];
        boolean bl2 = bl;
        OS.GetThemeFont((short)(bl2 ? 1 : 0), (short)-1, byArray, sArray, byArray2);
        short s = OS.FMGetFontFamilyFromName(byArray);
        int[] nArray = new int[1];
        OS.FMGetFontFromFontFamilyInstance(s, byArray2[0], nArray, null);
        Point point = this.dpi = this.getDPI();
        Point point2 = this.getScreenDPI();
        this.systemFont = Font.carbon_new(this, OS.FMGetATSFontRefFromFont(nArray[0]), byArray2[0], sArray[0] * point.y / point2.y);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        boolean bl = false;
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n != 0) {
            int n2 = OS.CFURLCreateWithFileSystemPath(0, n, 0, false);
            if (n2 != 0) {
                byte[] byArray;
                byte[] byArray2 = new byte[80];
                if (OS.CFURLGetFSRef(n2, byArray2) && OS.FSGetCatalogInfo(byArray2, 0, null, null, byArray = new byte[70], null) == 0) {
                    int[] nArray = new int[1];
                    bl = OS.ATSFontActivateFromFileSpecification(byArray, 2, 0, 0, 0, nArray) == 0;
                }
                OS.CFRelease(n2);
            }
            OS.CFRelease(n);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == null) {
                    this.objects[n] = object;
                    this.errors[n] = new Error();
                    return;
                }
                ++n;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    protected void release() {
        if (this.releaseCallback != null) {
            this.releaseCallback.dispose();
        }
        if (this.drawPatternCallback != null) {
            this.drawPatternCallback.dispose();
        }
        if (this.axialShadingCallback != null) {
            this.axialShadingCallback.dispose();
        }
        this.drawPatternCallback = null;
        this.axialShadingCallback = null;
        this.releaseCallback = null;
        this.drawPatternProc = 0;
        this.axialShadingProc = 0;
        this.releaseProc = 0;
        OS.CGColorSpaceRelease(this.colorspace);
        this.colorspace = 0;
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
    }

    int releaseProc(int n, int n2, int n3) {
        OS.DisposePtr(n2);
        return 0;
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
        this.warnings = bl;
    }
}

