/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeGroupBoxDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class GroupDrawData
extends DrawData {
    public int headerWidth;
    public int headerHeight;
    public Rectangle headerArea;

    public GroupDrawData() {
        this.state = new int[1];
    }

    HIThemeGroupBoxDrawInfo getInfo() {
        int n = this.state[0];
        HIThemeGroupBoxDrawInfo hIThemeGroupBoxDrawInfo = new HIThemeGroupBoxDrawInfo();
        hIThemeGroupBoxDrawInfo.version = 0;
        hIThemeGroupBoxDrawInfo.kind = 0;
        if ((this.style & 8) != 0) {
            hIThemeGroupBoxDrawInfo.kind = 5;
        }
        hIThemeGroupBoxDrawInfo.state = (n & 0x20) != 0 ? ((n & 0x10) != 0 ? 7 : 8) : ((n & 8) != 0 ? 2 : ((n & 0x10) != 0 ? 1 : 0));
        return hIThemeGroupBoxDrawInfo;
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n;
        HIThemeGroupBoxDrawInfo hIThemeGroupBoxDrawInfo = this.getInfo();
        int n2 = this.headerHeight + 1;
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y + n2;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height - n2;
        OS.HIThemeDrawGroupBox(cGRect, hIThemeGroupBoxDrawInfo, gC.handle, 0);
        int[] nArray = new int[1];
        if (this.headerArea != null) {
            OS.GetThemeMetric(11, nArray);
            n = nArray[0];
            this.headerArea.x = rectangle.x + n;
            this.headerArea.y = rectangle.y;
            this.headerArea.width = rectangle.width - n * 2;
            this.headerArea.height = this.headerHeight;
        }
        if (this.clientArea != null) {
            OS.GetThemeMetric(61, nArray);
            n = nArray[0];
            this.clientArea.x = rectangle.x + n;
            this.clientArea.y = rectangle.y + n + n2;
            this.clientArea.width = rectangle.width - 2 * n;
            this.clientArea.height = rectangle.height - 2 * n - n2;
        }
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

