/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PMRect;
import org.eclipse.swt.internal.carbon.PMResolution;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    int printSession;
    int printSettings;
    int pageFormat;
    boolean inPage;
    boolean isGCCreated;
    int context;
    int colorspace;
    static final String DRIVER = "Mac";
    static final String PRINTER_DRIVER = "Printer";
    static final String FILE_DRIVER = "File";
    static final String PREVIEW_DRIVER = "Preview";
    static final String FAX_DRIVER = "Fax";

    public static PrinterData[] getPrinterList() {
        PrinterData[] printerDataArray = null;
        int[] nArray = new int[1];
        OS.PMCreateSession(nArray);
        if (nArray[0] != 0) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            OS.PMSessionCreatePrinterList(nArray[0], nArray2, nArray3, nArray4);
            if (nArray2[0] != 0) {
                int n = OS.CFArrayGetCount(nArray2[0]);
                printerDataArray = new PrinterData[n];
                int n2 = 0;
                while (n2 < n) {
                    String string = Printer.getString(OS.CFArrayGetValueAtIndex(nArray2[0], n2));
                    printerDataArray[n2] = new PrinterData(DRIVER, string);
                    ++n2;
                }
                OS.CFRelease(nArray2[0]);
            }
            OS.PMRelease(nArray[0]);
        }
        return printerDataArray == null ? new PrinterData[]{} : printerDataArray;
    }

    public static PrinterData getDefaultPrinterData() {
        PrinterData printerData = null;
        int[] nArray = new int[1];
        OS.PMCreateSession(nArray);
        if (nArray[0] != 0) {
            String string = Printer.getCurrentPrinterName(nArray[0]);
            if (string != null) {
                printerData = new PrinterData(DRIVER, string);
            }
            OS.PMRelease(nArray[0]);
        }
        return printerData;
    }

    static String getCurrentPrinterName(int n) {
        String string = null;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.PMSessionCreatePrinterList(n, nArray, nArray2, nArray3);
        if (nArray[0] != 0) {
            int n2 = OS.CFArrayGetCount(nArray[0]);
            if (nArray2[0] >= 0 && nArray2[0] < n2) {
                string = Printer.getString(OS.CFArrayGetValueAtIndex(nArray[0], nArray2[0]));
            }
            OS.CFRelease(nArray[0]);
        }
        return string;
    }

    Point getIndependentDPI() {
        return super.getDPI();
    }

    static String getString(int n) {
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        return new String(cArray);
    }

    static int packData(int n, byte[] byArray, int n2) {
        int n3 = OS.GetHandleSize(n);
        byArray[n2++] = (byte)((n3 & 0xFF) >> 0);
        byArray[n2++] = (byte)((n3 & 0xFF00) >> 8);
        byArray[n2++] = (byte)((n3 & 0xFF0000) >> 16);
        byArray[n2++] = (byte)((n3 & 0xFF000000) >> 24);
        int[] nArray = new int[1];
        OS.HLock(n);
        OS.memmove(nArray, n, 4);
        byte[] byArray2 = new byte[n3];
        OS.memmove(byArray2, nArray[0], n3);
        OS.HUnlock(n);
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        return n2 + n3;
    }

    static int unpackData(int[] nArray, byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 0 | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        nArray[0] = OS.NewHandle(n2);
        if (nArray[0] == 0) {
            SWT.error(2);
        }
        int[] nArray2 = new int[1];
        OS.HLock(nArray[0]);
        OS.memmove(nArray2, nArray[0], 4);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        OS.memmove(nArray2[0], byArray2, n2);
        OS.HUnlock(nArray[0]);
        return n + n2;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkDevice();
        PMRect pMRect = new PMRect();
        PMRect pMRect2 = new PMRect();
        OS.PMGetAdjustedPageRect(this.pageFormat, pMRect);
        OS.PMGetAdjustedPaperRect(this.pageFormat, pMRect2);
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        n = (int)((double)n + pMRect2.left * (double)point.x / (double)point2.x);
        n2 = (int)((double)n2 + pMRect2.top * (double)point.y / (double)point2.y);
        n3 = (int)((double)n3 + (pMRect2.right - pMRect2.left - (pMRect.right - pMRect.left)) * (double)point.x / (double)point2.x);
        n4 = (int)((double)n4 + (pMRect2.bottom - pMRect2.top - (pMRect.bottom - pMRect.top)) * (double)point.y / (double)point2.y);
        return new Rectangle(n, n2, n3, n4);
    }

    protected void create(DeviceData deviceData) {
        int n;
        int n2;
        Object[] objectArray;
        this.data = (PrinterData)deviceData;
        int[] nArray = new int[1];
        if (OS.PMCreateSession(nArray) != 0) {
            SWT.error(2);
        }
        this.printSession = nArray[0];
        if (this.printSession == 0) {
            SWT.error(2);
        }
        if (this.data.otherData != null) {
            int n3 = 0;
            objectArray = this.data.otherData;
            n3 = Printer.unpackData(nArray, objectArray, n3);
            n2 = nArray[0];
            n3 = Printer.unpackData(nArray, objectArray, n3);
            n = nArray[0];
            if (OS.PMUnflattenPrintSettings(n2, nArray) != 0) {
                SWT.error(2);
            }
            this.printSettings = nArray[0];
            if (this.printSettings == 0) {
                SWT.error(2);
            }
            if (OS.PMUnflattenPageFormat(n, nArray) != 0) {
                SWT.error(2);
            }
            this.pageFormat = nArray[0];
            if (this.pageFormat == 0) {
                SWT.error(2);
            }
            OS.DisposeHandle(n2);
            OS.DisposeHandle(n);
        } else {
            if (OS.PMCreatePrintSettings(nArray) != 0) {
                SWT.error(2);
            }
            this.printSettings = nArray[0];
            if (this.printSettings == 0) {
                SWT.error(2);
            }
            OS.PMSessionDefaultPrintSettings(this.printSession, this.printSettings);
            if (OS.PMCreatePageFormat(nArray) != 0) {
                SWT.error(2);
            }
            this.pageFormat = nArray[0];
            if (this.pageFormat == 0) {
                SWT.error(2);
            }
            OS.PMSessionDefaultPageFormat(this.printSession, this.pageFormat);
        }
        if (PREVIEW_DRIVER.equals(this.data.driver)) {
            OS.PMSessionSetDestination(this.printSession, this.printSettings, (short)4, 0, 0);
        }
        String string = this.data.name;
        objectArray = new char[string.length()];
        string.getChars(0, objectArray.length, (char[])objectArray, 0);
        n2 = OS.CFStringCreateWithCharacters(0, (char[])objectArray, objectArray.length);
        if (n2 != 0) {
            OS.PMSessionSetCurrentPrinter(this.printSession, n2);
            OS.CFRelease(n2);
        }
        OS.PMSessionValidatePrintSettings(this.printSession, this.printSettings, null);
        OS.PMSessionValidatePageFormat(this.printSession, this.pageFormat, null);
        n = OS.CFArrayCreateMutable(0, 1, 0);
        if (n != 0) {
            OS.CFArrayAppendValue(n, OS.kPMGraphicsContextCoreGraphics());
            OS.PMSessionSetDocumentFormatGeneration(this.printSession, OS.kPMDocumentFormatPDF(), n, 0);
            OS.CFRelease(n);
        }
    }

    protected void destroy() {
        if (this.pageFormat != 0) {
            OS.PMRelease(this.pageFormat);
        }
        this.pageFormat = 0;
        if (this.printSettings != 0) {
            OS.PMRelease(this.printSettings);
        }
        this.printSettings = 0;
        if (this.printSession != 0) {
            OS.PMRelease(this.printSession);
        }
        this.printSession = 0;
    }

    public int internal_new_GC(GCData gCData) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.setupNewPage();
        if (gCData != null) {
            if (this.isGCCreated) {
                SWT.error(5);
            }
            gCData.device = this;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
            PMRect pMRect = new PMRect();
            OS.PMGetAdjustedPaperRect(this.pageFormat, pMRect);
            Point point = this.getDPI();
            Point point2 = this.getIndependentDPI();
            Rect rect = new Rect();
            rect.left = (short)(pMRect.left * (double)point.x / (double)point2.x);
            rect.right = (short)(pMRect.right * (double)point.x / (double)point2.x);
            rect.top = (short)(pMRect.top * (double)point.y / (double)point2.y);
            rect.bottom = (short)(pMRect.bottom * (double)point.y / (double)point2.y);
            gCData.portRect = rect;
            this.isGCCreated = true;
        }
        return this.context;
    }

    protected void init() {
        super.init();
        this.colorspace = OS.CGColorSpaceCreateDeviceRGB();
        if (this.colorspace == 0) {
            SWT.error(2);
        }
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        if (gCData != null) {
            this.isGCCreated = false;
        }
    }

    protected void release() {
        if (this.colorspace != 0) {
            OS.CGColorSpaceRelease(this.colorspace);
        }
        this.colorspace = 0;
        super.release();
    }

    public boolean startJob(String string) {
        this.checkDevice();
        if (string != null && string.length() != 0) {
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            if (n != 0) {
                OS.PMSetJobNameCFString(this.printSettings, n);
                OS.CFRelease(n);
            }
        }
        return OS.PMSessionBeginDocumentNoDialog(this.printSession, this.printSettings, this.pageFormat) == 0;
    }

    public void endJob() {
        this.checkDevice();
        if (this.inPage) {
            OS.PMSessionEndPageNoDialog(this.printSession);
            this.inPage = false;
        }
        OS.PMSessionEndDocumentNoDialog(this.printSession);
        this.context = 0;
    }

    public void cancelJob() {
        this.checkDevice();
        OS.PMSessionSetError(this.printSession, 128);
        if (this.inPage) {
            OS.PMSessionEndPageNoDialog(this.printSession);
            this.inPage = false;
        }
        OS.PMSessionEndDocumentNoDialog(this.printSession);
        this.context = 0;
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            PrinterData printerData2 = Printer.getDefaultPrinterData();
            if (printerData2 == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    public boolean startPage() {
        this.checkDevice();
        if (OS.PMSessionError(this.printSession) != 0) {
            return false;
        }
        this.setupNewPage();
        return this.context != 0;
    }

    public void endPage() {
        this.checkDevice();
        if (this.inPage) {
            OS.PMSessionEndPageNoDialog(this.printSession);
            this.inPage = false;
        }
    }

    public Point getDPI() {
        this.checkDevice();
        PMResolution pMResolution = new PMResolution();
        if (OS.VERSION >= 4176) {
            int[] nArray = new int[1];
            OS.PMSessionGetCurrentPrinter(this.printSession, nArray);
            OS.PMPrinterGetOutputResolution(nArray[0], this.printSettings, pMResolution);
        }
        if (pMResolution.hRes == 0.0 || pMResolution.vRes == 0.0) {
            OS.PMGetResolution(this.pageFormat, pMResolution);
        }
        return new Point((int)pMResolution.hRes, (int)pMResolution.vRes);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        PMRect pMRect = new PMRect();
        OS.PMGetAdjustedPaperRect(this.pageFormat, pMRect);
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        return new Rectangle(0, 0, (int)((pMRect.right - pMRect.left) * (double)point.x / (double)point2.x), (int)((pMRect.bottom - pMRect.top) * (double)point.x / (double)point2.x));
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        PMRect pMRect = new PMRect();
        OS.PMGetAdjustedPageRect(this.pageFormat, pMRect);
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        return new Rectangle(0, 0, (int)((pMRect.right - pMRect.left) * (double)point.x / (double)point2.x), (int)((pMRect.bottom - pMRect.top) * (double)point.x / (double)point2.x));
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }

    void setupNewPage() {
        if (!this.inPage) {
            this.inPage = true;
            OS.PMSessionBeginPageNoDialog(this.printSession, this.pageFormat, null);
            int[] nArray = new int[1];
            OS.PMSessionGetGraphicsContext(this.printSession, 0, nArray);
            if (this.context == 0) {
                this.context = nArray[0];
            } else if (this.context != nArray[0]) {
                SWT.error(1);
            }
            PMRect pMRect = new PMRect();
            PMRect pMRect2 = new PMRect();
            OS.PMGetAdjustedPaperRect(this.pageFormat, pMRect);
            OS.PMGetAdjustedPageRect(this.pageFormat, pMRect2);
            OS.CGContextTranslateCTM(this.context, (float)(-pMRect.left), (float)(pMRect.bottom - pMRect.top) + (float)pMRect.top);
            OS.CGContextScaleCTM(this.context, 1.0f, -1.0f);
            Point point = this.getDPI();
            Point point2 = this.getIndependentDPI();
            OS.CGContextScaleCTM(this.context, (float)point2.x / (float)point.x, (float)point2.y / (float)point.y);
            OS.CGContextSetStrokeColorSpace(this.context, this.colorspace);
            OS.CGContextSetFillColorSpace(this.context, this.colorspace);
        }
    }
}

