/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int scrolledVisibleRgn;
    int siblingsVisibleRgn;
    int layoutCount;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite composite, int n) {
        super(composite, n);
    }

    Control[] _getChildren() {
        Control[] controlArray;
        short[] sArray = new short[1];
        OS.CountSubControls(this.handle, sArray);
        int n = sArray[0];
        Control[] controlArray2 = new Control[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = OS.HIViewGetFirstSubview(this.handle);
        while (n2 < n) {
            if (n4 != 0 && (controlArray = this.display.getWidget(n4)) != null && controlArray != this && controlArray instanceof Control) {
                controlArray2[n3++] = (Control)controlArray;
            }
            n4 = OS.HIViewGetNextView(n4);
            ++n2;
        }
        if (n3 == n) {
            return controlArray2;
        }
        controlArray = new Control[n3];
        System.arraycopy(controlArray2, 0, controlArray, 0, n3);
        return controlArray;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabList.length) {
            if (!this.tabList[n2].isDisposed()) {
                ++n;
            }
            ++n2;
        }
        if (n == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.tabList.length) {
            if (!this.tabList[n4].isDisposed()) {
                controlArray[n3++] = this.tabList[n4];
            }
            ++n4;
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    int callFocusEventHandler(int n, int n2) {
        if ((this.state & 2) != 0) {
            return 0;
        }
        return super.callFocusEventHandler(n, n2);
    }

    public void changed(Control[] controlArray) {
        Control control;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        int n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean bl = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl2 = bl = composite == this;
                if (bl) break;
                composite = composite.parent;
            }
            if (!bl) {
                this.error(32);
            }
            ++n;
        }
        n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout == null || !composite.layout.flushCache(control)) {
                    composite.state |= 0x2000;
                }
                control = composite;
                composite = control.parent;
            }
            ++n;
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point;
        this.checkWidget();
        if (this.layout != null) {
            if (n == -1 || n2 == -1) {
                point = this.layout.computeSize(this, n, n2, bl |= (this.state & 0x2000) != 0);
                this.state &= 0xFFFFDFFF;
            } else {
                point = new Point(n, n2);
            }
        } else {
            point = this.minimumSize(n, n2, bl);
        }
        if (point.x == 0) {
            point.x = 64;
        }
        if (point.y == 0) {
            point.y = 64;
        }
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] controlArray = super.computeTabList();
        if (controlArray.length == 0) {
            return controlArray;
        }
        Control[] controlArray2 = this.tabList != null ? this._getTabList() : this._getChildren();
        int n = 0;
        while (n < controlArray2.length) {
            Control control = controlArray2[n];
            Control[] controlArray3 = control.computeTabList();
            if (controlArray3.length != 0) {
                Control[] controlArray4 = new Control[controlArray.length + controlArray3.length];
                System.arraycopy(controlArray, 0, controlArray4, 0, controlArray.length);
                System.arraycopy(controlArray3, 0, controlArray4, controlArray.length, controlArray3.length);
                controlArray = controlArray4;
            }
            ++n;
        }
        return controlArray;
    }

    void createHandle() {
        boolean bl;
        this.state |= 0x22;
        boolean bl2 = bl = (this.style & 0x300) != 0;
        if (!bl) {
            this.state |= 0x800;
        }
        if (bl || (this.style & 0x800) != 0) {
            this.createScrolledHandle(this.parent.handle);
        } else {
            this.createHandle(this.parent.handle);
        }
    }

    void createHandle(int n) {
        int n2 = 6;
        int[] nArray = new int[1];
        int n3 = OS.GetControlOwner(n);
        OS.CreateUserPaneControl(n3, null, n2, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
        OS.HIObjectSetAccessibilityIgnored(this.handle, true);
    }

    void createScrolledHandle(int n) {
        int n2 = 2;
        int[] nArray = new int[1];
        int n3 = OS.GetControlOwner(n);
        OS.CreateUserPaneControl(n3, null, n2, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.scrolledHandle = nArray[0];
        nArray[0] = 0;
        OS.CreateUserPaneControl(n3, null, n2 |= 4, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
        OS.HIObjectSetAccessibilityIgnored(this.scrolledHandle, true);
        OS.HIObjectSetAccessibilityIgnored(this.handle, true);
    }

    void drawBackground(int n, int n2) {
        if (n == this.scrolledHandle) {
            boolean bl;
            Composite composite = this;
            Shell shell = this.getShell();
            if (shell != this) {
                composite = this.parent;
            }
            boolean bl2 = bl = (this.style & 0x40000000) == 0;
            if ((this.style & 0x80000) == 0 && this.hooksKeys()) {
                composite.drawFocus(n, n2, this.hasFocus() && this.drawFocusRing(), this.hasBorder(), bl, this.inset());
            } else if (this.hasBorder()) {
                composite.drawFocus(n, n2, false, this.hasBorder(), bl, this.inset());
            } else {
                composite.fillBackground(n, n2, null);
            }
        } else if ((this.state & 2) != 0 && (this.style & 0x40040000) == 0) {
            this.fillBackground(n, n2, null);
        }
    }

    void enableWidget(boolean bl) {
        if ((this.state & 2) != 0) {
            if (this.horizontalBar != null) {
                this.horizontalBar.enableWidget(bl);
            }
            if (this.verticalBar != null) {
                this.verticalBar.enableWidget(bl);
            }
            return;
        }
        super.enableWidget(bl);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] menuArray = super.findMenus(control);
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control2 = controlArray[n];
            Menu[] menuArray2 = control2.findMenus(control);
            if (menuArray2.length != 0) {
                Menu[] menuArray3 = new Menu[menuArray.length + menuArray2.length];
                System.arraycopy(menuArray, 0, menuArray3, 0, menuArray.length);
                System.arraycopy(menuArray2, 0, menuArray3, menuArray.length, menuArray2.length);
                menuArray = menuArray3;
            }
            ++n;
        }
        return menuArray;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].fixChildren(shell, shell2, decorations, decorations2, menuArray);
            ++n;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabList.length) {
            if (this.tabList[n2] == control) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        Control[] controlArray = null;
        int n3 = this.tabList.length - n;
        if (n3 != 0) {
            controlArray = new Control[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.tabList.length) {
                if (this.tabList[n5] != control) {
                    controlArray[n4++] = this.tabList[n5];
                }
                ++n5;
            }
        }
        this.tabList = controlArray;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        short[] sArray = new short[1];
        OS.CountSubControls(this.handle, sArray);
        return sArray[0];
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n = 0;
            Control[] controlArray2 = this._getChildren();
            int n2 = 0;
            while (n2 < controlArray2.length) {
                if (controlArray2[n2].isTabGroup()) {
                    ++n;
                }
                ++n2;
            }
            controlArray = new Control[n];
            n2 = 0;
            int n3 = 0;
            while (n3 < controlArray2.length) {
                if (controlArray2[n3].isTabGroup()) {
                    controlArray[n2++] = controlArray2[n3];
                }
                ++n3;
            }
        }
        return controlArray;
    }

    int getVisibleRegion(int n, boolean bl) {
        if (!bl && n == this.handle) {
            if (this.siblingsVisibleRgn == 0) {
                this.siblingsVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(n, this.siblingsVisibleRgn, bl);
            }
            int n2 = OS.NewRgn();
            OS.CopyRgn(this.siblingsVisibleRgn, n2);
            return n2;
        }
        if (n == this.scrolledHandle) {
            if (!bl) {
                return super.getVisibleRegion(n, bl);
            }
            if (this.scrolledVisibleRgn == 0) {
                this.scrolledVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(n, this.scrolledVisibleRgn, bl);
            }
            int n3 = OS.NewRgn();
            OS.CopyRgn(this.scrolledVisibleRgn, n3);
            return n3;
        }
        return super.getVisibleRegion(n, bl);
    }

    int kEventControlClick(int n, int n2, int n3) {
        int n4 = super.kEventControlClick(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if ((this.state & 2) != 0) {
            if (!this.isEnabled()) {
                return n4;
            }
            if ((this.style & 0x80000) == 0 && this.hooksKeys()) {
                int[] nArray = new int[1];
                int n5 = OS.GetControlOwner(this.handle);
                OS.GetKeyboardFocus(n5, nArray);
                if (this.handle != nArray[0]) {
                    short[] sArray = new short[1];
                    OS.CountSubControls(this.handle, sArray);
                    if (sArray[0] == 0 && OS.SetKeyboardFocus(n5, this.handle, (short)this.focusPart()) == 0) {
                        return 0;
                    }
                }
            }
        }
        return n4;
    }

    int kEventControlGetFocusPart(int n, int n2, int n3) {
        if ((this.state & 2) != 0) {
            return 0;
        }
        return super.kEventControlGetFocusPart(n, n2, n3);
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        int n4 = super.kEventControlSetFocusPart(n, n2, n3);
        if (n4 == 0 && (this.state & 2) != 0 && this.scrolledHandle != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            short[] sArray = new short[1];
            OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
            this.redrawWidget(this.scrolledHandle, false);
        }
        return n4;
    }

    int kEventMouseDown(int n, int n2, int n3) {
        int n4 = super.kEventMouseDown(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if ((this.state & 2) != 0 && (this.style & 0x80000) != 0) {
            Shell shell = this.getShell();
            int n5 = 540672;
            if ((shell.style & n5) == n5) {
                return 0;
            }
        }
        return n4;
    }

    int kEventRawKeyPressed(int n, int n2, int n3) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            return OS.SendEventToEventTarget(n2, OS.GetApplicationEventTarget());
        }
        if ((this.state & 2) != 0) {
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1801678692, 1835100014, null, nArray.length * 4, null, nArray);
            if (nArray[0] == 49) {
                int[] nArray2 = new int[1];
                OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray2);
                if (nArray2[0] == 256 && !this.sendKeyEvent(1, n2)) {
                    return 0;
                }
            }
        }
        return -9874;
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int n4 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if ((this.state & 2) != 0) {
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
            int[] nArray2 = new int[1];
            OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
            switch (nArray2[0]) {
                case 36: 
                case 76: {
                    return 0;
                }
            }
        }
        return n4;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    void invalidateChildrenVisibleRegion(int n) {
        Control[] controlArray = this._getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            Control control = controlArray[n2];
            control.resetVisibleRegion(n);
            control.invalidateChildrenVisibleRegion(n);
            ++n2;
        }
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl, false);
    }

    public void layout(boolean bl, boolean bl2) {
        this.checkWidget();
        if (this.layout == null && !bl2) {
            return;
        }
        this.markLayout(bl, bl2);
        this.updateLayout(bl2);
    }

    public void layout(Control[] controlArray) {
        Control control;
        int n;
        Composite[] compositeArray;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        int n2 = 0;
        while (n2 < controlArray.length) {
            compositeArray = controlArray[n2];
            if (compositeArray == null) {
                this.error(5);
            }
            if (compositeArray.isDisposed()) {
                this.error(5);
            }
            n = 0;
            control = compositeArray.parent;
            while (control != null) {
                int n3 = n = control == this ? 1 : 0;
                if (n != 0) break;
                control = control.parent;
            }
            if (n == 0) {
                this.error(32);
            }
            ++n2;
        }
        n2 = 0;
        compositeArray = new Composite[16];
        n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout != null) {
                    composite.state |= 0x1000;
                    if (!composite.layout.flushCache(control)) {
                        composite.state |= 0x2000;
                    }
                }
                if (n2 == compositeArray.length) {
                    Composite[] compositeArray2 = new Composite[compositeArray.length + 16];
                    System.arraycopy(compositeArray, 0, compositeArray2, 0, compositeArray.length);
                    compositeArray = compositeArray2;
                }
                int n4 = n2++;
                Composite composite2 = composite;
                compositeArray[n4] = composite2;
                control = composite2;
                composite = control.parent;
            }
            ++n;
        }
        n = n2 - 1;
        while (n >= 0) {
            compositeArray[n].updateLayout(false);
            --n;
        }
    }

    void markLayout(boolean bl, boolean bl2) {
        if (this.layout != null) {
            this.state |= 0x1000;
            if (bl) {
                this.state |= 0x2000;
            }
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].markLayout(bl, bl2);
                ++n;
            }
        }
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            Rectangle rectangle = controlArray[n5].getBounds();
            n3 = Math.max(n3, rectangle.x + rectangle.width);
            n4 = Math.max(n4, rectangle.y + rectangle.height);
            ++n5;
        }
        return new Point(n3, n4);
    }

    void releaseChildren(boolean bl) {
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control != null && !control.isDisposed()) {
                control.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.scrolledVisibleRgn != 0) {
            OS.DisposeRgn(this.scrolledVisibleRgn);
        }
        if (this.siblingsVisibleRgn != 0) {
            OS.DisposeRgn(this.siblingsVisibleRgn);
        }
        this.scrolledVisibleRgn = 0;
        this.siblingsVisibleRgn = 0;
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void resetVisibleRegion(int n) {
        if (this.scrolledVisibleRgn != 0) {
            OS.DisposeRgn(this.scrolledVisibleRgn);
            this.scrolledVisibleRgn = 0;
        }
        if (this.siblingsVisibleRgn != 0) {
            OS.DisposeRgn(this.siblingsVisibleRgn);
            this.siblingsVisibleRgn = 0;
        }
        super.resetVisibleRegion(n);
    }

    public void setBackgroundMode(int n) {
        this.checkWidget();
        this.backgroundMode = n;
        Control[] controlArray = this._getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            controlArray[n2].updateBackgroundMode();
            ++n2;
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if (this.layout != null && (n5 & 0x80) != 0) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return n5;
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n].setFocus()) {
                return true;
            }
            ++n;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean bl) {
        if (!bl) {
            if (--this.layoutCount == 0 && ((this.state & 0x4000) != 0 || (this.state & 0x1000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        boolean bl2 = super.setScrollBarVisible(scrollBar, bl);
        if (bl2 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return bl2;
    }

    boolean setTabGroupFocus() {
        boolean bl;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl2 = bl = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl = this.hooksKeys();
        }
        if (bl && this.setTabItemFocus()) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.isTabItem() && control.setTabItemFocus()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                Control control = controlArray[n];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++n;
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    int traversalCode(int n, int n2) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(n, n2);
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].updateBackgroundMode();
            ++n;
        }
    }

    void updateLayout(boolean bl) {
        Composite composite = this.findDeferredControl();
        if (composite != null) {
            composite.state |= 0x4000;
            return;
        }
        if ((this.state & 0x1000) != 0) {
            boolean bl2 = (this.state & 0x2000) != 0;
            this.state &= 0xFFFFCFFF;
            this.layout.layout(this, bl2);
        }
        if (bl) {
            this.state &= 0xFFFFBFFF;
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].updateLayout(bl);
                ++n;
            }
        }
    }
}

