/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    Shell tip;
    int x;
    int y;
    boolean spikeAbove;
    boolean autohide;
    TextLayout layoutText;
    TextLayout layoutMessage;
    String text;
    String message;
    TrayItem item;
    Region region;
    Font boldFont;
    Runnable runnable;
    int helpString;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 10000;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.createWidget();
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] nArray;
        Object object;
        Display display = this.parent.getDisplay();
        int n = this.x;
        int n2 = this.y;
        if (n == -1 || n2 == -1) {
            object = this.item != null ? this.item.getLocation() : display.getCursorLocation();
            n = ((org.eclipse.swt.graphics.Point)object).x;
            n2 = ((org.eclipse.swt.graphics.Point)object).y;
        }
        object = this.parent.getMonitor();
        Rectangle rectangle = ((Monitor)object).getBounds();
        org.eclipse.swt.graphics.Point point = this.getSize(rectangle.width / 4);
        int n3 = point.x;
        int n4 = point.y;
        int n5 = (this.style & 0x1000) != 0 ? 20 : 0;
        int n6 = (this.style & 0x1000) != 0 ? 17 : 0;
        this.tip.setSize(n3, n4 + n5);
        boolean bl = this.spikeAbove = rectangle.height >= n2 + point.y + n5;
        if (rectangle.width >= n + point.x) {
            if (rectangle.height >= n2 + point.y + n5) {
                int[] nArray2 = new int[68];
                nArray2[1] = 5 + n5;
                nArray2[2] = 1;
                nArray2[3] = 5 + n5;
                nArray2[4] = 1;
                nArray2[5] = 3 + n5;
                nArray2[6] = 3;
                nArray2[7] = 1 + n5;
                nArray2[8] = 5;
                nArray2[9] = 1 + n5;
                nArray2[10] = 5;
                nArray2[11] = n5;
                nArray2[12] = 16;
                nArray2[13] = n5;
                nArray2[14] = 16;
                nArray2[16] = 35;
                nArray2[17] = n5;
                nArray2[18] = n3 - 5;
                nArray2[19] = n5;
                nArray2[20] = n3 - 5;
                nArray2[21] = 1 + n5;
                nArray2[22] = n3 - 3;
                nArray2[23] = 1 + n5;
                nArray2[24] = n3 - 1;
                nArray2[25] = 3 + n5;
                nArray2[26] = n3 - 1;
                nArray2[27] = 5 + n5;
                nArray2[28] = n3;
                nArray2[29] = 5 + n5;
                nArray2[30] = n3;
                nArray2[31] = n4 - 5 + n5;
                nArray2[32] = n3 - 1;
                nArray2[33] = n4 - 5 + n5;
                nArray2[34] = n3 - 1;
                nArray2[35] = n4 - 3 + n5;
                nArray2[36] = n3 - 2;
                nArray2[37] = n4 - 3 + n5;
                nArray2[38] = n3 - 2;
                nArray2[39] = n4 - 2 + n5;
                nArray2[40] = n3 - 3;
                nArray2[41] = n4 - 2 + n5;
                nArray2[42] = n3 - 3;
                nArray2[43] = n4 - 1 + n5;
                nArray2[44] = n3 - 5;
                nArray2[45] = n4 - 1 + n5;
                nArray2[46] = n3 - 5;
                nArray2[47] = n4 + n5;
                nArray2[48] = 5;
                nArray2[49] = n4 + n5;
                nArray2[50] = 5;
                nArray2[51] = n4 - 1 + n5;
                nArray2[52] = 3;
                nArray2[53] = n4 - 1 + n5;
                nArray2[54] = 3;
                nArray2[55] = n4 - 2 + n5;
                nArray2[56] = 2;
                nArray2[57] = n4 - 2 + n5;
                nArray2[58] = 2;
                nArray2[59] = n4 - 3 + n5;
                nArray2[60] = 1;
                nArray2[61] = n4 - 3 + n5;
                nArray2[62] = 1;
                nArray2[63] = n4 - 5 + n5;
                nArray2[65] = n4 - 5 + n5;
                nArray2[67] = 5 + n5;
                nArray = nArray2;
                this.tip.setLocation(Math.max(0, n - n6), n2);
            } else {
                int[] nArray3 = new int[68];
                nArray3[1] = 5;
                nArray3[2] = 1;
                nArray3[3] = 5;
                nArray3[4] = 1;
                nArray3[5] = 3;
                nArray3[6] = 3;
                nArray3[7] = 1;
                nArray3[8] = 5;
                nArray3[9] = 1;
                nArray3[10] = 5;
                nArray3[12] = n3 - 5;
                nArray3[14] = n3 - 5;
                nArray3[15] = 1;
                nArray3[16] = n3 - 3;
                nArray3[17] = 1;
                nArray3[18] = n3 - 1;
                nArray3[19] = 3;
                nArray3[20] = n3 - 1;
                nArray3[21] = 5;
                nArray3[22] = n3;
                nArray3[23] = 5;
                nArray3[24] = n3;
                nArray3[25] = n4 - 5;
                nArray3[26] = n3 - 1;
                nArray3[27] = n4 - 5;
                nArray3[28] = n3 - 1;
                nArray3[29] = n4 - 3;
                nArray3[30] = n3 - 2;
                nArray3[31] = n4 - 3;
                nArray3[32] = n3 - 2;
                nArray3[33] = n4 - 2;
                nArray3[34] = n3 - 3;
                nArray3[35] = n4 - 2;
                nArray3[36] = n3 - 3;
                nArray3[37] = n4 - 1;
                nArray3[38] = n3 - 5;
                nArray3[39] = n4 - 1;
                nArray3[40] = n3 - 5;
                nArray3[41] = n4;
                nArray3[42] = 35;
                nArray3[43] = n4;
                nArray3[44] = 16;
                nArray3[45] = n4 + n5;
                nArray3[46] = 16;
                nArray3[47] = n4;
                nArray3[48] = 5;
                nArray3[49] = n4;
                nArray3[50] = 5;
                nArray3[51] = n4 - 1;
                nArray3[52] = 3;
                nArray3[53] = n4 - 1;
                nArray3[54] = 3;
                nArray3[55] = n4 - 2;
                nArray3[56] = 2;
                nArray3[57] = n4 - 2;
                nArray3[58] = 2;
                nArray3[59] = n4 - 3;
                nArray3[60] = 1;
                nArray3[61] = n4 - 3;
                nArray3[62] = 1;
                nArray3[63] = n4 - 5;
                nArray3[65] = n4 - 5;
                nArray3[67] = 5;
                nArray = nArray3;
                this.tip.setLocation(Math.max(0, n - n6), n2 - point.y - n5);
            }
        } else if (rectangle.height >= n2 + point.y + n5) {
            int[] nArray4 = new int[68];
            nArray4[1] = 5 + n5;
            nArray4[2] = 1;
            nArray4[3] = 5 + n5;
            nArray4[4] = 1;
            nArray4[5] = 3 + n5;
            nArray4[6] = 3;
            nArray4[7] = 1 + n5;
            nArray4[8] = 5;
            nArray4[9] = 1 + n5;
            nArray4[10] = 5;
            nArray4[11] = n5;
            nArray4[12] = n3 - 35;
            nArray4[13] = n5;
            nArray4[14] = n3 - 16;
            nArray4[16] = n3 - 16;
            nArray4[17] = n5;
            nArray4[18] = n3 - 5;
            nArray4[19] = n5;
            nArray4[20] = n3 - 5;
            nArray4[21] = 1 + n5;
            nArray4[22] = n3 - 3;
            nArray4[23] = 1 + n5;
            nArray4[24] = n3 - 1;
            nArray4[25] = 3 + n5;
            nArray4[26] = n3 - 1;
            nArray4[27] = 5 + n5;
            nArray4[28] = n3;
            nArray4[29] = 5 + n5;
            nArray4[30] = n3;
            nArray4[31] = n4 - 5 + n5;
            nArray4[32] = n3 - 1;
            nArray4[33] = n4 - 5 + n5;
            nArray4[34] = n3 - 1;
            nArray4[35] = n4 - 3 + n5;
            nArray4[36] = n3 - 2;
            nArray4[37] = n4 - 3 + n5;
            nArray4[38] = n3 - 2;
            nArray4[39] = n4 - 2 + n5;
            nArray4[40] = n3 - 3;
            nArray4[41] = n4 - 2 + n5;
            nArray4[42] = n3 - 3;
            nArray4[43] = n4 - 1 + n5;
            nArray4[44] = n3 - 5;
            nArray4[45] = n4 - 1 + n5;
            nArray4[46] = n3 - 5;
            nArray4[47] = n4 + n5;
            nArray4[48] = 5;
            nArray4[49] = n4 + n5;
            nArray4[50] = 5;
            nArray4[51] = n4 - 1 + n5;
            nArray4[52] = 3;
            nArray4[53] = n4 - 1 + n5;
            nArray4[54] = 3;
            nArray4[55] = n4 - 2 + n5;
            nArray4[56] = 2;
            nArray4[57] = n4 - 2 + n5;
            nArray4[58] = 2;
            nArray4[59] = n4 - 3 + n5;
            nArray4[60] = 1;
            nArray4[61] = n4 - 3 + n5;
            nArray4[62] = 1;
            nArray4[63] = n4 - 5 + n5;
            nArray4[65] = n4 - 5 + n5;
            nArray4[67] = 5 + n5;
            nArray = nArray4;
            this.tip.setLocation(Math.min(rectangle.width - point.x, n - point.x + n6), n2);
        } else {
            int[] nArray5 = new int[68];
            nArray5[1] = 5;
            nArray5[2] = 1;
            nArray5[3] = 5;
            nArray5[4] = 1;
            nArray5[5] = 3;
            nArray5[6] = 3;
            nArray5[7] = 1;
            nArray5[8] = 5;
            nArray5[9] = 1;
            nArray5[10] = 5;
            nArray5[12] = n3 - 5;
            nArray5[14] = n3 - 5;
            nArray5[15] = 1;
            nArray5[16] = n3 - 3;
            nArray5[17] = 1;
            nArray5[18] = n3 - 1;
            nArray5[19] = 3;
            nArray5[20] = n3 - 1;
            nArray5[21] = 5;
            nArray5[22] = n3;
            nArray5[23] = 5;
            nArray5[24] = n3;
            nArray5[25] = n4 - 5;
            nArray5[26] = n3 - 1;
            nArray5[27] = n4 - 5;
            nArray5[28] = n3 - 1;
            nArray5[29] = n4 - 3;
            nArray5[30] = n3 - 2;
            nArray5[31] = n4 - 3;
            nArray5[32] = n3 - 2;
            nArray5[33] = n4 - 2;
            nArray5[34] = n3 - 3;
            nArray5[35] = n4 - 2;
            nArray5[36] = n3 - 3;
            nArray5[37] = n4 - 1;
            nArray5[38] = n3 - 5;
            nArray5[39] = n4 - 1;
            nArray5[40] = n3 - 5;
            nArray5[41] = n4;
            nArray5[42] = n3 - 16;
            nArray5[43] = n4;
            nArray5[44] = n3 - 16;
            nArray5[45] = n4 + n5;
            nArray5[46] = n3 - 35;
            nArray5[47] = n4;
            nArray5[48] = 5;
            nArray5[49] = n4;
            nArray5[50] = 5;
            nArray5[51] = n4 - 1;
            nArray5[52] = 3;
            nArray5[53] = n4 - 1;
            nArray5[54] = 3;
            nArray5[55] = n4 - 2;
            nArray5[56] = 2;
            nArray5[57] = n4 - 2;
            nArray5[58] = 2;
            nArray5[59] = n4 - 3;
            nArray5[60] = 1;
            nArray5[61] = n4 - 3;
            nArray5[62] = 1;
            nArray5[63] = n4 - 5;
            nArray5[65] = n4 - 5;
            nArray5[67] = 5;
            nArray = nArray5;
            this.tip.setLocation(Math.min(rectangle.width - point.x, n - point.x + n6), n2 - point.y - n5);
        }
        if ((this.style & 0x1000) != 0) {
            if (this.region != null) {
                this.region.dispose();
            }
            this.region = new Region(display);
            this.region.add(nArray);
            this.tip.setRegion(this.region);
        }
    }

    void createWidget() {
        super.createWidget();
        this.autohide = true;
        this.y = -1;
        this.x = -1;
        this.text = "";
        this.message = "";
    }

    void disposeTip() {
        if (this.tip != null) {
            this.tip.dispose();
        }
        this.tip = null;
        if (this.region != null) {
            this.region.dispose();
        }
        this.region = null;
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    org.eclipse.swt.graphics.Point getSize(int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(-1);
            n2 = this.layoutText.getBounds().width;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(-1);
            n3 = this.layoutMessage.getBounds().width;
        }
        int n4 = 28;
        boolean bl = this.layoutText != null && (this.style & 0x1000) != 0 && (this.style & 0xB) != 0;
        int n5 = n4 + (bl ? 16 : 0);
        int n6 = Math.min(n, Math.max(n2 + n5, n3 + n4));
        int n7 = 0;
        int n8 = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(n - n5);
            n7 = this.layoutText.getBounds().height;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(n - n4);
            n8 = this.layoutMessage.getBounds().height;
        }
        int n9 = 20 + n8;
        if (this.layoutText != null) {
            n9 += Math.max(16, n7) + 10;
        }
        return new org.eclipse.swt.graphics.Point(n6, n9);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (this.tip != null) {
            return this.tip.getVisible();
        }
        if (this.display.helpWidget == this) {
            int n = OS.FrontWindow();
            int[] nArray = new int[1];
            OS.GetWindowClass(n, nArray);
            return nArray[0] == 10;
        }
        return false;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void onMouseDown(Event event) {
        this.notifyListeners(13, new Event());
        this.setVisible(false);
    }

    void onPaint(Event event) {
        GC gC = event.gc;
        int n = 10;
        int n2 = 10;
        if ((this.style & 0x1000) != 0 && this.spikeAbove) {
            n2 += 20;
        }
        if (this.layoutText != null) {
            int n3 = this.style & 0xB;
            if ((this.style & 0x1000) != 0 && n3 != 0) {
                Display display = this.getDisplay();
                Image image = display.getSystemImage(n3);
                Rectangle rectangle = image.getBounds();
                gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, n, n2, 16, 16);
                n += 16;
            }
            this.layoutText.draw(gC, n += 4, n2);
            n2 += 10 + Math.max(16, this.layoutText.getBounds().height);
        }
        if (this.layoutMessage != null) {
            n = 14;
            this.layoutMessage.draw(gC, n, n2);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.runnable != null) {
            Display display = this.getDisplay();
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        this.disposeTip();
        if (this.helpString != 0) {
            OS.CFRelease(this.helpString);
        }
        this.helpString = 0;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autohide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        if (this.x == n && this.y == n2) {
            return;
        }
        this.x = n;
        this.y = n2;
        if (this.tip != null && this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setLocation(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if (this.tip != null) {
            this.layoutMessage.setText(string);
            if (this.tip.getVisible()) {
                this.configure();
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if (this.tip != null) {
            this.layoutText.setText(string);
            TextStyle textStyle = new TextStyle(this.boldFont, null, null);
            this.layoutText.setStyle(textStyle, 0, string.length());
            if (this.tip.getVisible()) {
                this.configure();
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.helpString != 0) {
            OS.CFRelease(this.helpString);
        }
        this.helpString = 0;
        if (this.runnable != null) {
            this.display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        if (bl) {
            OS.HMHideTag();
            this.display.helpWidget = this;
            if (!this.autohide || (this.style & 0x1000) != 0) {
                if (this.tip == null) {
                    this.tip = new Shell(this.parent, 16396);
                    Color color = this.display.getSystemColor(29);
                    this.tip.setBackground(color);
                    Listener listener = new Listener(){

                        public void handleEvent(Event event) {
                            switch (event.type) {
                                case 9: {
                                    ToolTip.this.onPaint(event);
                                    break;
                                }
                                case 3: {
                                    ToolTip.this.onMouseDown(event);
                                }
                            }
                        }
                    };
                    this.tip.addListener(9, listener);
                    this.tip.addListener(3, listener);
                    this.layoutText = new TextLayout(this.display);
                    this.layoutText.setText(this.text);
                    Font font = this.display.getSystemFont();
                    FontData fontData = font.getFontData()[0];
                    this.boldFont = new Font((Device)this.display, fontData.getName(), fontData.getHeight(), 1);
                    TextStyle textStyle = new TextStyle(this.boldFont, null, null);
                    this.layoutText.setStyle(textStyle, 0, this.text.length());
                    this.layoutMessage = new TextLayout(this.display);
                    this.layoutMessage.setText(this.message);
                }
                this.configure();
                this.tip.setVisible(true);
                if (this.autohide) {
                    this.runnable = new Runnable(){

                        public void run() {
                            if (!ToolTip.this.isDisposed()) {
                                ToolTip.this.setVisible(false);
                            }
                        }
                    };
                    this.display.timerExec(10000, this.runnable);
                }
            } else {
                Object object;
                Serializable serializable;
                if (this.tip != null) {
                    this.disposeTip();
                }
                if (this.x == -1 || this.y == -1) {
                    if (this.item != null) {
                        serializable = this.item.getLocation();
                        this.x = ((org.eclipse.swt.graphics.Point)serializable).x;
                        this.y = ((org.eclipse.swt.graphics.Point)serializable).y;
                    } else {
                        object = new Point();
                        OS.GetGlobalMouse((Point)object);
                        this.x = ((Point)object).h;
                        this.y = ((Point)object).v;
                    }
                }
                serializable = new StringBuffer(this.text);
                if (this.text.length() > 0) {
                    ((StringBuffer)serializable).append("\n\n");
                }
                ((StringBuffer)serializable).append(this.message);
                object = new char[((StringBuffer)serializable).length()];
                ((StringBuffer)serializable).getChars(0, ((Object)object).length, (char[])object, 0);
                this.helpString = OS.CFStringCreateWithCharacters(0, (char[])object, ((Object)object).length);
                HMHelpContentRec hMHelpContentRec = new HMHelpContentRec();
                hMHelpContentRec.tagSide = (short)23;
                hMHelpContentRec.absHotRect_left = (short)this.x;
                hMHelpContentRec.absHotRect_top = (short)this.y;
                hMHelpContentRec.absHotRect_right = (short)(this.x + 1);
                hMHelpContentRec.absHotRect_bottom = (short)(this.y + 1);
                hMHelpContentRec.content0_contentType = 1667658612;
                hMHelpContentRec.content0_tagCFString = this.helpString;
                hMHelpContentRec.content1_contentType = 1667658612;
                hMHelpContentRec.content1_tagCFString = this.helpString;
                OS.HMDisplayTag(hMHelpContentRec);
            }
        } else if (this.display.helpWidget == this) {
            this.display.helpWidget = null;
            OS.HMHideTag();
            if (this.tip != null) {
                this.tip.setVisible(false);
            }
        }
    }
}

