/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ptb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.ptb.base.PTBar;
import org.herac.tuxguitar.io.ptb.base.PTComponent;
import org.herac.tuxguitar.io.ptb.base.PTDirection;
import org.herac.tuxguitar.io.ptb.base.PTPosition;
import org.herac.tuxguitar.io.ptb.base.PTSection;
import org.herac.tuxguitar.io.ptb.base.PTSong;
import org.herac.tuxguitar.io.ptb.base.PTSymbol;
import org.herac.tuxguitar.io.ptb.base.PTTrack;
import org.herac.tuxguitar.io.ptb.base.PTTrackInfo;

public class PTSongSynchronizerUtil {
    public static void synchronizeTracks(PTSong pTSong, PTSong pTSong2) {
        PTSongSynchronizerUtil.synchronizeTrack(pTSong.getTrack1(), pTSong2.getTrack1());
        PTSongSynchronizerUtil.synchronizeTrack(pTSong.getTrack2(), pTSong2.getTrack2());
    }

    private static void synchronizeTrack(PTTrack pTTrack, PTTrack pTTrack2) {
        PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2);
        PTSongSynchronizerUtil.applyInfos(pTTrack, pTTrack2);
    }

    private static void applyInfos(PTTrack pTTrack, PTTrack pTTrack2) {
        Iterator iterator = pTTrack.getInfos().iterator();
        while (iterator.hasNext()) {
            PTTrackInfo pTTrackInfo = (PTTrackInfo)iterator.next();
            pTTrack2.getInfos().add(pTTrackInfo.getClone());
        }
    }

    private static void applyRepeats(PTTrack pTTrack, PTTrack pTTrack2) {
        PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, new PTIndex(0, 0, 0), new PTSongSynchronizerData(), new ArrayList());
    }

    private static void applyRepeats(PTTrack pTTrack, PTTrack pTTrack2, PTIndex pTIndex, PTSongSynchronizerData pTSongSynchronizerData, List list) {
        for (int i = pTIndex.s; i < pTTrack.getSections().size(); ++i) {
            int n;
            PTSection pTSection = (PTSection)pTTrack.getSections().get(i);
            pTSection.sort();
            PTSection pTSection2 = new PTSection(pTSection.getNumber());
            pTSection2.setStaffs(pTSection.getStaffs());
            pTTrack2.getSections().add(pTSection2);
            int n2 = n = i == pTIndex.s ? pTIndex.p : 0;
            while (n < pTSection.getPositions().size()) {
                int n3;
                PTPosition pTPosition = (PTPosition)pTSection.getPositions().get(n);
                pTPosition.sort();
                PTPosition pTPosition2 = new PTPosition(pTPosition.getPosition());
                pTSection2.getPositions().add(pTPosition2);
                int n4 = n3 = i == pTIndex.s && n == pTIndex.p ? pTIndex.c : 0;
                while (n3 < pTPosition.getComponents().size()) {
                    boolean bl;
                    PTComponent pTComponent;
                    PTComponent pTComponent2 = (PTComponent)pTPosition.getComponents().get(n3);
                    if (!pTSongSynchronizerData.skip) {
                        pTPosition2.addComponent(pTComponent2.getClone());
                    }
                    if (pTComponent2 instanceof PTBar) {
                        pTComponent = (PTBar)pTComponent2;
                        if (((PTBar)pTComponent).getRepeatClose() > 0 && pTSongSynchronizerData.repeatStart != null) {
                            ++pTSongSynchronizerData.repeatNumber;
                            pTSongSynchronizerData.repeatInProgress = true;
                            pTSongSynchronizerData.repeatAlternative = false;
                            pTSongSynchronizerData.skip = false;
                            if (pTSongSynchronizerData.repeatNumber < ((PTBar)pTComponent).getRepeatClose()) {
                                PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTSongSynchronizerData.repeatStart, pTSongSynchronizerData, list);
                                return;
                            }
                            pTSongSynchronizerData.repeatStart = null;
                            pTSongSynchronizerData.repeatNumber = 0;
                        }
                        if (((PTBar)pTComponent).isRepeatStart()) {
                            pTSongSynchronizerData.repeatStart = new PTIndex(i, n, n3);
                            if (!pTSongSynchronizerData.repeatInProgress) {
                                pTSongSynchronizerData.repeatNumber = 0;
                            }
                            pTSongSynchronizerData.repeatInProgress = false;
                        }
                    } else if (pTComponent2 instanceof PTSymbol) {
                        pTComponent = (PTSymbol)pTComponent2;
                        pTSongSynchronizerData.skip = false;
                        if (!pTSongSynchronizerData.repeatAlternative && (((PTSymbol)pTComponent).getEndNumber() & 1) != 0) {
                            boolean bl2 = bl = (((PTSymbol)pTComponent).getEndNumber() & 1 << pTSongSynchronizerData.repeatNumber) != 0;
                            if (pTSongSynchronizerData.repeatNumber > 0 && !bl) {
                                pTSongSynchronizerData.skip = true;
                            }
                            pTSongSynchronizerData.repeatAlternative = true;
                        }
                    } else if (pTComponent2 instanceof PTDirection) {
                        boolean bl3;
                        pTComponent = (PTDirection)pTComponent2;
                        bl = ((PTDirection)pTComponent).getRepeat() == 0 || pTSongSynchronizerData.repeatStart != null && pTSongSynchronizerData.repeatNumber + 1 == ((PTDirection)pTComponent).getRepeat();
                        boolean bl4 = bl3 = ((PTDirection)pTComponent).getActiveSymbol() == pTSongSynchronizerData.findActiveSymbol;
                        if (bl3 && bl) {
                            PTIndex pTIndex2;
                            pTSongSynchronizerData.findActiveSymbol = 0;
                            if (((PTDirection)pTComponent).getDirection() == 4) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list)) {
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 5) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list)) {
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, new PTIndex(0, 0, 0), pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 6) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list) && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 2, i, n)) != null) {
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 7) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list) && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 3, i, n)) != null) {
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 8) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list) && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 0, -1, -1)) != null) {
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 9) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list) && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 1, -1, -1)) != null) {
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 10) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list)) {
                                    pTSongSynchronizerData.findActiveSymbol = 1;
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, new PTIndex(0, 0, 0), pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 11) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list)) {
                                    pTSongSynchronizerData.findActiveSymbol = 1;
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, new PTIndex(0, 0, 0), pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 12) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list) && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 2, i, n)) != null) {
                                    pTSongSynchronizerData.findActiveSymbol = 2;
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 13) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list) && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 2, i, n)) != null) {
                                    pTSongSynchronizerData.findActiveSymbol = 2;
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 14) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list) && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 3, i, n)) != null) {
                                    pTSongSynchronizerData.findActiveSymbol = 3;
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 15) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list) && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 3, i, n)) != null) {
                                    pTSongSynchronizerData.findActiveSymbol = 3;
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 16) {
                                if (PTSongSynchronizerUtil.canUseDirection((PTDirection)pTComponent, list)) {
                                    pTSongSynchronizerData.findActiveSymbol = 1;
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, new PTIndex(0, 0, 0), pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 17) {
                                pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 2, i, n);
                                if (pTIndex2 != null) {
                                    pTSongSynchronizerData.findActiveSymbol = 2;
                                    PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                    return;
                                }
                            } else if (((PTDirection)pTComponent).getDirection() == 18 && (pTIndex2 = PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, 3, i, n)) != null) {
                                pTSongSynchronizerData.findActiveSymbol = 3;
                                PTSongSynchronizerUtil.applyRepeats(pTTrack, pTTrack2, pTIndex2, pTSongSynchronizerData, list);
                                return;
                            }
                        }
                    }
                    ++n3;
                }
                ++n;
            }
        }
    }

    private static boolean canUseDirection(PTDirection pTDirection, List list) {
        boolean bl = false;
        for (int i = 0; i < list.size() && !bl; ++i) {
            PTDirection pTDirection2 = (PTDirection)list.get(i);
            if (!pTDirection2.equals(pTDirection)) continue;
            return false;
        }
        list.add(pTDirection);
        return true;
    }

    private static PTIndex findUnusedDirection(PTTrack pTTrack, List list, int n, int n2, int n3) {
        return PTSongSynchronizerUtil.findUnusedDirection(pTTrack, list, n, n2, n3, 0);
    }

    private static PTIndex findUnusedDirection(PTTrack pTTrack, List list, int n, int n2, int n3, int n4) {
        for (int i = 0; i < (n2 >= 0 ? n2 + 1 : pTTrack.getSections().size()); ++i) {
            PTSection pTSection = (PTSection)pTTrack.getSections().get(i);
            for (int j = 0; j < (i == n2 ? n3 + 1 : pTSection.getPositions().size()); ++j) {
                PTPosition pTPosition = (PTPosition)pTSection.getPositions().get(j);
                for (int k = 0; k < pTPosition.getComponents().size(); ++k) {
                    PTDirection pTDirection;
                    PTComponent pTComponent = (PTComponent)pTPosition.getComponents().get(k);
                    if (!(pTComponent instanceof PTDirection) || (pTDirection = (PTDirection)pTComponent).getDirection() != n || n4 != 0 && pTDirection.getActiveSymbol() != n4 || !PTSongSynchronizerUtil.canUseDirection(pTDirection, list)) continue;
                    return new PTIndex(i, j, 0);
                }
            }
        }
        return null;
    }

    private static class PTSongSynchronizerData {
        protected PTIndex repeatStart = null;
        protected boolean repeatInProgress;
        protected int repeatNumber = 0;
        protected boolean repeatAlternative = false;
        protected boolean skip = false;
        protected int findActiveSymbol;

        protected PTSongSynchronizerData() {
        }
    }

    private static class PTIndex {
        protected int s;
        protected int p;
        protected int c;

        protected PTIndex(int n, int n2, int n3) {
            this.s = n;
            this.p = n2;
            this.c = n3;
        }
    }
}

