/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.tuner;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.editors.TGPainter;

public class TGTunerRoughWidget
extends Composite {
    private static final int MIN_HEIGHT = 25;
    protected Composite composite = null;
    protected float currentFrequency = 0.0f;
    private final int startA = 20;
    private final int endAb = 20;
    private final int boundaryHeight = 16;
    private final int markerHeight = 12;
    private final int markerWidth = 4;
    static String[] TONESSTRING = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};

    public TGTunerRoughWidget(Composite composite) {
        super(composite, 0);
        this.init();
    }

    public void init() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        ((GridData)this.getLayoutData()).widthHint = 600;
        this.composite = new Composite((Composite)this, 0x20000800);
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                TGTunerRoughWidget.this.paintWidget(tGPainter);
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 25;
        gridData.grabExcessHorizontalSpace = true;
        this.composite.setLayoutData((Object)gridData);
    }

    private void paintWidget(TGPainter tGPainter) {
        Point point = this.composite.getSize();
        tGPainter.setForeground(this.getDisplay().getSystemColor(2));
        tGPainter.initPath();
        ((Object)((Object)this)).getClass();
        tGPainter.moveTo(20.0f, (float)(point.y / 2));
        int n = point.x;
        ((Object)((Object)this)).getClass();
        tGPainter.lineTo((float)(n - 20), (float)(point.y / 2));
        tGPainter.closePath();
        int n2 = point.x;
        ((Object)((Object)this)).getClass();
        int n3 = n2 - 20;
        ((Object)((Object)this)).getClass();
        int n4 = (int)Math.round((double)(n3 - 20) / 12.0);
        int n5 = 0;
        ((Object)((Object)this)).getClass();
        int n6 = 20;
        while (true) {
            int n7 = point.x + 1;
            ((Object)((Object)this)).getClass();
            if (n6 >= n7 - 20) break;
            tGPainter.initPath();
            tGPainter.moveTo((float)n6, (float)(point.y / 2 - this.boundaryHeight / 2));
            tGPainter.lineTo((float)n6, (float)(point.y / 2 + this.boundaryHeight / 2));
            tGPainter.closePath();
            tGPainter.drawString(TONESSTRING[n5 % 12], n6, point.y / 2 - this.boundaryHeight / 2 - 20);
            ++n5;
            n6 += n4;
        }
        if (this.currentFrequency > 0.0f) {
            tGPainter.setForeground(this.getDisplay().getSystemColor(9));
            tGPainter.initPath();
            int n8 = this.markerWidth / 2;
            ((Object)((Object)this)).getClass();
            int n9 = n8 + 20;
            int n10 = point.x;
            ((Object)((Object)this)).getClass();
            int n11 = n10 - 20;
            ((Object)((Object)this)).getClass();
            n6 = n9 + (int)Math.round((double)(n11 - 20) / 240.0 * (double)this.getTone(this.currentFrequency));
            tGPainter.moveTo((float)n6, (float)(point.y / 2 - this.markerHeight / 2));
            tGPainter.setLineWidth(this.markerWidth);
            tGPainter.lineTo((float)n6, (float)(point.y / 2 + this.markerHeight / 2));
            tGPainter.closePath();
        }
    }

    public void setCurrentFrequency(double d) {
        this.currentFrequency = (float)d;
        this.redraw();
    }

    public void redraw() {
        super.redraw();
        this.composite.redraw();
    }

    protected int getTone(float f) {
        float f2 = (float)(45.0 + 12.0 * (Math.log(f / 110.0f) / Math.log(2.0)));
        return Math.round(20.0f * (f2 % 12.0f));
    }
}

