// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Common.Configuration.BLogic
{
    /// <summary>
    /// rWlXWbNݒt@C blogic vf\܂B
    /// </summary>
    /// <remarks>
    /// BLogicElement ́ArWlXWbNݒt@C blogic vf\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElement"/> QƂĂB
    /// </remarks>
    public sealed class BLogicElement : ConfigurationElement
    {
        /// <summary>
        /// name ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "name" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_NAME = "name";

        /// <summary>
        /// type ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "type" łB
        /// </remarks>
        private const string TYPE_ATTRIBUTE_NAME = "type";

        /// <summary>
        /// dbInfo ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "dbInfos" łB
        /// </remarks>
        private const string DBINFOS_ATTRIBUTE_NAME = "dbInfos";

        /// <summary>
        /// <see cref="BLogicElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>ftHgRXgN^łB</remarks>
        public BLogicElement()
        {
        }

        /// <summary>
        /// <see cref="BLogicElement"/> NX̐VCX^X쐬܂B
        /// </summary>
        /// <param name="name">name ̒lB</param>
        /// <param name="type">type ̒lB</param>
        /// <param name="dbinfos">dbinfos ̒lB</param>
        public BLogicElement(string name, string type, BLogicDbInfoCollection dbinfos)
        {
            this[NAME_ATTRIBUTE_NAME] = name;
            this[TYPE_ATTRIBUTE_NAME] = type;
            this[DBINFOS_ATTRIBUTE_NAME] = dbinfos;
        }

        /// <summary>
        /// name ̒l擾܂B
        /// </summary>
        /// <value>
        /// name ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Name
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// type ̒l擾܂B
        /// </summary>
        /// <value>
        /// type ̒lB
        /// </value>
        [ConfigurationProperty(TYPE_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Type
        {
            get
            {
                return (string)this[TYPE_ATTRIBUTE_NAME];
            }
        }


        /// <summary>
        /// dbInfos ̒l擾܂B
        /// </summary>
        /// <value>
        /// <see cref="BLogicDbInfoCollection"/> IuWFNgB
        /// </value>
        [ConfigurationProperty(DBINFOS_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public BLogicDbInfoCollection DbInfos
        {
            get
            {
                return (BLogicDbInfoCollection)this[DBINFOS_ATTRIBUTE_NAME];
            }
        }
    }
}
