// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Configuration;
using TERASOLUNA.Fw.Common.Validation.Validators;

namespace TERASOLUNA.Fw.Common.Validation.Configuration
{
    /// <summary>
    /// ݒ񂩂 <see cref="DateTimeFormatValidator"/> 𐶐E邽߂ <see cref="ValidatorData"/> pNXłB
    /// </summary>
    public class DateTimeFormatValidatorData : ValueValidatorData
    {
        private const string DATE_TIME_FORMAT = "dateTimeFormat";

        /// <summary>
        /// <see cref="DateTimeFormatValidatorData"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public DateTimeFormatValidatorData()
        { }

        /// <summary>
        /// t`擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>t`B</value>
        [ConfigurationProperty(DATE_TIME_FORMAT, IsRequired = true)]
        public string DateTimeFormat
        {
            get { return (string)this[DATE_TIME_FORMAT]; }
            set { this[DATE_TIME_FORMAT] = value; }
        }

        /// <summary>
        /// ݒ <see cref="DateTimeFormatValidator"/> ̃CX^X𐶐܂B
        /// </summary>
        /// <remarks>
        /// <see cref="DateTimeFormatValidator"/> ̃CX^X𐶐Aԋp܂B
        /// </remarks>   
        /// <param name="targetType">ؑΏۂ̒ľ^B</param>
        /// <returns>ꂽ <see cref="DateTimeFormatValidator"/> B</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="dateTimeFormat"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="dateTimeFormat"/> 󕶎łB
        /// </exception> 
        protected override Validator DoCreateValidator(Type targetType)
        {
            return new DateTimeFormatValidator(DateTimeFormat,
                                       MessageTemplate,
                                       Tag,
                                       Negated);
        }
    }
}
