// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

namespace TERASOLUNA.Fw.Common.Validation
{
    /// <summary>
    /// ͌؋@\̃G[bZ[Wێ܂B
    /// </summary>
    public class ValidationMessageInfo : MessageInfo
    {
        /// <summary>
        /// G[ӏ\XPathłB
        /// </summary>
        private string _errorPath = null;
       
        /// <summary>
        /// G[ӏ̃^CvłB
        /// </summary>
        private string _errorTypeName = null;
        
        /// <summary>
        /// G[ӏ̃^CgłB
        /// </summary>
        private string _errorTitle = null;

        /// <summary>
        /// G[ӏ\ XPath 擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// G[ӏ\ XPath B
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        public string ErrorPath
        {
            get { return _errorPath; }
            set { _errorPath = value; }
        }
        
        /// <summary>
        /// G[ӏ̃^Cv擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// G[ӏ̃^CvB
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        public string ErrorTypeName
        {
            get { return _errorTypeName; }
            set { _errorTypeName = value; }
        }

        /// <summary>
        /// G[ӏ̃^Cg擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>G[ӏ̃^CgB</value>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        public string ErrorTitle
        {
            get { return _errorTitle; }
            set { _errorTitle = value; }
        }

        /// <summary>
        /// G[񂩂 <see cref="ValidationMessageInfo"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// <paramref name="errorPath"/>  <see cref="System.Data.DataSet"/> ̃G[ӏ XPath łB
        /// </remarks>
        /// <param name="message">G[bZ[WB</param>
        /// <param name="key">G[ӏlB</param>
        /// <param name="errorPath">G[ӏ XPath B</param>
        /// <param name="errorTypeName">G[ӏ̃^CvB</param>
        /// <param name="errorTitle">G[ӏ̃^CgB</param>
        public ValidationMessageInfo(string key, 
                                     string message,
                                     string errorPath,
                                     string errorTypeName,
                                     string errorTitle)
            : base(key, message)
        {
            _errorPath = errorPath;
            _errorTypeName = errorTypeName;
            _errorTitle = errorTitle;
        }

        /// <summary>
        /// G[񂩂 <see cref="ValidationMessageInfo"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="key">G[R[hB</param>
        /// <param name="message">G[bZ[WB</param>
        /// <param name="errorPath">G[ӏ\ XPath B</param>
        public ValidationMessageInfo(string key, string message, string errorPath)
            : base(key, message)
        {
            _errorPath = errorPath;
        }
    }
}
