﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using System.Configuration;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Configuration.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicConfiguration のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicConfiguration 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class BLogicConfigurationTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor.BLOGIC_CONFIGURATION_SECTION_NAME = "blogicConfiguration";
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor._blogicConfigSection = null;
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        [TestCleanup()]
        public void MyTestCleanup()
        {
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor.BLOGIC_CONFIGURATION_SECTION_NAME = "blogicConfiguration";
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor._blogicConfigSection = null;
        }
        
        #endregion


        /// <summary>
        /// GetBLogicTypeName (string) のテスト
        /// </summary>
        /// <TestTarget>GetBLogicTypeName (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に外部設定ファイルに存在するビジネスロジック識別子が指定されていること
        /// </TestCondition>
        /// <TestAssertion>タイプ名が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetBLogicTypeName01()
        {
            string name = "Biz1";
            string expected = "Biz.Class1, Biz";
            string actual;

            actual = BLogicConfiguration.GetBLogicTypeName(name);

            Assert.AreEqual(expected, actual);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetBLogicTypeName (string) のテスト
        /// </summary>
        /// <TestTarget>GetBLogicTypeName (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数にnullが指定されていること
        /// </TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetBLogicTypeName02()
        {
            string name = null;
            string actual;

            try
            {
                actual = BLogicConfiguration.GetBLogicTypeName(name);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("name", e.ParamName);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(BLogicConfiguration), 
                typeof(ArgumentNullException), "E_NULL_ARGUMENT", "name"));
        }

        /// <summary>
        /// GetBLogicTypeName (string) のテスト
        /// </summary>
        /// <TestTarget>GetBLogicTypeName (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に空文字列が指定されていること
        /// </TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetBLogicTypeName03()
        {
            string name = "";
            string actual;

            try
            {
                actual = BLogicConfiguration.GetBLogicTypeName(name);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 成功
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "name"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(BLogicConfiguration),
                typeof(ArgumentException), "E_EMPTY_STRING", "name"));
        }

        /// <summary>
        /// GetBLogicTypeName (string) のテスト
        /// </summary>
        /// <TestTarget>GetBLogicTypeName (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に外部設定ファイルに存在しないビジネスロジック識別子が指定されていること
        /// </TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetBLogicTypeName04()
        {
            string name = "nothing";
            string actual;

            actual = BLogicConfiguration.GetBLogicTypeName(name);

            Assert.IsNull(actual);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetBLogicTypeName (string) のテスト
        /// </summary>
        /// <TestTarget>GetBLogicTypeName (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのappSettings要素に"blogicConfiguration"キーがあり、
        /// value 属性が BLogicConfigurationSection 型ではないこと
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionが発生すること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetBLogicTypeName05()
        {
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor.BLOGIC_CONFIGURATION_SECTION_NAME = "dummyConfiguration";
            string name = "Biz1";

            try
            {
                string actual = BLogicConfiguration.GetBLogicTypeName(name);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string exceptionMessage = MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "BLogicConfiguration", typeof(DummyConfigurationSection).FullName);
                Assert.AreEqual(exceptionMessage, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetBLogicTypeName (string) のテスト
        /// </summary>
        /// <TestTarget>GetBLogicTypeName (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのappSettings要素に"blogicConfiguration"キーがないこと
        /// </TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetBLogicTypeName06()
        {
            TERASOLUNA_Fw_Common_Configuration_TerasolunaConfigurationAccessor.BLOGIC_CONFIGURATION_SECTION_NAME = "noConfiguration";

            string name = "Biz1";
            string actual;

            actual = BLogicConfiguration.GetBLogicTypeName(name);
            Assert.IsNull(actual);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetDbNames (string) のテスト
        ///</summary>
        /// <TestTarget>GetDbNames (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に外部設定ファイルに存在するビジネスロジック識別子が指定されていること
        /// 引数に指定するビジネスロジックに該当するDbInfoノードがないこと
        /// </TestCondition>
        /// <TestAssertion>0件の、設定ファイルのDbInfoノード指定されたname属性の値が取得できること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetDbNames01()
        {
            string name = "Biz3";

            List<string> actual;

            actual = BLogicConfiguration.GetDbNames(name);

            Assert.AreEqual<int>(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetDbNames (string) のテスト
        ///</summary>
        /// <TestTarget>GetDbNames (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に外部設定ファイルに存在するビジネスロジック識別子が指定されていること
        /// 引数に指定するビジネスロジックに該当するDbInfoノードが１件あること
        /// </TestCondition>
        /// <TestAssertion>1件の、設定ファイルのDbInfoノード指定されたname属性の値が取得できること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetDbNames02()
        {
            string name = "Biz1";

            List<string> actual;

            actual = BLogicConfiguration.GetDbNames(name);

            Assert.AreEqual<int>(1, actual.Count);
            Assert.AreEqual<string>("Db1", actual[0]);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
        }
        /// <summary>
        /// GetDbNames (string) のテスト
        ///</summary>
        /// <TestTarget>GetDbNames (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に外部設定ファイルに存在するビジネスロジック識別子が指定されていること
        /// 引数に指定するビジネスロジックに該当するDbInfoノードが３件あること
        /// </TestCondition>
        /// <TestAssertion>3件の、設定ファイルのDbInfoノード指定されたname属性の値が取得できること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetDbNames03()
        {
            string name = "Biz2";

            List<string> actual;

            actual = BLogicConfiguration.GetDbNames(name);

            Assert.AreEqual<int>(3, actual.Count);
            Assert.AreEqual<string>("Db1", actual[0]);
            Assert.AreEqual<string>("Db2", actual[1]);
            Assert.AreEqual<string>("Db3", actual[2]);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetDbNames (string) のテスト
        ///</summary>
        /// <TestTarget>GetDbNames (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に外部設定ファイルに存在しないビジネスロジック識別子が指定されていること
        /// </TestCondition>
        /// <TestAssertion>0件の、設定ファイルのDbInfoノード指定されたname属性の値が取得できること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetDbNames04()
        {
            List<string> actual;

            actual = BLogicConfiguration.GetDbNames("tekito");

            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
        }
        /// <summary>
        /// GetDbNames (string) のテスト
        ///</summary>
        /// <TestTarget>GetDbNames (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に空文字が指定されていること
        /// </TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetDbNames05()
        {
            List<string> actual;
            try
            {
                actual = BLogicConfiguration.GetDbNames("");
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 成功
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "name"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(BLogicConfiguration),
                typeof(ArgumentException), "E_EMPTY_STRING", "name"));
        }
        /// <summary>
        /// GetDbNames (string) のテスト
        ///</summary>
        /// <TestTarget>GetDbNames (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数にnullが指定されていること
        /// </TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestGetDbNames06()
        {
            List<string> actual;
            try
            {
                actual = BLogicConfiguration.GetDbNames(null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("name", e.ParamName);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログ確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(BLogicConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(BLogicConfiguration),
                typeof(ArgumentNullException), "E_NULL_ARGUMENT", "name"));
        }

    }
}