﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Logging;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging.TraceSourceLog;
using TERASOLUNA.Fw.Common;
namespace TERASOLUNA.Fw.CommonUT.Logging
{
    /// <summary>
    /// LogFactory のテストクラスです。
    /// </summary>
    [TestClass()]
    public class LogFactoryTest
    {
        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = null;
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = 
                "TERASOLUNA.Fw.Common.Logging.TraceSourceLog.TraceSourceLogFactory, TERASOLUNA.Fw.Common";
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        [TestCleanup()]
        public void MyTestCleanup()
        {
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = null;
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "LogFactoryTypeName";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] =
                "TERASOLUNA.Fw.Utlib.Logging.LogUTFactory, TERASOLUNA.Fw.Utlib";
        }
        
        #endregion

        #region GetLogger<T>(string, params object[]) のテスト

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が null、args の要素数が 0 の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest01()
        {
            // 準備
            string className = null;

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: className", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 空文字列、args の要素数が 0 の場合、
        /// ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest02()
        {
            // 準備
            string className = string.Empty;

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual("引数 \"className\" の値を空文字列にすることはできません。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings タグ内に、APP_KEY_FACTORY_PROPERTY と一致する
        /// key 属性を持つ add 要素がない場合、
        /// TraceSourceLogger のインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest03()
        {
            // 準備
            string className = "className";
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(className);
           
            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest04()
        {
            // 準備
            string className = "className";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// args の要素数が 1 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest05()
        {
            // 準備
            string className = "className";
            object[] args = { "args0" };
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// args の要素数が 3 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest06()
        {
            // 準備
            string className = "className";
            object[] args = { "args0", "args1", "args2" };
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger<ILog>(className, args);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// _logFactory フィールドが null でない場合、取得したインスタンスが
        /// キャッシュされている ILog 実装クラスのインスタンスであることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest07()
        {
            // 準備
            string className = "className";
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 準備
            LogFactory.GetLogger<ILog>(className);
            LogFactory logFactory = TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory;

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(className);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.AreSame(logFactory, TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 空文字列の場合、
        /// TraceSourceLogger のインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest08()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = string.Empty;

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(className);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 存在しないタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest09()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "NotExistsLogFactoryTypeName";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("アセンブリ修飾名 \"NotExistsLogFactoryTypeName\" の型を取得できませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 抽象クラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest10()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub01, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                string message = "引数 \"targetType\" の型 \"" + typeof(LogFactory_Stub01).AssemblyQualifiedName + "\" は抽象クラスであるため、インスタンスを作成できません。";
                Assert.AreEqual(message, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 型パラメータが未設定なジェネリック型のタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest11()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub02`1, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                string message = "引数 \"targetType\" の型 \"" + typeof(LogFactory_Stub02<>).AssemblyQualifiedName + "\" はジェネリック型ですが、型パラメータが設定されていない型です。";
                Assert.AreEqual(message, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// コンストラクタ呼び出しに失敗するクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest12()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub03, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub03\" のコンストラクタの呼び出しに失敗しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// コンストラクタが例外をスローするクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest13()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub04, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub04\" のコンストラクタで例外が発生しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承していないクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest14()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub05, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub05\" を型 \"TERASOLUNA.Fw.Common.Logging.LogFactory\" にキャストできませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しているが GetInstance メソッドの返り値が null 
        /// であるクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest15()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub06, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.Common.Logging.ILog\" のインスタンスの生成に失敗しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しており GetInstance メソッドの返り値が T 型に 
        /// キャストできるクラスのタイプ名の場合、
        /// T 型のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest16()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub07, TERASOLUNA.Fw.CommonUT";

            // 実施
            ILog target = LogFactory.GetLogger<LogFactory_ILogStub01>(className);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(LogFactory_ILogStub01));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しているが GetInstance メソッドの返り値が T 型に 
        /// キャストできないクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest17()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub08, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<LogFactory_ILogStub01>(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_ILogStub02\" を型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_ILogStub01\" にキャストできませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        #endregion

        #region GetLogger<T>(Type, params object[]) のテスト

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が null、args の要素数が 0 の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest01()
        {
            // 準備
            Type classType = null;

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: classType", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 0 であり、
        /// 構成ファイルの appSettings タグ内に、APP_KEY_FACTORY_PROPERTY と一致する
        /// key 属性を持つ add 要素がない場合、
        /// TraceSourceLogger のインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest02()
        {
            // 準備
            Type classType = typeof(Object);
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(classType);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest03()
        {
            // 準備
            Type classType = typeof(Object);

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// args の要素数が 1 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest04()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "args0" };
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// args の要素数が 3 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest05()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "args0", "args1", "args2" };
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// _logFactory フィールドが null でない場合、取得したインスタンスが
        /// キャッシュされている ILog 実装クラスのインスタンスであることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest06()
        {
            // 準備
            Type classType = typeof(Object);
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 準備
            LogFactory.GetLogger<ILog>(classType);
            LogFactory logFactory = TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory;

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(classType);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.AreSame(logFactory, TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 空文字列の場合、
        /// TraceSourceLogger のインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest07()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = string.Empty;

            // 実施
            ILog target = LogFactory.GetLogger<TraceSourceLogger>(classType);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(TraceSourceLogger));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 存在しないタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest08()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "NotExistsLogFactoryTypeName";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("アセンブリ修飾名 \"NotExistsLogFactoryTypeName\" の型を取得できませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 抽象クラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest09()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub01, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                string message = "引数 \"targetType\" の型 \"" + typeof(LogFactory_Stub01).AssemblyQualifiedName + "\" は抽象クラスであるため、インスタンスを作成できません。";
                Assert.AreEqual(message, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 型パラメータが未設定なジェネリック型のタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest10()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub02`1, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                string message = "引数 \"targetType\" の型 \"" + typeof(LogFactory_Stub02<>).AssemblyQualifiedName + "\" はジェネリック型ですが、型パラメータが設定されていない型です。";
                Assert.AreEqual(message, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// コンストラクタ呼び出しに失敗するクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest11()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub03, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub03\" のコンストラクタの呼び出しに失敗しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// コンストラクタが例外をスローするクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest12()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub04, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub04\" のコンストラクタで例外が発生しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承していないクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest13()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub05, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub05\" を型 \"TERASOLUNA.Fw.Common.Logging.LogFactory\" にキャストできませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しているが GetInstance メソッドの返り値が null 
        /// であるクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest14()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub06, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.Common.Logging.ILog\" のインスタンスの生成に失敗しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しており GetInstance メソッドの返り値が T 型に 
        /// キャストできるクラスのタイプ名の場合、
        /// T 型のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest15()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub07, TERASOLUNA.Fw.CommonUT";

            // 実施
            ILog target = LogFactory.GetLogger<LogFactory_ILogStub01>(classType);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(LogFactory_ILogStub01));
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しているが GetInstance メソッドの返り値が T 型に 
        /// キャストできないクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest16()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub08, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<LogFactory_ILogStub01>(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_ILogStub02\" を型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_ILogStub01\" にキャストできませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        #endregion

        #region GetLogger(string, params object[]) のテスト

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が null、args の要素数が 0 の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest01()
        {
            // 準備
            string className = null;

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: className", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 空文字列、args の要素数が 0 の場合、
        /// ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest02()
        {
            // 準備
            string className = string.Empty;

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual("引数 \"className\" の値を空文字列にすることはできません。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings タグ内に、APP_KEY_FACTORY_PROPERTY と一致する
        /// key 属性を持つ add 要素がない場合、
        /// ILog 実装クラスのインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest03()
        {
            // 準備
            string className = "className";
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger(className);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest04()
        {
            // 準備
            string className = "className";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// args の要素数が 1 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest05()
        {
            // 準備
            string className = "className";
            object[] args = { "args0" };
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger(className, args);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// args の要素数が 3 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest06()
        {
            // 準備
            string className = "className";
            object[] args = { "args0", "args1", "args2" };
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger(className, args);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// _logFactory フィールドが null でない場合、取得したインスタンスが
        /// キャッシュされている ILog 実装クラスのインスタンスであることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest07()
        {
            // 準備
            string className = "className";
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 準備
            LogFactory.GetLogger(className);
            LogFactory logFactory = TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory;

            // 実施
            ILog target = LogFactory.GetLogger(className);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.AreSame(logFactory, TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 空文字列の場合、
        /// ILog 実装クラスのインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest08()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = string.Empty;

            // 実施
            ILog target = LogFactory.GetLogger(className);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 存在しないタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest09()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "NotExistsLogFactoryTypeName";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("アセンブリ修飾名 \"NotExistsLogFactoryTypeName\" の型を取得できませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 抽象クラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest10()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub01, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                string message = "引数 \"targetType\" の型 \"" + typeof(LogFactory_Stub01).AssemblyQualifiedName + "\" は抽象クラスであるため、インスタンスを作成できません。";
                Assert.AreEqual(message, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 型パラメータが未設定なジェネリック型のタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest11()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub02`1, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                string message = "引数 \"targetType\" の型 \"" + typeof(LogFactory_Stub02<>).AssemblyQualifiedName + "\" はジェネリック型ですが、型パラメータが設定されていない型です。";
                Assert.AreEqual(message, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// コンストラクタ呼び出しに失敗するクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest12()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub03, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub03\" のコンストラクタの呼び出しに失敗しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// コンストラクタが例外をスローするクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest13()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub04, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub04\" のコンストラクタで例外が発生しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承していないクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest14()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub05, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub05\" を型 \"TERASOLUNA.Fw.Common.Logging.LogFactory\" にキャストできませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しているが GetInstance メソッドの返り値が null 
        /// であるクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest15()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub06, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.Common.Logging.ILog\" のインスタンスの生成に失敗しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しており GetInstance メソッドの返り値が null でないクラスのタイプ名の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest16()
        {
            // 準備
            string className = "className";
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub07, TERASOLUNA.Fw.CommonUT";

            // 実施
            ILog target = LogFactory.GetLogger(className);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        #endregion

        #region GetLogger(Type, params object[]) のテスト

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が null、args の要素数が 0 の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest01()
        {
            // 準備
            Type classType = null;

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: classType", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 0 であり、
        /// 構成ファイルの appSettings タグ内に、APP_KEY_FACTORY_PROPERTY と一致する
        /// key 属性を持つ add 要素がない場合、
        /// ILog 実装クラスのインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest02()
        {
            // 準備
            Type classType = typeof(Object);
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger(classType);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest03()
        {
            // 準備
            Type classType = typeof(Object);

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// args の要素数が 1 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest04()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "args0" };
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger(classType, args);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// args の要素数が 3 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest05()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "args0", "args1", "args2" };
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 実施
            ILog target = LogFactory.GetLogger(classType, args);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// _logFactory フィールドが null でない場合、取得したインスタンスが
        /// キャッシュされている ILog 実装クラスのインスタンスであることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest06()
        {
            // 準備
            Type classType = typeof(Object);
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor.APP_KEY_FACTORY_PROPERTY = "DummyTypeName";

            // 準備
            LogFactory.GetLogger(classType);
            LogFactory logFactory = TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory;

            // 実施
            ILog target = LogFactory.GetLogger(classType);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.AreSame(logFactory, TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 空文字列の場合、
        /// ILog 実装クラスのインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest07()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = string.Empty;

            // 実施
            ILog target = LogFactory.GetLogger(classType);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 存在しないタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest08()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "NotExistsLogFactoryTypeName";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("アセンブリ修飾名 \"NotExistsLogFactoryTypeName\" の型を取得できませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 抽象クラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest09()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub01, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                string message = "引数 \"targetType\" の型 \"" + typeof(LogFactory_Stub01).AssemblyQualifiedName + "\" は抽象クラスであるため、インスタンスを作成できません。";
                Assert.AreEqual(message, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// 型パラメータが未設定なジェネリック型のタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest10()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub02`1, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                string message = "引数 \"targetType\" の型 \"" + typeof(LogFactory_Stub02<>).AssemblyQualifiedName + "\" はジェネリック型ですが、型パラメータが設定されていない型です。";
                Assert.AreEqual(message, e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// コンストラクタ呼び出しに失敗するクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest11()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub03, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub03\" のコンストラクタの呼び出しに失敗しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// コンストラクタが例外をスローするクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest12()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub04, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub04\" のコンストラクタで例外が発生しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承していないクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest13()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub05, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub05\" を型 \"TERASOLUNA.Fw.Common.Logging.LogFactory\" にキャストできませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しているが GetInstance メソッドの返り値が null 
        /// であるクラスのタイプ名の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest14()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub06, TERASOLUNA.Fw.CommonUT";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("型 \"TERASOLUNA.Fw.Common.Logging.ILog\" のインスタンスの生成に失敗しました。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルの appSettings 要素から "LogFactoryTypeName" をキーとして取得した文字列が、
        /// LogFactory を継承しており GetInstance メソッドの返り値が null でないクラスのタイプ名の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest15()
        {
            // 準備
            Type classType = typeof(Object);
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = "TERASOLUNA.Fw.CommonUT.Logging.LogFactory_Stub07, TERASOLUNA.Fw.CommonUT";

            // 実施
            ILog target = LogFactory.GetLogger(classType);

            // 確認
            Assert.IsNotNull(TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory);
            Assert.IsInstanceOfType(target, typeof(ILog));
        }

        #endregion
    }
}
