﻿using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Logging
{
    /// <summary>
    /// LogFactory 単体試験用の ILog 実装クラスです。
    /// </summary>
    public class LogFactory_ILogStub01 : ILog
    {
        /// <summary>
        /// Trace レベルのログ処理が現在有効かどうかチェックします。
        /// </summary>
        /// <remarks>
        /// ログレベルが trace 以上の場合に(String の連結のような) 
        /// 重い処理を行わないようにこのメソッドを呼んで(チェックして)ください。
        /// </remarks>
        public bool IsTraceEnabled 
        { 
            get
            {
                return false;
            }
        }

        /// <summary>
        /// Debug レベルのログ処理が現在有効かどうかチェックします。
        /// </summary>
        /// <remarks>
        /// ログレベルが debug 以上の場合に(String の連結のような) 
        /// 重い処理を行わないようにこのメソッドを呼んで(チェックして)ください。
        /// </remarks>
        public bool IsDebugEnabled
        {
            get
            {
                return false;
            }
        }

        /// <summary>
        /// Info レベルのログ処理が現在有効かどうかチェックします。
        /// </summary>
        /// <remarks>
        /// ログレベルが Info 以上の場合に(String の連結のような) 
        /// 重い処理を行わないようにこのメソッドを呼んで(チェックして)ください。
        /// </remarks>
        public bool IsInfoEnabled
        {
            get
            {
                return false;
            }
        }

        /// <summary>
        /// Warn レベルのログ処理が現在有効かどうかチェックします。
        /// </summary>
        /// <remarks>
        /// ログレベルが Warn 以上の場合に(String の連結のような) 
        /// 重い処理を行わないようにこのメソッドを呼んで(チェックして)ください。
        /// </remarks>
        public bool IsWarnEnabled
        {
            get
            {
                return false;
            }
        }

        /// <summary>
        /// Error レベルのログ処理が現在有効かどうかチェックします。
        /// </summary>
        /// <remarks>
        /// ログレベルが Error 以上の場合に(String の連結のような) 
        /// 重い処理を行わないようにこのメソッドを呼んで(チェックして)ください。
        /// </remarks>
        public bool IsErrorEnabled
        {
            get
            {
                return false;
            }
        }

        /// <summary>
        /// Fatal レベルのログ処理が現在有効かどうかチェックします。
        /// </summary>
        /// <remarks>
        /// ログレベルが Fatal 以上の場合に(String の連結のような) 
        /// 重い処理を行わないようにこのメソッドを呼んで(チェックして)ください。
        /// </remarks>
        public bool IsFatalEnabled
        {
            get
            {
                return false;
            }
        }

        /// <summary>
        /// Trace ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        public void Trace(object message) { }

        /// <summary>
        /// Trace レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        public void Trace(object message, Exception ex) { }

        /// <summary>
        /// Debug ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        public void Debug(object message) { }

        /// <summary>
        /// Debug レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        public void Debug(object message, Exception ex) { }

        /// <summary>
        /// Info ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        public void Info(object message) { }

        /// <summary>
        /// Info レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        public void Info(object message, Exception ex) { }

        /// <summary>
        /// Warn ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        public void Warn(object message) { }

        /// <summary>
        /// Warn レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        public void Warn(object message, Exception ex) { }

        /// <summary>
        /// Error ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        public void Error(object message) { }

        /// <summary>
        /// Error レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        public void Error(object message, Exception ex) { }

        /// <summary>
        /// Fatal ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        public void Fatal(object message) { }

        /// <summary>
        /// Fatal レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        public void Fatal(object message, Exception ex) { }
    }
}
