﻿using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.Logging.TraceSourceLog;
using TERASOLUNA.Fw.Common.Logging;
using System.Diagnostics;

namespace TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog
{
    /// <summary>
    /// TraceSourceLogger 単体試験用のスタブクラスです。
    /// </summary>
    /// <remarks>
    /// TraceSourceLogger の Write(LogLevel, object, Exception, int) を
    /// 拡張しており、引数に与えられた値をフィールドとして保持します。
    /// </remarks>
    public class TraceSourceLogger_Stub01 : TraceSourceLogger
    {
        public TraceSourceLogger_Stub01(string className, string sourceName)
            : base(className, sourceName)
        { }

        public TraceSourceLogger_Stub01(Type classType, string sourceName)
            : base(classType, sourceName)
        { }

        public bool _flag = false;
        public LogLevel _writeLogLevel = LogLevel.OFF;
        public object _message = null;   
        public Exception _ex = null;
        public int _eventId = 0; 

        protected override void Write(LogLevel logLevel,
                           object message,
                           Exception ex,
                           int eventId)
        {
            _flag = true;
            _writeLogLevel = logLevel;
            _message = message;
            _ex = ex;
            _eventId = eventId;
        }
    }
}
