﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using TERASOLUNA.Fw.Common.Validation.Validators;
using System.Reflection;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Configuration
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Validation.Configuration.ByteRangeValidatorData のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Validation.Configuration.ByteRangeValidatorData 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ByteRangeValidatorDataTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化      
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///ByteRangeValidatorData () のテスト
        ///</summary>
        ///<remarks>
        /// インスタンスが正常に生成されたことを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest()
        {
            ByteRangeValidatorData target = new ByteRangeValidatorData();

        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、minByteLength、maxByteLength、encoding、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest01()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = 3;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(ByteRangeValidator));
            ByteRangeValidator bval = (ByteRangeValidator)val;
            Assert.AreEqual<int>(bval.MaxByteLength, 3);
            Assert.AreEqual<int>(bval.MinByteLength, 3);
            Assert.AreEqual<string>(bval.Encoding.WebName, "shift_jis");
            Assert.AreEqual<string>(bval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、minByteLength、maxByteLength、encoding、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest02()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = typeof(HankakuKanaStringValidator);
            target.MaxByteLength = 3;
            target.MinByteLength = 3;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(ByteRangeValidator));
            ByteRangeValidator bval = (ByteRangeValidator)val;
            Assert.AreEqual<int>(bval.MaxByteLength, 3);
            Assert.AreEqual<int>(bval.MinByteLength, 3);
            Assert.AreEqual<string>(bval.Encoding.WebName, "shift_jis");
            Assert.AreEqual<string>(bval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);
        
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMinByteLengthが-3の場合、ArgumentExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest03()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = -3;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;
        
            // 確認
            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMinByteLengthが0の場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、minByteLength、maxByteLength、encoding、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest04()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = 0;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(ByteRangeValidator));
            ByteRangeValidator bval = (ByteRangeValidator)val;
            Assert.AreEqual<int>(bval.MaxByteLength, 3);
            Assert.AreEqual<int>(bval.MinByteLength, 0);
            Assert.AreEqual<string>(bval.Encoding.WebName, "shift_jis");
            Assert.AreEqual<string>(bval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMaxByteLengthが-3の場合、ArgumentExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest05()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = -3;
            target.MinByteLength = 3;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }


        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMaxByteLengthがMinByteLengthより小さい値の場合、ArgumentExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest06()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 0;
            target.MinByteLength = 3;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;
        
            // 確認
            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMinByteLengthとMaxByteLengthが共に0の場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、minByteLength、maxByteLength、encoding、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest07()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 0;
            target.MinByteLength = 0;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(ByteRangeValidator));
            ByteRangeValidator bval = (ByteRangeValidator)val;
            Assert.AreEqual<int>(bval.MaxByteLength, 0);
            Assert.AreEqual<int>(bval.MinByteLength, 0);
            Assert.AreEqual<string>(bval.Encoding.WebName, "shift_jis");
            Assert.AreEqual<string>(bval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのEncodingNameがnullの場合、ArgumentExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest08()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = 3;
            target.EncodingName = null;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;
        
            // 確認
            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentNullException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentNullException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのEncodingNameが空文字の場合、ArgumentExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest09()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = 3;
            target.EncodingName = "";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのEncodingNameが"932"の場合、ArgumentExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest10()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = 3;
            target.EncodingName = "932";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;
        
            // 確認
            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMessageTemplateが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、minByteLength、maxByteLength、encoding、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest11()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = 3;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = "aaaa";
            target.Negated = true;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(ByteRangeValidator));
            ByteRangeValidator bval = (ByteRangeValidator)val;
            Assert.AreEqual<int>(bval.MaxByteLength, 3);
            Assert.AreEqual<int>(bval.MinByteLength, 3);
            Assert.AreEqual<string>(bval.Encoding.WebName, "shift_jis");
            Assert.AreEqual<string>(bval.Tag, null);
            Assert.AreEqual<string>(bval.MessageTemplate, @"aaaa");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのNegatedがfalseの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、minByteLength、maxByteLength、encoding、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest12()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = 3;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(ByteRangeValidator));
            ByteRangeValidator bval = (ByteRangeValidator)val;
            Assert.AreEqual<int>(bval.MaxByteLength, 3);
            Assert.AreEqual<int>(bval.MinByteLength, 3);
            Assert.AreEqual<string>(bval.Encoding.WebName, "shift_jis");
            Assert.AreEqual<string>(bval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのTagが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、minByteLength、maxByteLength、encoding、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest13()
        {
            // 生成
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.MaxByteLength = 3;
            target.MinByteLength = 3;
            target.EncodingName = "shift_jis";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = "aaaa";

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(ByteRangeValidator));
            ByteRangeValidator bval = (ByteRangeValidator)val;
            Assert.AreEqual<int>(bval.MaxByteLength, 3);
            Assert.AreEqual<int>(bval.MinByteLength, 3);
            Assert.AreEqual<string>(bval.Encoding.WebName, "shift_jis");
            Assert.AreEqual<string>(bval.Tag, "aaaa");
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// EncodingNameプロパティのテスト
        ///</summary>
        ///<remarks>
        /// プロパティに値が設定され、取得した値が適切であることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void EncodingNameTest()
        {
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            Assert.AreEqual<string>(target.EncodingName, "utf-8");

            string val = "utf-8";

            target.EncodingName = val;
            Assert.AreEqual(val, target.EncodingName);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// MaxByteLengthプロパティのテスト
        ///</summary>
        ///<remarks>
        /// プロパティに値が設定され、取得した値が適切であることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void MaxByteLengthTest()
        {
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            Assert.AreEqual<int>(target.MaxByteLength, int.MaxValue);

            target.MaxByteLength = 10;
            Assert.AreEqual<int>(target.MaxByteLength, 10);
        
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        
        }

        ///<summary>
        /// MinByteLengthプロパティのテスト
        ///</summary>
        ///<remarks>
        /// プロパティに値が設定され、取得した値が適切であることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void MinByteLengthTest()
        {
            ByteRangeValidatorData target = new ByteRangeValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_ByteRangeValidatorDataAccessor(target);

            Assert.AreEqual<int>(target.MinByteLength, 0);

            target.MinByteLength = 10;
            Assert.AreEqual<int>(target.MinByteLength, 10);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidatorData), LogLevel.INFO));
        }
    }
}
