﻿// <著作権>
// Copyright (c) 2007, NTT DATA Corporation.
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Validation.Validators;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    /// DateTimeRangeValidatorEx のテストクラスです。
    /// </summary>
    [TestClass()]
    public class DateTimeRangeValidatorExTest
    {


        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがIgnore、最大値のRangeBoundaryTypeがInclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNegatedMessageTemplateTest01()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Ignore,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Inclusive,
                                        null,
                                        true);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;


            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_IG_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val ,actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがIgnore、最大値のRangeBoundaryTypeがExclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNegatedMessageTemplateTest02()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Ignore,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Exclusive,
                                        null,
                                        true);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_IG_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがInclusive、最大値のRangeBoundaryTypeがIgnoreの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNegatedMessageTemplateTest03()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Inclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Ignore,
                                        null,
                                        true);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_IN_IG_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがInclusive、最大値のRangeBoundaryTypeがInclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNegatedMessageTemplateTest04()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Inclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Inclusive,
                                        null,
                                        true);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがInclusive、最大値のRangeBoundaryTypeがExclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNegatedMessageTemplateTest05()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Inclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Exclusive,
                                        null,
                                        true);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_IN_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがExclusive、最大値のRangeBoundaryTypeがIgnoreの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNegatedMessageTemplateTest06()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Exclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Ignore,
                                        null,
                                        true);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_EX_IG_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがExclusive、最大値のRangeBoundaryTypeがInclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNegatedMessageTemplateTest07()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Exclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Inclusive,
                                        null,
                                        true);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_EX_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがExclusive、最大値のRangeBoundaryTypeがExclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNegatedMessageTemplateTest08()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Exclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Exclusive,
                                        null,
                                        true);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_EX_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがIgnore、最大値のRangeBoundaryTypeがInclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNonNegatedMessageTemplateTest01()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Ignore,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Inclusive,
                                        null,
                                        false);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_IG_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがIgnore、最大値のRangeBoundaryTypeがExclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNonNegatedMessageTemplateTest02()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Ignore,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Exclusive,
                                        null,
                                        false);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_IG_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがInclusive、最大値のRangeBoundaryTypeがIgnoreの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNonNegatedMessageTemplateTest03()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Inclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Ignore,
                                        null,
                                        false);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_IG_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがInclusive、最大値のRangeBoundaryTypeがInclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNonNegatedMessageTemplateTest04()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Inclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Inclusive,
                                        null,
                                        false);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがInclusive、最大値のRangeBoundaryTypeがExclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNonNegatedMessageTemplateTest05()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Inclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Exclusive,
                                        null,
                                        false);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
    
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがExclusive、最大値のRangeBoundaryTypeがIgnoreの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNonNegatedMessageTemplateTest06()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Exclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Ignore,
                                        null,
                                        false);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_EX_IG_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがExclusive、最大値のRangeBoundaryTypeがInclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNonNegatedMessageTemplateTest07()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Exclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Inclusive,
                                        null,
                                        false);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_EX_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 最小値のRangeBoundaryTypeがExclusive、最大値のRangeBoundaryTypeがExclusiveの場合、
        /// 取得した値が適切であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod]
        public void DefaultNonNegatedMessageTemplateTest08()
        {
            // 初期化
            DateTimeRangeValidatorEx validator =
                new DateTimeRangeValidatorEx(new DateTime(2008,8,15),
                                        RangeBoundaryType.Exclusive,
                                        new DateTime(2008,8,30),
                                        RangeBoundaryType.Exclusive,
                                        null,
                                        false);
            validator.Tag = "試験対象項目";

            string actual = validator.MessageTemplate;


            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_EX_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorEx), LogLevel.INFO));
        }
    }
}
