// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Utlib.Logging
{
    /// <summary>
    /// O̓eێ邽߂̃NXB
    /// </summary>
    /// <remarks>
    /// Oǂ邽߂ɁAO̓eێB
    /// ȉ̓eێB
    /// <list type="bullet">
    /// <item>seXg\bhB</item>
    /// <item>ObZ[WB</item>
    /// <item>Oo͂̌ƂȂOB</item>
    /// <item>Ox</item>
    /// </list>
    /// </remarks>
    internal class LogObject
    {
        /// <summary>
        /// seXg\bhłB
        /// </summary>
        /// <remarks>
        /// RXgN^ŏ܂B
        /// </remarks>
        private readonly MethodBase _calledMethod;

        /// <summary>
        /// seXg\bhŔObZ[WłB
        /// </summary>
        /// <remarks>
        /// RXgN^ŏ܂B
        /// </remarks>
        private readonly object _logMessage;

        /// <summary>
        /// seXg\bhŃOo͂̌ƂȂOłB
        /// </summary>
        /// <remarks>
        /// RXgN^ŏ܂B
        /// </remarks>
        private readonly Type _exceptionType;

        /// <summary>
        /// OxłB
        /// </summary>
        /// <remarks>
        /// RXgN^ŏ܂B
        /// </remarks>
        private readonly LogLevel _logLevel;

        /// <summary>
        /// seXg\bh擾܂B
        /// </summary>
        public MethodBase CalledMethod
        {
            get
            {
                return _calledMethod;
            }
        }

        /// <summary>
        /// ObZ[W擾܂B
        /// </summary>
        public object LogMessage
        {
            get
            {
                return _logMessage;
            }
        }

        /// <summary>
        /// Oo͂̌ƂȂO擾܂B
        /// </summary>
        public Type ExceptionType
        {
            get
            {
                return _exceptionType;
            }
        }

        /// <summary>
        /// Ox擾܂B
        /// </summary>
        public LogLevel LogLevel
        {
            get
            {
                return _logLevel;
            }
        }

        /// <summary>
        /// <see cref="UnitLogObject"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="calledMethod">seXg\bhB</param>
        /// <param name="logMessage">ObZ[WB</param>
        /// <param name="_exception">Oo͂̌ƂȂOB</param>
        /// <param name="logLevel">OxB</param>
        /// <remarks>RXgN^łB</remarks>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="calledMethod"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="logMessage"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="logLevel"/>  null QƂłB
        /// </item>
        /// </exception>
        public LogObject(MethodBase calledMethod, object logMessage, Type exceptionType, LogLevel logLevel)
        {
            if (calledMethod == null)
            {
                throw new ArgumentNullException("calledMethod");
            }

            if (logMessage == null)
            {
                throw new ArgumentNullException("logMessage");
            }

            _calledMethod = calledMethod;
            _logMessage = logMessage;
            _exceptionType = exceptionType;
            _logLevel = logLevel;
        }

        /// <summary>
        /// IuWFNg̃IuWFNgƓǂB
        /// </summary>
        /// <param name="obj">rΏۂ <see cref="object"/> B</param>
        /// <returns>rʃtOB</returns>
        public override bool Equals(object obj)
        {
            LogObject unitLogObject = obj as LogObject;

            // ^UnitLogObjectł͂Ȃ
            if (unitLogObject == null)
            {
                return false;
            }

            // sĂeXg\bhǂ̃`FbN
            if (!_calledMethod.Equals(unitLogObject.CalledMethod))
            {
                return false;
            }

            // ObZ[Wǂ̃`FbN
            if(!_logMessage.Equals(unitLogObject.LogMessage))
            {
                return false;
            }

            // ǑƂȂOǂ̃`FbN
            // rΏۂ̃IuWFNg̗O^CvƂnull ܂́A
            // rΏۂ̃IuWFNg̗O^CvƂłȂ΁AfalseԋpB
            bool allNull = (_exceptionType == null) && (unitLogObject.ExceptionType == null);
            bool exceptionTypeAreSame = (_exceptionType != null) && (_exceptionType.Equals(unitLogObject.ExceptionType));
            if (!(allNull || exceptionTypeAreSame))
            {
                return false;
            }

            // Oxǂ̃`FbN
            if (!_logLevel.Equals(unitLogObject.LogLevel))
            {
                return false;
            }

            return true;
        }

        /// <summary>
        /// ̃CX^X̏𕶎ƂĎ擾B
        /// </summary>
        /// <returns>CX^XB</returns>
        public override string ToString()
        {
            StringBuilder buffer = new StringBuilder();
            buffer.Append("[");
            buffer.Append(LogLevel);
            if (LogLevel.ToString().Length == 4)
            {
                buffer.Append(" ");
            }
            buffer.Append("] ");

            if (ExceptionType != null)
            {
                buffer.Append("[exceptionType:");
                buffer.Append(ExceptionType);
                buffer.Append("] ");
            }

            buffer.Append(LogMessage);

            return buffer.ToString();
        }

        /// <summary>
        /// nbVR[h擾܂B
        /// </summary>
        /// <returns>nbVR[hB</returns>
        public override int GetHashCode()
        {
            return CalledMethod.ToString().Length 
                + LogMessage.ToString().Length 
                + ExceptionType.ToString().Length 
                + LogLevel.ToString().Length;
        }
    }
}
