// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.ExceptionTransition
{
    /// <summary>
    /// G[ʑJڐݒt@C ExceptionTransitionConfiguration ݒ擾܂B
    /// </summary>
    public abstract class ExceptionTransitionConfiguration
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ExceptionTransitionConfiguration));

        /// <summary>
        /// w肳ꂽOɑΉJڐy[W ID 擾܂B
        /// </summary>
        /// <param name="type">O <see cref="Type"/> B</param>
        /// <returns>
        /// <paramref name="type"/> Ɏw肳ꂽOɑΉJڐy[W ID B
        /// ΉJڐy[W ID ݂Ȃꍇ null QƁB
        /// </returns>
        /// <remarks>
        /// G[ʑJڐݒt@CA<paramref name="type"/> ̒lɑΉ nextPage ̒l擾܂B
        /// Ή nextPage ̒l݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="type"/>  null QƂłB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂B
        /// </exception>
        public static string GetNextPage(Type type)
        {
            if (type == null)
            {
                ArgumentNullException exception = new ArgumentNullException("type");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "type"), exception);
                }
                throw exception;
            }

            string ret = null;

            ExceptionTransitionElement element =
                TerasolunaWebConfiguration.ExceptionTransitionConfigSection.ExceptionTransitionCollection[type.FullName];

            if (element != null)
            {
                ret = element.NextPage;
            }

            if (_log.IsTraceEnabled)
            {
                if (ret == null)
                {
                    string message = string.Format(
                        Properties.Resources.T_EXCEPTION_TRANSITION_CONFIGURATION_NOT_LOAD_PARAMETER, type.FullName);
                    _log.Trace(message);
                }
                else
                {
                    string message = string.Format(
                        Properties.Resources.T_EXCEPTION_TRANSITION_CONFIGURATION_LOAD_PARAMETER, type.FullName, ret);
                    _log.Trace(message);
                }
            }
            return ret;
        }
    }
}
