// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.RequestController
{
    /// <summary>
    /// AvP[V\t@C requestControllerConfiguration ZNV  controller vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="RequestControllerElement"/> ́AAvP[V\t@C requestControllerConfiguration ZNV controller vf\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElement"/> QƂĂB
    /// </remarks>
    public sealed class RequestControllerElement : ConfigurationElement
    {
        /// <summary>
        /// name ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "name" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_NAME = "name";

        /// <summary>
        /// type ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "type" łB
        /// </remarks>
        private const string TYPE_ATTRIBUTE_NAME = "type";

        /// <summary>
        /// <see cref="RequestControllerElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public RequestControllerElement()
        {
        }

        /// <summary>
        /// <see cref="RequestControllerElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="name">name ̒lBType ̖OԂ܂݁AAZu܂܂ȂA^̊SCB</param>
        /// <param name="type">type ̒lBOԂƃAZu܂ތ^̊SCB</param>
        /// <remarks>
        /// name Atype ̒l nameAtype ŏ܂B
        /// </remarks>
        public RequestControllerElement(string name, string type)
        {
            this[NAME_ATTRIBUTE_NAME] = name;
            this[TYPE_ATTRIBUTE_NAME] = type;
        }

        /// <summary>
        /// name ̒l擾܂B
        /// </summary>
        /// <value>
        /// name ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Name
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// type ̒l擾܂B
        /// </summary>
        /// <value>
        /// type ̒lB
        /// </value>
        [ConfigurationProperty(TYPE_ATTRIBUTE_NAME, IsRequired = true)]
        public string Type
        {
            get
            {
                return (string)this[TYPE_ATTRIBUTE_NAME];
            }
        }
    }
}
