// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.Sql
{
    /// <summary>
    /// sql vf̃RNVi[\vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="SqlsCollection"/> ́Ay[Wݒt@C sql vf̃RNV\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElementCollection"/> QƂĂB
    /// </remarks>
    public class SqlsCollection : ConfigurationElementCollection
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(SqlsCollection));

        /// <summary>
        /// sql vf̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "sql" łB
        /// </remarks>
        private const string SQL_ELEMENT_NAME = "sql";

        /// <summary>
        /// <see cref="SqlsCollection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public SqlsCollection()
        {
        }

        /// <summary>
        /// <see cref="SqlsCollection"/> ̌^擾܂B 
        /// </summary>
        /// <remarks>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/>  <seealso cref="ConfigurationElementCollectionType.BasicMap"/> łB
        /// </remarks>
        public override ConfigurationElementCollectionType CollectionType
        {
            get
            {
                return ConfigurationElementCollectionType.BasicMap;
            }
        }

        /// <summary>
        /// V sql vf쐬܂B
        /// </summary>
        /// <returns>V sql vfB</returns>
        /// <remarks>
        /// V <see cref="SqlElement"/> IuWFNg쐬܂B
        /// </remarks>
        protected override ConfigurationElement CreateNewElement()
        {
            return new SqlElement();
        }

        /// <summary>
        /// w肵CfbNXʒuɂ sql vf擾܂B
        /// </summary>
        /// <param name="index">擾 <see cref="SqlElement"/> ̃CfbNXʒuB</param>
        /// <returns>w肵CfbNXʒuɂ <see cref="SqlElement"/> B</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(int)"/> \bhgpāA<see cref="SqlsCollection"/>  <see cref="SqlElement"/> IuWFNg擾܂B
        /// </remarks>
        public SqlElement this[int index]
        {
            get
            {
                return (SqlElement)BaseGet(index);
            }
        }

        /// <summary>
        /// w肵L[ sql vf擾܂B
        /// </summary>
        /// <param name="name">擾 sql vf̃L[B</param>
        /// <returns>w肵L[ <see cref="SqlElement"/>BȊȌꍇ null QƁB</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(object)"/> \bhgpāA<see cref="SqlsCollection"/>  <see cref="SqlElement"/> IuWFNg擾܂B
        /// w肵L[ <see cref="SqlElement"/> IuWFNgRNVɑ݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        public virtual new SqlElement this[string name]
        {
            get
            {
                return (SqlElement)BaseGet(name);
            }
        }

        /// <summary>
        /// <see cref="SqlsCollection"/> ̗vf擾܂B
        /// </summary>
        /// <value>
        /// <see cref="SqlsCollection"/> ̗vfB
        /// </value>
        public virtual new int Count
        {
            get
            {
                return base.Count;
            }
        }

        /// <summary>
        /// SQL ݒt@Ĉ̗vf̃RNVʂ邽߂Ɏgp閼O擾܂B
        /// </summary>
        /// <value>
        /// RNVʂ邽߂Ɏgp閼OB
        /// </value>
        protected override string ElementName
        {
            get
            {
                return SQL_ELEMENT_NAME;
            }
        }

        /// <summary>
        /// sql vf̗vfL[擾܂B
        /// </summary>
        /// <param name="element">L[Ԃ <see cref="SqlElement"/>@B</param>
        /// <returns>w肵 <see cref="SqlElement"/> ̃L[Ƃċ@\ <see cref="Object"/> B</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="element"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="element"/>  <see cref="SqlElement"/> ł͂܂B
        /// </exception>
        protected override Object GetElementKey(ConfigurationElement element)
        {
            if (element == null)
            {
                ArgumentNullException exception = new ArgumentNullException("element");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Web.Properties.Resources.E_NULL_ARGUMENT, "element"), exception);
                }
                throw exception;
            }
            SqlElement sqlElement = element as SqlElement;
            if (sqlElement == null)
            {
                string message = string.Format(Web.Properties.Resources.E_INVALID_TYPE, "element");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            return sqlElement.Name;
        }

        /// <summary>
        /// <see cref="SqlsCollection"/>  sql vfǉ܂B
        /// </summary>
        /// <param name="sql">ǉ <see cref="SqlElement"/> B</param>
        /// <remarks>
        /// <seealso cref="BaseAdd(ConfigurationElement)"/> \bhgpāARNVɐV <see cref="SqlElement"/> ǉ܂B
        /// </remarks>
        public virtual void Add(SqlElement sql)
        {
            BaseAdd(sql);
        }

        /// <summary>
        /// <see cref="SqlsCollection"/>  sql vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="SqlElement"/> B</param>
        /// <remarks>
        /// w肵 <paramref name="element"/>  sql vfRNVɊɑ݂ꍇAO͔܂B
        /// </remarks>
        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        /// <summary>
        /// <see cref="SqlsCollection"/> IuWFNgǂݎpǂl擾܂B 
        /// </summary>
        /// <returns>
        /// <see cref="SqlsCollection"/> IuWFNgǂݎp̏ꍇ true BȊȌꍇ false B
        /// </returns>
        /// <remarks>
        /// SqlsColl<see cref="SqlsCollection"/> IuWFNg͓ǂݎpł͂܂B
        /// </remarks>
        public override bool IsReadOnly()
        {
            return false;
        }

    }
}
