﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License. 

using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace TERASOLUNA.Fw.Web.Controller
{
    /// <summary>
    /// アップロードされたデータを保持するインターフェイスを定義します。
    /// </summary>
    /// <remarks>
    /// <para>マルチパートデータを格納するためのクラスは、本インターフェイスを実装しなければなりません。</para>
    /// </remarks>
    public interface IMultipartItem : IDisposable
    {
        /// <summary>
        /// アップロードデータのヘッダ情報を取得または設定します。
        /// </summary>
        /// <value>
        /// アップロードデータのヘッダ情報。
        /// </value>
        IDictionary<string, string> HeaderList { get; set; }

        /// <summary>
        /// アップロードデータのマルチパートの要素名を取得または設定します。
        /// </summary>
        /// <value>
        /// アップロードデータのマルチパートの要素名。
        /// </value>
        string Name { get; set; }

        /// <summary>
        /// テキストをエンコードするための <seealso cref="Encoding"/> を取得または設定します。
        /// </summary>
        /// <value>
        /// テキストの <seealso cref="Encoding"/> 。
        /// </value>
        Encoding Encoding { get; set; }

        /// <summary>
        /// 格納されているデータがテキストかどうかを取得します。
        /// </summary>
        /// <value>
        /// アップロードデータがテキストデータかどうかのチェックフラグ。
        /// </value>
        bool IsText { get; }

        /// <summary>
        /// ファイルパスを含むファイル名を取得します。
        /// </summary>
        /// <value>
        /// ファイルパスを含むファイル名。
        /// </value>
        string Filename { get; }

        /// <summary>
        /// アップロードデータを <seealso cref="Stream"/> 型にて取得します。
        /// </summary>
        /// <value>
        /// アップロード <see cref="Stream"/> データ。
        /// </value>
        Stream OutputStream { get; }

        /// <summary>
        /// アップロードデータを文字列型にて取得します。
        /// </summary>
        /// <value>
        /// アップロード文字列型データ。
        /// </value>
        string Text { get; }
    }
}
