﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.  

using System.IO;
using System.Text;

namespace TERASOLUNA.Fw.Web.Controller
{
    /// <summary>
    /// <see cref="IMultipartItem"/> を作成するためのインターフェイスを定義します。
    /// </summary>
    /// <remarks>
    /// <para><see cref="IMultipartItem"/> を作成するためのクラスは、本インターフェイスを実装しなければなりません。</para>
    /// </remarks>
    public interface IMultipartItemFactory
    {
        /// <summary>
        /// <see cref="Stream"/> を元にアップロードデータを <see cref="IMultipartItem"/> に保持します。
        /// </summary>
        /// <param name="partStream">アップロードされたデータ。</param>
        /// <returns>アップロードデータ。</returns>
        IMultipartItem CreateItem(Stream partStream);

        /// <summary>
        /// アップロードデータを区切るための文字列です。
        /// </summary>
        /// <value>
        /// アップロードデータ区切り文字列。
        /// </value>
        string Boundary { get; set; }

        /// <summary>
        /// テキストをエンコードするための <seealso cref="Encoding"/> です。
        /// </summary>
        /// <value>
        /// テキストの <see cref="Encoding"/> 。
        /// </value>
        Encoding Encoding { get; set; }
    }
}
