// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.ExceptionCode;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.WebUT.Configuration.ExceptionCode
{
    /// <summary>
    /// TERASOLUNA.Fw.Common.Configuration.ExceptionCodeElement のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Common.Configuration.ExceptionCodeElement 単体テストをここに含めます
    /// </summary>

    [TestClass()]
    public class ExceptionCodeElementTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///ExceptionCodeElement () のテスト
        ///</summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            ExceptionCodeElement target = new ExceptionCodeElement();
            Assert.IsNotNull(target);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeElement), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionCodeElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor02()
        {
            string exceptionType = "System.Exception";
            string code = "E0001";

            ExceptionCodeElement target = new ExceptionCodeElement(exceptionType, code);

            Assert.IsNotNull(target);
            Assert.AreEqual(exceptionType, target.ExceptionType);
            Assert.AreEqual(code, target.Code);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeElement), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionCodeElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition>exceptionTypeが空白の場合</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor03()
        {
            string exceptionType = "";
            string code = "E0001";

            ExceptionCodeElement target = new ExceptionCodeElement(exceptionType, code);

            Assert.IsNotNull(target);
            Assert.AreEqual(exceptionType, target.ExceptionType);
            Assert.AreEqual(code, target.Code);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeElement), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionCodeElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition>exceptionTypeがNullの場合</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor04()
        {
            string exceptionType = null;
            string code = "E0001";

            ExceptionCodeElement target = new ExceptionCodeElement(exceptionType, code);

            Assert.IsNotNull(target);
            Assert.AreEqual(exceptionType, target.ExceptionType);
            Assert.AreEqual(code, target.Code);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeElement), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionCodeElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition>codeが空白の場合</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor05()
        {
            string exceptionType = "System.Exception";
            string code = "";

            ExceptionCodeElement target = new ExceptionCodeElement(exceptionType, code);

            Assert.IsNotNull(target);
            Assert.AreEqual(exceptionType, target.ExceptionType);
            Assert.AreEqual(code, target.Code);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeElement), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionCodeElement (string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string)</TestTarget>
        /// <TestCondition>codeがnullの場合</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor06()
        {
            string exceptionType = "System.Exception";
            string code = null;

            ExceptionCodeElement target = new ExceptionCodeElement(exceptionType, code);

            Assert.IsNotNull(target);
            Assert.AreEqual(exceptionType, target.ExceptionType);
            Assert.AreEqual(code, target.Code);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeElement), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionType のテスト
        /// </summary>
        /// <TestTarget>ExceptionType</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>exceptionTypeの値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestExceptionType01()
        {
            string exceptionType = "System.Exception";
            string code = "E0001";

            ExceptionCodeElement target = new ExceptionCodeElement(exceptionType, code);

            Assert.AreEqual(exceptionType, target.ExceptionType);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeElement), LogLevel.INFO));
        }

        /// <summary>
        /// code のテスト
        /// </summary>
        /// <TestTarget>code</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>code属性の値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestCode01()
        {
            string exceptionType = "System.Exception";
            string code = "E0001";

            ExceptionCodeElement target = new ExceptionCodeElement(exceptionType, code);

            Assert.AreEqual(code, target.Code);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionCodeElement), LogLevel.INFO));
        }
    }
}
