// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.Sql;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;
using TERASOLUNA.Fw.WebUT;
using System.Xml.Schema;
using System.Configuration;
using System.IO;
using TERASOLUNA.Fw.WebUT.Configuration;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.WebUT.Configuration.Sql
{
    /// <summary>
    /// TERASOLUNA.Fw.Common.Configuration.SqlConfigurationSection のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Common.Configuration.SqlConfigurationSection 単体テストをここに含めます
    /// </summary>

    [TestClass()]
    public class SqlConfigurationSectionTest
    {

        private TestContext testContextInstance;
        private const string SQL_CONFIG_SECTION_FILE_NAME_01 = "TestItem_SqlConfigSection01.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_02 = "TestItem_SqlConfigSection02.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_03 = "TestItem_SqlConfigSection03.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_04 = "TestItem_SqlConfigSection04.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_05 = "TestItem_SqlConfigSection05.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_06 = "TestItem_SqlConfigSection06.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_07 = "TestItem_SqlConfigSection07.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_08 = "TestItem_SqlConfigSection08.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_09 = "TestItem_SqlConfigSection09.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_10 = "TestItem_SqlConfigSection10.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_11 = "TestItem_SqlConfigSection11.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_12 = "TestItem_SqlConfigSection12.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_13 = "TestItem_SqlConfigSection13.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_15 = "TestItem_SqlConfigSection15.config";
        private const string SQL_CONFIG_SECTION_FILE_NAME_16 = "TestItem_SqlConfigSection16.config";

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// SqlConfigurationSection () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            SqlConfigurationSection target = new SqlConfigurationSection();
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Files のテスト
        /// </summary>
        /// <TestTarget>Files</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>FilesCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestFiles01()
        {
            SqlConfigurationSection target = new SqlConfigurationSection();
            Assert.IsInstanceOfType(target.Files, typeof(FilesCollection));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Sqls のテスト
        /// </summary>
        /// <TestTarget>Sqls</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>SqlsCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestSqls01()
        {
            SqlConfigurationSection target = new SqlConfigurationSection();
            Assert.IsInstanceOfType(target.Sqls, typeof(SqlsCollection));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>外部設定ファイルの設定情報がSqlsプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection01.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal01.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal02.config")]
        public void TestCreateSqlElements01()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_01);
            target.CreateSqlElements();

            Assert.AreEqual("1", target.Sqls[0].Name);
            Assert.AreEqual("SELECT 1 FROM TABLE", target.Sqls[0].Statement);
            Assert.AreEqual("2", target.Sqls[1].Name);
            Assert.AreEqual("UPDATE TABLE SET COLUMN = 2", target.Sqls[1].Statement);
            Assert.AreEqual("3", target.Sqls[2].Name);
            Assert.AreEqual("INSERT INTO TABLE VALUES (3)", target.Sqls[2].Statement);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>構成ファイルに設定されている外部設定ファイルが存在しないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection02.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal01.config")]
        public void TestCreateSqlElements02()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_02);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\Nothing.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(FileNotFoundException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>構成ファイルにfile要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection03.config")]
        public void TestCreateSqlElements03()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_03);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", "sqlConfiguration");
                Assert.AreEqual(message, e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>外部設定ファイルがXML形式でないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection04.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal03.config")]
        public void TestCreateSqlElements04()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_04);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_SqlExternal03.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性にファイル名に使用できない文字が含まれていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection05.config")]
        public void TestCreateSqlElements05()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_05);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + Path.DirectorySeparatorChar + @"TestItem_SqlExternalX>.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が260文字以上であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection06.config")]
        public void TestCreateSqlElements06()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_06);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\1111111111222222222233333333334444444444555555555566666666667777777777888888888899999999990000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999000000000011111111112222222222333333333344444\TestItem_SqlExternalXX.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(PathTooLongException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が無効なパスであること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection07.config")]
        public void TestCreateSqlElements07()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_07);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\a\a";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(DirectoryNotFoundException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのsql要素のname属性の値が重複していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection08.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal04.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal05.config")]
        public void TestCreateSqlElements08()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_08);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_MERGED_CONFIG", "sql:sqlConfiguration");
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのsqlConfiguration要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection09.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal06.config")]
        public void TestCreateSqlElements09()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_09);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_SqlExternal06.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのsql要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection10.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal07.config")]
        public void TestCreateSqlElements10()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_10);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_SqlExternal07.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのsql要素のname属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection11.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal08.config")]
        public void TestCreateSqlElements11()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_11);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_SqlExternal08.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        // <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>同一SQL設定外部ファイルに重複するSQL文IDが存在すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection15.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal10.config")]
        public void TestCreateSqlElements12()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_15);

            try
            {
                target.CreateSqlElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_SqlExternal10.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "sqlConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateSqlElements () のテスト
        /// </summary>
        /// <TestTarget>CreateSqlElements()</TestTarget>
        /// <TestCondition>sql要素のname属性が空文字である場合</TestCondition>
        /// <TestAssertion>空文字が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlConfigSection16.config")]
        [DeploymentItem(@"Configuration\Sql\TestItem_SqlExternal11.config")]
        public void TestCreateSqlElements13()
        {
            SqlConfigurationSection target = ConfigTestHelper.GetSqlConfigurationSectionFromCustomFile(SQL_CONFIG_SECTION_FILE_NAME_16);

            target.CreateSqlElements();

            Assert.AreEqual("", target.Sqls[0].Name);
            Assert.AreEqual("SELECT 1 FROM TABLE", target.Sqls[0].Statement);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(SqlConfigurationSection), LogLevel.INFO));
        }
    }
}
