// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Controller;
using System.Web;
using System.IO;
using TERASOLUNA.Fw.WebUT;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using System.Reflection;
using TERASOLUNA.Fw.Common;
namespace TERASOLUNA.Fw.WebUT.Controller
{
    /// <summary>
    ///TERASOLUNA.Fw.Web.Controller.FileUploadRequestController のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Web.Controller.FileUploadRequestController 単体テストをここに含めます
    ///</summary>
   
    [TestClass()]
    public class FileUploadRequestControllerTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>デコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName01()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "attachment; filename=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=";

            string expected = "あいうえお.csv";
            string actual;

            actual = accessor.GetContentFileName(contentDisposition);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、attachmentが指定されていないこと。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>デコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName02()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "filename=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=";

            string expected = "あいうえお.csv";
            string actual;

            actual = accessor.GetContentFileName(contentDisposition);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// filenameパラメータ以外のパラメータも設定されていること。
        /// パラメータに、attachmentが指定されていること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>デコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName03()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "attachment; filename=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=; modification-date=\"Wed, 12 Feb 1997 16:29:51 +0900\"";

            string expected = "あいうえお.csv";
            string actual;

            actual = accessor.GetContentFileName(contentDisposition);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータなし。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName04()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "attachment; aaa=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=";

            string actual;

            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME"), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME"));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionのフォーマットが不正であること。
        /// パラメータに、Attachmentを指定していること。
        /// filenameパラメータが設定値として正しいフォーマットであること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName05()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "attachment filename=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=";

            string actual;
            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME"), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME"));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてISO-2022-JP以外でGetEncodingで取得できる文字コードセット名を指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>デコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName06()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "UTF-7";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "attachment; filename=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=";

            string expected = "あいうえお.csv";
            string actual;

            actual = accessor.GetContentFileName(contentDisposition);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてプラットフォームでサポートされていない文字コードを指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName07()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-CN";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.UTF8;
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);
            string expectedFileName = "?" + inputEncodingName + "?" + inputAsciiEncodingType + "?" + inputEncodingFileName + "?=";
            string contentDisposition =
                "attachment; filename=" + expectedFileName;

            string actual;

            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException ex)
            {
                //InvalidRequestException re = ex.InnerException as InvalidRequestException;
                Assert.AreEqual(typeof(InvalidRequestException).Name, ex.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName), ex.Message);
            }
            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName));
        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットでプラットフォームでサポートされているものを小文字で指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>デコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName08()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "iso-2022-jp";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "attachment; filename=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=";

            string expected = "あいうえお.csv";
            string actual;

            actual = accessor.GetContentFileName(contentDisposition);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));

        }

        /// <summary>
        /// GetContentFileName (string) のテスト
        /// </summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとして空文字を指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName09()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "B";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string expectedFileName = "?" + "" + "?" + inputAsciiEncodingType + "?" + inputEncodingFileName + "?=";
            string contentDisposition =
                "attachment; filename=" + expectedFileName;

            string actual;
            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてB以外を指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName10()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "Q";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string expectedFileName = "?" + inputEncodingName + "?" + inputAsciiEncodingType + "?" + inputEncodingFileName + "?=";
            string contentDisposition =
                "attachment; filename=" + expectedFileName;

            string actual;

            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式として空文字を指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName11()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string expectedFileName = "?" + inputEncodingName + "?" + inputAsciiEncodingType + "?" + inputEncodingFileName + "?=";
            string contentDisposition =
                "attachment; filename=" + expectedFileName;

            string actual;

            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてb(小文字)を指定すること。
        /// 元のファイル名を全角文字とするとこ。
        /// </TestCondition>
        /// <TestAssertion>デコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName12()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "あいうえお.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "b";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "attachment; filename=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=";

            string expected = "あいうえお.csv";
            string actual;

            actual = accessor.GetContentFileName(contentDisposition);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// 元のファイル名を半角英数記号とするとこ。
        /// </TestCondition>
        /// <TestAssertion>デコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName13()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string ordinalFileName = "abcde12345.csv";

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "b";

            Encoding enc = Encoding.GetEncoding(inputEncodingName);
            byte[] encodingBytes = enc.GetBytes(ordinalFileName);
            string inputEncodingFileName = Convert.ToBase64String(encodingBytes);

            string contentDisposition =
                "attachment; filename=?"
                + inputEncodingName + "?"
                + inputAsciiEncodingType + "?"
                + inputEncodingFileName
                + "?=";

            string expected = "abcde12345.csv";
            string actual;

            actual = accessor.GetContentFileName(contentDisposition);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値として正しいフォーマットであること。
        /// パラメータに、Attachmentを指定していること。
        /// 文字コードセットとしてISO-2022-JPを指定すること。
        /// ASCIIへのエンコード形式としてBを指定すること。
        /// エンコーディングファイル名に空文字が指定されること。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName14()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string inputEncodingName = "ISO-2022-JP";
            string inputAsciiEncodingType = "b";

            string inputEncodingFileName = string.Empty;

            string expectedFileName = "?" + inputEncodingName + "?" + inputAsciiEncodingType + "?" + inputEncodingFileName + "?=";
            string contentDisposition =
                "attachment; filename=" + expectedFileName;

            string actual;

            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// Content-Dispositionとして正しいフォーマットであること。
        /// filenameパラメータの設定値としてMIMEエンコーディング形式となっていないフォーマットで設定すること。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName15()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string expectedFileName = "abcde.csv";
            string contentDisposition =
                "attachment; filename=" + expectedFileName;

            string actual;

            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// 引数contentDispositionに空文字を指定すること。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName16()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string contentDisposition = "";

            string actual;

            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME"), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME"));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// 引数contentDispositionにnullを指定すること。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName17()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string contentDisposition = "";

            string actual;

            try
            {
                actual = accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException e)
            {
                //InvalidRequestException exception = e.InnerException as InvalidRequestException;
                Assert.AreEqual(MessageManager.GetMessage("E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME"), e.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME"));

        }

        /// <summary>
        ///GetContentFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// 引数contentDispositionにBase64でデコードできない文字列を指定すること。
        /// </TestCondition>
        /// <TestAssertion>例外 <see cref="InvalidRequestException"/> をスローすること。</TestAssertion>
        [TestMethod()]
        public void TestGetContentFileName18()
        {
            FileUploadRequestController target = new FileUploadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileUploadRequestControllerAccessor(target);

            string expectedFileName = "?ISO-2022-JP?B?12345?=";
            string contentDisposition =
                "attachment; filename=" + expectedFileName;

            try
            {
                accessor.GetContentFileName(contentDisposition);
                Assert.Fail("到達してはいけないコードに到達しました。");
            }
            catch (InvalidRequestException ex)
            {
                //InvalidRequestException re = ex.InnerException as InvalidRequestException;
                Assert.AreEqual(typeof(InvalidRequestException).Name, ex.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName), ex.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileUploadRequestController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(FileUploadRequestController), typeof(InvalidRequestException), "E_INVALID_CONTENT_DISPOSITION_FILENAME", expectedFileName));
        }
    }
}
