﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Common.BLogic;
using TutorialServerWeb.Dto.ItemDataSetTableAdapters;
using TutorialServerWeb.Dto;

namespace TutorialServerWeb.BLogic
{
    /// <summary>
    /// 商品情報を取得するビジネスロジック。
    /// </summary>
    public class SelectItemBLogic : IBLogic
    {
        /// <summary>
        /// 商品情報を取得する。
        /// </summary>
        /// <param name="paramData">ビジネスロジック入力クラス。</param>
        /// <returns>ビジネスロジック出力クラス。</returns>
        public BLogicResult Execute(BLogicParam param)
        {
            // 引数に格納されたカテゴリIDを取得する
            SelectItemParamDataSet paramDataSet = (SelectItemParamDataSet)param.ParamData;
            string selectedCategoryId = paramDataSet.SelectItemParam[0].CategoryId;

            // TableAdapterを生成する
            ItemTableAdapter adapter = new ItemTableAdapter();
            ItemDataSet.ItemDataTable dataTable = new ItemDataSet.ItemDataTable();
            
            if ("all".Equals(selectedCategoryId))
            {
                // TableAdapterを用いて、すべての商品情報を取得する
                dataTable = adapter.GetData();
            }
            else
            {
                // TableAdapterを用いて、画面で入力されたカテゴリIDの商品情報を取得する
                dataTable = adapter.SelectCategory(selectedCategoryId);
            }

            // ビジネスロジック出力データセットを生成する
            ItemDataSet itemDataSet = new ItemDataSet();

            // TableAdapterの実行結果のDataTableを、ビジネスロジック出力データセットにマージする
            itemDataSet.Merge(dataTable);

            BLogicResult result = new BLogicResult(BLogicResult.SUCCESS, itemDataSet);

            return result;
        }
    }
}
