﻿using System.ComponentModel;
using TERASOLUNA.Fw.Web.Configuration.Sql;
using System.Data.SqlClient;
namespace TutorialServerWeb.Dto
{
    /// <summary>
    /// ItemDataSetのpertialクラス。
    /// </summary>
    partial class ItemDataSet
    {
    }
}

namespace TutorialServerWeb.Dto.ItemDataSetTableAdapters
{
    /// <summary>
    /// ItemDataSetのTableAdapter。
    /// </summary>
    public partial class ItemTableAdapter
    {
        /// <summary>
        /// 商品情報の一覧を取得する。
        /// </summary>
        /// <param name="categoryId">カテゴリID</param>
        /// <returns>商品情報テーブル</returns>
        [DataObjectMethod(DataObjectMethodType.Select)]
        public ItemDataSet.ItemDataTable SelectCategory(string categoryId)
        {
            // SQL文管理機能を用いて、外部ファイルからSQL文を取得する
            SqlCommand sqlCommand = new SqlCommand(SqlConfiguration.GetSql("selectItemByCategoryId"), this.Connection);
            
            sqlCommand.Parameters.AddWithValue("@categoryId", categoryId);

            SqlDataAdapter adapter = new SqlDataAdapter(sqlCommand);

            ItemDataSet.ItemDataTable dataTable = new ItemDataSet.ItemDataTable();

            // SQLを発行し、データベースから取得した商品情報をDataTableに格納する
            adapter.Fill(dataTable);

            return dataTable;
        }

    }
}
