﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Web;
using TERASOLUNA.Fw.Web.Session;

namespace TutorialServerWeb.Form
{
    public partial class LogonForm : System.Web.UI.Page
    {
        /// <summary>
        /// セッション管理クラス。
        /// </summary>
        private SessionManager _sessionManager = null;

        /// <summary>
        /// 初期化メソッドをオーバーライドし、SessionManagerのインスタンスを生成する。
        /// </summary>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);

            // セッション管理クラスの生成
            _sessionManager = new SessionManager(this.Session);
        }

        /// <summary>
        /// セッション管理クラスの作成およびセッションの削除を行う。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // ライフサイクルレベル0のセッションを削除する。
                _sessionManager.Remove(0);
            }
        }

        /// <summary>
        /// ログオン処理を行う。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonLogon_Click(object sender, EventArgs e)
        {
            // ユーザIDが"tera"、パスワードが"soluna"の場合、
            // ログオン成功とみなしメニュー画面への遷移を行う。
            if ("tera".Equals(TextBoxUserId.Text) && "soluna".Equals(TextBoxPassword.Text))
            {
                // セッション（ライフサイクルレベル0）にユーザIDを登録する
                _sessionManager.Add("UserId", TextBoxUserId.Text, 0);

                WebUtils.Transit("MenuForm");
            }
            else
            {
                // ログオンに失敗した場合、エラーメッセージを表示する
                LabelLogonError.Visible = true;
            }
        }
    }
}
