/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.AttributeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.ImplementInfoSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.TableNameSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.dialog.model.EditTable;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.model.CombinationTableType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CombinationTableEditDialog
extends Dialog
implements PropertyChangeListener {
    private CombinationTable original;
    private EditTable entity;
    private CombinationTable editedValue;
    private String title;
    private TableNameSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private ImplementInfoSettingPanel panel3;
    private Combo typeCombo;

    public CombinationTableEditDialog(Shell parentShell, String title, CombinationTable original) {
        super(parentShell);
        this.title = title;
        this.original = original;
        this.entity = new EditTable(original);
        this.entity.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_edit_property_attributes")) {
            this.panel2.updateAttributeTable();
        }
    }

    public boolean close() {
        this.entity.removePropertyChangeListener(this);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new TableNameSettingPanel(composite, 0);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        this.typeCombo = new Combo(composite, 8);
        this.typeCombo.add("L-\u771f");
        this.typeCombo.add("F-\u771f");
        this.panel3 = new ImplementInfoSettingPanel(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.panel3.setLayoutData(gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.panel2 = new AttributeSettingPanel(composite, 0, this.entity);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        this.initializeValue();
        return composite;
    }

    private void initializeValue() {
        this.panel1.setTableName(this.original.getName());
        if (this.original.getCombinationTableType().equals((Object)CombinationTableType.L_TRUTH)) {
            this.typeCombo.select(0);
        } else {
            this.typeCombo.select(1);
        }
        this.panel3.initializeValue(this.original.isNotImplement(), this.original.getImplementName());
    }

    protected void okPressed() {
        try {
            this.editedValue = (CombinationTable)this.original.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.editedValue.setName(this.panel1.getTableName());
        this.editedValue.setNotImplement(this.panel3.isNotImplement());
        this.editedValue.setImplementName(this.panel3.getImplementName());
        if (this.typeCombo.getSelectionIndex() == 0) {
            this.editedValue.setCombinationTableType(CombinationTableType.L_TRUTH);
        } else {
            this.editedValue.setCombinationTableType(CombinationTableType.F_TRUTH);
        }
        this.editedValue.setAttributes(this.entity.getAttributesOrder());
        this.editedValue.setKeyModels(this.entity.getKeyModels());
        this.editedValue.setImplementDerivationModels(this.entity.getImplementDerivationModels());
        super.okPressed();
    }

    public List<EditAttribute> getEditAttributeList() {
        return this.entity.getAttributes();
    }

    public AbstractEntityModel getEditedValue() {
        return this.editedValue;
    }
}

