/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.KeyModels;

public class EditTable {
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_NAME = "_edit_property_name";
    public static final String PROPERTY_ATTRIBUTES = "_edit_property_attributes";
    protected AbstractEntityModel entity;
    protected String name;
    protected boolean notImplement = false;
    protected String implementName = "";
    protected List<EditAttribute> attributes = new ArrayList<EditAttribute>();
    private List<EditAttribute> newAttributes = new ArrayList<EditAttribute>();
    private List<EditAttribute> deleteAttributes = new ArrayList<EditAttribute>();

    public EditTable(AbstractEntityModel model) {
        this.entity = model;
        this.name = model.getName();
        this.notImplement = model.isNotImplement();
        this.implementName = model.getImplementName();
        for (IAttribute a : this.entity.getAttributes()) {
            this.attributes.add(new EditAttribute(a));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public int getMaxAttributeIndex() {
        return this.attributes.size() - 1;
    }

    public void addAttribute() {
        EditAttribute ea = new EditAttribute();
        ea.setName("\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8" + String.valueOf(this.attributes.size() + 1));
        this.attributes.add(ea);
        this.newAttributes.add(ea);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, null, ea);
    }

    public void upAttribute(int index) {
        int newIndex = index - 1;
        EditAttribute attribute = this.attributes.remove(index);
        this.attributes.add(newIndex, attribute);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, index, newIndex);
    }

    public void downAttribute(int index) {
        int newIndex = index + 1;
        EditAttribute attribute = this.attributes.remove(index);
        this.attributes.add(newIndex, attribute);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, index, newIndex);
    }

    public void editAttribute(int index, EditAttribute attribute) {
        this.attributes.remove(index);
        this.attributes.add(index, attribute);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, null, attribute);
    }

    public void deleteAttribute(int index) {
        EditAttribute deleted = this.attributes.remove(index);
        this.deleteAttributes.add(deleted);
        this.firePropertyChange(PROPERTY_ATTRIBUTES, deleted, null);
    }

    public void uptoIdentifier(int index) {
    }

    public List<EditAttribute> getAttributes() {
        return this.attributes;
    }

    public EditAttribute getEditAttribute(int index) {
        return this.attributes.get(index);
    }

    public List<IAttribute> getAttributesOrder() {
        ArrayList<IAttribute> order = new ArrayList<IAttribute>();
        for (EditAttribute ea : this.attributes) {
            order.add(ea.getOriginalAttribute());
        }
        return order;
    }

    public boolean isNotImplement() {
        return this.notImplement;
    }

    public void setNotImplement(boolean notImplement) {
        this.notImplement = notImplement;
    }

    public String getImplementName() {
        return this.implementName;
    }

    public void setImplementName(String implementName) {
        this.implementName = implementName;
    }

    public boolean canUpToIdentifier() {
        return false;
    }

    public KeyModels getKeyModels() {
        return this.entity.getKeyModels();
    }

    public List<AbstractEntityModel> getImplementDerivationModels() {
        return this.entity.getImplementDerivationModels();
    }
}

