/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlUtilsConverter {
    private static Logger logger = LoggerFactory.getLogger(DdlUtilsConverter.class);

    public Database convert(Diagram diagram, List<AbstractEntityModel> models) {
        Database database = new Database();
        database.setName(diagram.getName());
        for (AbstractEntityModel model : models) {
            this.addModel(database, (ModelElement)model);
        }
        return database;
    }

    private void addModel(Database database, ModelElement model) {
        AbstractEntityModel entity;
        if (model instanceof AbstractEntityModel && !(entity = (AbstractEntityModel)model).isNotImplement()) {
            database.addTable(this.convert(entity));
        }
    }

    private Table convert(AbstractEntityModel entity) {
        Table table = new Table();
        table.setName(entity.getImplementName());
        List attributes = ImplementRule.findAllImplementAttributes((AbstractEntityModel)entity);
        HashMap<IAttribute, Column> attributeColumnMap = new HashMap<IAttribute, Column>();
        for (IAttribute a : attributes) {
            Column column = this.convert(a);
            table.addColumn(column);
            attributeColumnMap.put(a, column);
        }
        for (KeyModel idx : entity.getKeyModels()) {
            table.addIndex(this.convert(idx, attributeColumnMap));
        }
        return table;
    }

    private Index convert(KeyModel key, Map<IAttribute, Column> attributeColumnMap) {
        Object index = null;
        index = key.isUnique() ? new UniqueIndex() : new NonUniqueIndex();
        index.setName(key.getName());
        for (IAttribute attr : key.getAttributes()) {
            Column column = attributeColumnMap.get(attr);
            if (column != null) {
                IndexColumn indexColumn = new IndexColumn(column);
                index.addColumn(indexColumn);
                continue;
            }
            logger.error("column not found." + attr.getName());
        }
        return index;
    }

    private Column convert(IAttribute attribute) {
        Column column = new Column();
        column.setName(attribute.getImplementName());
        DataTypeDeclaration dtd = attribute.getDataTypeDeclaration();
        if (dtd != null) {
            StandardSQLDataType dataType = dtd.getLogicalType();
            column.setTypeCode(dataType.getSqlType());
            if (dataType.isSupportSize() && dtd.getSize() != null) {
                column.setSize(dtd.getSize().toString());
            }
            if (dataType.isSupportScale() && dtd.getScale() != null) {
                column.setScale(dtd.getScale().intValue());
            }
        }
        column.setRequired(!attribute.isNullable());
        return column;
    }

    public void addCommonColumns(Database database, List<IAttribute> commonAttributes) {
        if (commonAttributes == null) {
            return;
        }
        Table[] tableArray = database.getTables();
        int n = tableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Table t = tableArray[n2];
            this.addCommonColumns(t, commonAttributes);
            ++n2;
        }
    }

    private void addCommonColumns(Table t, List<IAttribute> commonAttributes) {
        for (IAttribute a : commonAttributes) {
            t.addColumn(this.convert(a));
        }
    }
}

