/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.command;

import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.ModelElement;
import org.eclipse.gef.commands.Command;

public class ModelConstraintChangeCommand
extends Command {
    private ModelElement model;
    private Constraint constraint;
    private Constraint oldConstraint;

    public ModelConstraintChangeCommand(ModelElement model, Constraint constraint) {
        this.model = model;
        this.constraint = constraint;
        this.oldConstraint = model.getConstraint();
    }

    public ModelConstraintChangeCommand(ModelElement model, int newX, int newY) {
        this.model = model;
        this.oldConstraint = model.getConstraint();
        this.constraint = model.getConstraint().getTranslated(newX, newY);
        System.out.println("old constraint x,y=" + this.oldConstraint.x + "," + this.oldConstraint.y);
        System.out.println("new constraint x,y=" + this.constraint.x + "," + this.constraint.y);
    }

    public void execute() {
        this.model.setConstraint(this.constraint);
    }

    public void undo() {
        this.model.setConstraint(this.oldConstraint);
    }
}

