/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.preferences.appearance;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ColorAppearancePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite colorFields;
    private List<ColorFieldEditor> colorFieldEditors = new ArrayList<ColorFieldEditor>();
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("entityColorEnablePreference")) {
                Boolean colorEnabled = (Boolean)event.getNewValue();
                ColorAppearancePreferencePage.this.setColorFieldsEnabled(colorEnabled);
            }
        }
    };

    public ColorAppearancePreferencePage() {
        super(1);
        this.setPreferenceStore(TMDPlugin.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener(this.listener);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.setColorFieldsEnabled(this.getPreferenceStore().getBoolean("entityColorEnablePreference"));
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Group colorGroup = new Group(parent, 0);
        colorGroup.setText(Messages.ColorSettings);
        colorGroup.setLayout((Layout)new GridLayout(1, true));
        this.colorFields = new Composite((Composite)colorGroup, 0);
        new Label(this.colorFields, 0);
        Label l = new Label(this.colorFields, 0);
        l.setText(Messages.BackgroundColors);
        ModelAppearance[] modelAppearanceArray = ModelAppearance.values();
        int n = modelAppearanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelAppearance a = modelAppearanceArray[n2];
            this.colorFieldEditors.add(new ColorFieldEditor(a.getBackgroundColorPropertyName(), a.getLabel(), this.colorFields));
            ++n2;
        }
        for (ColorFieldEditor e : this.colorFieldEditors) {
            this.addField((FieldEditor)e);
        }
    }

    private void setColorFieldsEnabled(boolean enabled) {
        for (ColorFieldEditor e : this.colorFieldEditors) {
            e.setEnabled(enabled, this.colorFields);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener(this.listener);
        super.dispose();
    }
}

