/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.core.Configuration;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.model.parts.ModelName;

public class Entity
extends AbstractEntityModel {
    private String physicalName = "";
    private Identifier identifier = new Identifier();

    protected Entity() {
    }

    public static Entity ofResource(Identifier identifier) {
        return Entity.ofResource(null, identifier);
    }

    public static Entity ofResource(ModelName entityName, Identifier identifier) {
        Entity resource = Entity.of(entityName, identifier);
        resource.setEntityType(EntityType.RESOURCE);
        return resource;
    }

    public static Entity ofEvent(Identifier identifier) {
        return Entity.ofEvent(null, identifier);
    }

    public static Entity ofEvent(ModelName entityName, Identifier identifier) {
        Entity event = Entity.of(entityName, identifier);
        event.setEntityType(EntityType.EVENT);
        return event;
    }

    private static Entity of(ModelName modelName, Identifier identifier) {
        ModelName entityName = null;
        entityName = modelName == null || modelName.isEmpty() ? identifier.createEntityName() : modelName;
        Entity entity = new Entity();
        entity.setName(entityName.getValue());
        entity.setIdentifier(identifier);
        return entity;
    }

    public Entity withDefaultAttribute() {
        this.addDefaultAttribute();
        return this;
    }

    private void addDefaultAttribute() {
        String attributeName = null;
        DataTypeDeclaration dataType = null;
        if (this.isEvent()) {
            attributeName = Entity.getDefaultEventAttributeName(this.getName());
            dataType = new DataTypeDeclaration(StandardSQLDataType.DATE, null, null);
        } else {
            attributeName = Entity.getDefaultResourceAttributeName(this.getName());
            dataType = new DataTypeDeclaration(StandardSQLDataType.CHARACTER_VARYING, 10, null);
        }
        if (this.hasAttribute(attributeName)) {
            return;
        }
        Attribute attribute = new Attribute(attributeName);
        attribute.setImplementName(attributeName);
        attribute.setDataTypeDeclaration(dataType);
        this.addAttribute(attribute);
    }

    public static String getDefaultResourceAttributeName(String entityName) {
        String format = Configuration.getDefault().getResourceAttributeFormat();
        return String.format(format, entityName);
    }

    public static String getDefaultEventAttributeName(String entityName) {
        String format = Configuration.getDefault().getEventAttributeFormat();
        return String.format(format, entityName);
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        Identifier oldValue = this.identifier;
        this.identifier = identifier;
        this.firePropertyChange("_property_identifier", oldValue, identifier);
    }

    public void setIdentifierName(String identifierName) {
        String oldValue = this.identifier.getName();
        this.identifier.setName(identifierName);
        if (oldValue == null || !oldValue.equals(identifierName)) {
            this.firePropertyChange("_property_identifier", oldValue, this.identifier);
            this.fireIdentifierChanged(null);
        }
    }

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        return new ReusedIdentifier(this.identifier, this.keyModels.getSurrogateKey());
    }

    @Override
    public boolean isEntityTypeEditable() {
        return this.getModelSourceConnections().isEmpty() && this.getModelTargetConnections().isEmpty();
    }

    @Override
    public boolean isDeletable() {
        if (this.getEntityType() == EntityType.EVENT) {
            return this.getModelSourceConnections().isEmpty();
        }
        return this.getModelSourceConnections().isEmpty() && this.getModelTargetConnections().isEmpty();
    }

    @Override
    public void copyTo(AbstractEntityModel to) {
        if (to instanceof Entity) {
            Entity toEntity = (Entity)to;
            toEntity.setIdentifierName(this.getIdentifier().getName());
            toEntity.getIdentifier().copyFrom(this.getIdentifier());
        }
        super.copyTo(to);
    }

    @Override
    public Entity getCopy() {
        Entity copy = new Entity();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public int calcurateMaxIdentifierRefSize() {
        int i = this.getIdentifier().getName().length();
        return Math.max(super.calcurateMaxIdentifierRefSize(), i);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean canCreateMultivalueAnd() {
        return true;
    }
}

