/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectManager;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.internal.navigator.resources.workbench.ResourceExtensionLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class NestedProjectsLabelProvider
extends ResourceExtensionLabelProvider {
    private IResourceChangeListener refreshSeveritiesOnProblemMarkerChange;
    private ProblemsModelSupplier supplier;
    private CompletableFuture<Map<IResource, Integer>> severities = null;

    @Override
    public void init(ICommonContentExtensionSite aConfig) {
        super.init(aConfig);
        this.supplier = new ProblemsModelSupplier();
        this.severities = this.refreshSeverities(null);
        this.refreshSeveritiesOnProblemMarkerChange = event -> {
            if (event.getDelta() == null) {
                return;
            }
            HashSet<IResource> dirtyResources = new HashSet<IResource>();
            MarkerManager markerManager = ((Workspace)WorkbenchNavigatorPlugin.getWorkspace()).getMarkerManager();
            try {
                event.getDelta().accept(delta -> {
                    IMarkerDelta[] markerDeltas;
                    IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
                    int n = markerDeltas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                        if (markerManager.isSubtype(markerDelta.getType(), "org.eclipse.core.resources.problemmarker")) {
                            if (this.severities != null && !this.severities.isDone()) {
                                this.severities.cancel(true);
                                this.severities = null;
                                return false;
                            }
                            dirtyResources.add(markerDelta.getResource());
                        }
                        ++n2;
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
            if (!dirtyResources.isEmpty()) {
                this.severities = this.refreshSeverities(dirtyResources);
            }
        };
        WorkbenchNavigatorPlugin.getWorkspace().addResourceChangeListener(this.refreshSeveritiesOnProblemMarkerChange);
    }

    public void dispose() {
        WorkbenchNavigatorPlugin.getWorkspace().removeResourceChangeListener(this.refreshSeveritiesOnProblemMarkerChange);
        super.dispose();
    }

    private CompletableFuture<Map<IResource, Integer>> refreshSeverities(Set<IResource> dirty) {
        if (dirty != null) {
            this.supplier.markDirty(dirty);
        }
        return CompletableFuture.supplyAsync(this.supplier);
    }

    protected String decorateText(String input, Object element) {
        super.decorateText(input, element);
        if (!(element instanceof IProject)) {
            return input;
        }
        IProject project = (IProject)element;
        IPath location = project.getLocation();
        if (location != null && !location.lastSegment().equals(project.getName())) {
            return String.valueOf(input) + " (in " + location.lastSegment() + ")";
        }
        return input;
    }

    @Override
    protected int getHighestProblemSeverity(IResource resource) {
        int problemSeverity = super.getHighestProblemSeverity(resource);
        if (resource instanceof IContainer && problemSeverity < 2) {
            try {
                Integer severity;
                CompletableFuture<Map<IResource, Integer>> severitiesSnapshot = this.severities;
                if (severitiesSnapshot != null && (severity = severitiesSnapshot.get(50000000L, TimeUnit.MILLISECONDS).get(resource)) != null) {
                    problemSeverity = Math.max(problemSeverity, severity);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
        }
        return problemSeverity;
    }

    private final class ProblemsModelSupplier
    implements Supplier<Map<IResource, Integer>> {
        private Set<IResource> dirty = null;
        private Map<IResource, Integer> cache = new HashMap<IResource, Integer>();

        private ProblemsModelSupplier() {
        }

        @Override
        public Map<IResource, Integer> get() {
            HashSet<IResource> currentDirty = null;
            if (this.dirty != null) {
                currentDirty = new HashSet<IResource>();
                currentDirty.addAll(this.dirty);
                this.dirty.removeAll(currentDirty);
                this.removeFromCache(currentDirty);
            }
            try {
                IMarker[] iMarkerArray = WorkbenchNavigatorPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int severity;
                    IMarker marker = iMarkerArray[n2];
                    IResource resource = marker.getResource();
                    if ((currentDirty == null || currentDirty.contains(resource)) && (severity = marker.getAttribute("severity", 0)) >= 0) {
                        this.propagateSeverityToCache(resource, severity);
                    }
                    ++n2;
                }
                this.markDirty(Collections.emptySet());
            }
            catch (CoreException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
                throw new RuntimeException(e);
            }
            catch (CancellationException cancellationException) {
                return Collections.emptyMap();
            }
            return this.cache;
        }

        private void removeFromCache(Set<IResource> toRemove) {
            HashSet<IContainer> dirtyLeafContainers = new HashSet<IContainer>();
            for (IResource resource : toRemove) {
                IContainer initialContainer = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
                dirtyLeafContainers.removeIf(leafContainer -> leafContainer.getLocation().isPrefixOf(initialContainer.getLocation()));
                if (dirtyLeafContainers.stream().noneMatch(leafContainer -> initialContainer.getLocation().isPrefixOf(leafContainer.getLocation()))) {
                    dirtyLeafContainers.add(initialContainer);
                }
                if (resource.getType() == 1) {
                    this.cache.remove(resource);
                }
                IContainer container = initialContainer;
                while (container != null && this.cache.containsKey(container)) {
                    this.cache.remove(container);
                    container = this.getParentInView((IResource)container);
                }
            }
            dirtyLeafContainers.forEach(leafContainer -> {
                IContainer container = leafContainer;
                while (container != null) {
                    int severity = this.getMaxChildrenSeverityInCache(container);
                    if (severity >= 0) {
                        this.propagateSeverityToCache((IResource)container, severity);
                    }
                    container = this.getParentInView((IResource)container);
                }
            });
        }

        private int getMaxChildrenSeverityInCache(IContainer container) {
            if (!container.isAccessible()) {
                return -1;
            }
            HashSet<Object> children = new HashSet<Object>();
            try {
                children.addAll(Arrays.asList(container.members()));
            }
            catch (CoreException ex) {
                WorkbenchNavigatorPlugin.log("Cannot access members", WorkbenchNavigatorPlugin.createErrorStatus(ex.getMessage(), ex));
            }
            children.addAll(Arrays.asList(NestedProjectManager.getInstance().getDirectChildrenProjects(container)));
            int[] severity = new int[]{-1};
            children.forEach(child -> {
                if (this.cache.containsKey(child) && this.cache.get(child) > severity[0]) {
                    nArray[0] = this.cache.get(child);
                }
            });
            return severity[0];
        }

        private void propagateSeverityToCache(IResource resource, int severity) {
            while (resource != null) {
                if (!this.cache.containsKey(resource) || this.cache.get(resource) < severity) {
                    this.cache.put(resource, severity);
                    resource = this.getParentInView(resource);
                    continue;
                }
                resource = null;
            }
        }

        private IContainer getParentInView(IResource resource) {
            if (resource.getType() == 4) {
                return NestedProjectManager.getInstance().getMostDirectOpenContainer((IProject)resource);
            }
            return resource.getParent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markDirty(Set<IResource> dirty) {
            ProblemsModelSupplier problemsModelSupplier = this;
            synchronized (problemsModelSupplier) {
                if (this.dirty == null) {
                    this.dirty = new HashSet<IResource>();
                }
            }
            this.dirty.addAll(dirty);
        }
    }
}

