/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.dynamic.compiler.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;
import org.dyndns.nuda.dynamic.compiler.SourceBean;
import org.dyndns.nuda.dynamic.compiler.SourceResolver;
import org.dyndns.nuda.dynamic.compiler.resolver.AutoResolver;
import org.dyndns.nuda.dynamic.compiler.resolver.NOPResolver;
import org.dyndns.nuda.dynamic.compiler.resolver.renderer.SourceRenderer;

public class TextSourceResolver
implements SourceResolver {
    private static final String STR_PTN_PACKAGE = "package (.+?);";
    private static final String STR_PTN_CLASS = ".+? class (.+?) (extends|implements)?";
    private static final int INT_IDX_PACKAGE = 1;
    private static final int INT_IDX_CLASS = 1;
    private static final Pattern PTN_PACKAGE = Pattern.compile("package (.+?);", 32);
    private static final Pattern PTN_CLASS = Pattern.compile(".+? class (.+?) (extends|implements)?", 32);
    private String source = "";
    private String packageName = "";
    private String simpleClassName = "";
    private Object target = null;
    private SourceRenderer stringRenderer = new StringRenderer();
    private SourceRenderer stringWriterRenderer = new StringWriterRenderer();
    private SourceRenderer fileRenderer = new FileRenderer();
    private SourceRenderer stringBuilderRenderer = new StringBuilderRenderer();

    public TextSourceResolver() {
    }

    public TextSourceResolver(String source) {
        this.source = source;
    }

    public TextSourceResolver(File source) {
        String tmpSource;
        this.source = tmpSource = "";
    }

    public TextSourceResolver(StringWriter writer) {
        this.source = writer.toString();
    }

    @Override
    public SourceBean resolve() {
        Matcher classNameMatcher;
        if (this.target != null) {
            if (this.stringRenderer.accept(this.target)) {
                this.source = this.stringRenderer.render(this.target);
            } else if (this.stringWriterRenderer.accept(this.target)) {
                this.source = this.stringWriterRenderer.render(this.target);
            } else if (this.fileRenderer.accept(this.target)) {
                this.source = this.fileRenderer.render(this.target);
            } else if (this.stringBuilderRenderer.accept(this.target)) {
                this.source = this.stringBuilderRenderer.render(this.target);
            }
        } else if (this.source == null) {
            return new NOPResolver().resolve();
        }
        Matcher packageNameMatcher = PTN_PACKAGE.matcher(this.source);
        if (packageNameMatcher.find()) {
            this.packageName = packageNameMatcher.group(1);
        }
        if ((classNameMatcher = PTN_CLASS.matcher(this.source)).find()) {
            this.simpleClassName = classNameMatcher.group(1);
        }
        SourceBean result = new SourceBean();
        result.setPackageName(this.packageName);
        result.setSimpleClassName(this.simpleClassName);
        result.setSourceCode(this.source);
        return result;
    }

    public String toString() {
        return "[package=" + this.packageName + "][class=" + this.simpleClassName + "]";
    }

    @Override
    public boolean accept(Object target) {
        if (this.stringRenderer.accept(target)) {
            return true;
        }
        if (this.stringWriterRenderer.accept(target)) {
            return true;
        }
        if (this.fileRenderer.accept(target)) {
            return true;
        }
        return this.stringBuilderRenderer.accept(target);
    }

    @Override
    public void setTarget(Object target) {
        this.target = target;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public void init() {
        AutoResolver.addResolver(this);
    }

    private class FileRenderer
    implements SourceRenderer {
        private FileRenderer() {
        }

        @Override
        public boolean accept(Object target) {
            if (target == null) {
                return false;
            }
            if (target instanceof File) {
                File target0 = (File)target;
                if (!target0.exists()) {
                    return false;
                }
                if (target0.isDirectory()) {
                    return false;
                }
                String fileName = target0.getName();
                return (fileName = fileName.toLowerCase()).indexOf(JavaFileObject.Kind.SOURCE.extension) != -1;
            }
            return false;
        }

        @Override
        public String render(Object target) {
            String string;
            PrintWriter pw;
            StringWriter sw;
            BufferedReader br;
            InputStreamReader isr;
            block15: {
                File file = (File)target;
                FileInputStream fis = null;
                isr = null;
                br = null;
                String result = "";
                sw = null;
                pw = null;
                try {
                    fis = new FileInputStream(file);
                    isr = new InputStreamReader(fis);
                    br = new BufferedReader(isr);
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    while (br.ready()) {
                        pw.println(br.readLine());
                    }
                    string = result = sw.toString();
                    if (fis == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                        if (pw != null) {
                            pw.flush();
                            pw.close();
                        }
                        if (sw != null) {
                            sw.flush();
                            sw.close();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return result;
                    }
                }
                fis.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.flush();
                pw.close();
            }
            if (sw != null) {
                sw.flush();
                sw.close();
            }
            return string;
        }
    }

    private class StringBuilderRenderer
    implements SourceRenderer {
        private StringBuilderRenderer() {
        }

        @Override
        public boolean accept(Object target) {
            if (target == null) {
                return false;
            }
            if (target instanceof StringBuilder) {
                StringBuilder target0 = (StringBuilder)target;
                return !target0.toString().isEmpty();
            }
            return false;
        }

        @Override
        public String render(Object target) {
            StringBuilder b = (StringBuilder)target;
            return b.toString();
        }
    }

    private class StringRenderer
    implements SourceRenderer {
        private StringRenderer() {
        }

        @Override
        public boolean accept(Object target) {
            if (target == null) {
                return false;
            }
            if (target instanceof String) {
                String target0 = (String)target;
                return !target0.isEmpty();
            }
            return false;
        }

        @Override
        public String render(Object target) {
            return (String)target;
        }
    }

    private class StringWriterRenderer
    implements SourceRenderer {
        private StringWriterRenderer() {
        }

        @Override
        public boolean accept(Object target) {
            if (target == null) {
                return false;
            }
            if (target instanceof StringWriter) {
                StringWriter target0 = (StringWriter)target;
                return !target0.toString().isEmpty();
            }
            return false;
        }

        @Override
        public String render(Object target) {
            StringWriter sw = (StringWriter)target;
            String result = sw.toString();
            sw.flush();
            try {
                sw.close();
                return result;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
    }
}

