/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util;

import java.io.FileInputStream;
import java.security.MessageDigest;

public class Digest {
    public void printDigest(byte[] digest) {
        int i = 0;
        while (i < digest.length) {
            int d = digest[i];
            if (d < 0) {
                d += 256;
            }
            if (d < 16) {
                System.out.print("0");
            }
            System.out.print(Integer.toString(d, 16));
            ++i;
        }
        System.out.println();
    }

    public String outputDigest(byte[] digest) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < digest.length) {
            int d = digest[i];
            if (d < 0) {
                d += 256;
            }
            if (d < 16) {
                b.append("0");
            }
            b.append(Integer.toString(d, 16));
            ++i;
        }
        return b.toString();
    }

    public byte[] getFileDigest(String filename) throws Exception {
        int len;
        MessageDigest md = MessageDigest.getInstance("MD5");
        FileInputStream in = new FileInputStream(filename);
        byte[] dat = new byte[256];
        while ((len = in.read(dat)) >= 0) {
            md.update(dat, 0, len);
        }
        in.close();
        return md.digest();
    }

    public byte[] getStringDigest(String data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] dat = data.getBytes();
        md.update(dat);
        return md.digest();
    }

    public static void main(String[] args) throws Exception {
        Digest d = new Digest();
        d.printDigest(d.getStringDigest("dat\u914d\u5217\u306e\u5148\u982d\u304b\u3089len\u307e\u3067\u306e\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u3092\u8a08\u7b97\u3059\u308b"));
    }
}

