package org.dyndns.nuda.dynamic.compiler;

import java.net.URI;

import javax.tools.SimpleJavaFileObject;

/**
 * Javaソースファイルを表すクラスです
 * 
 * @author nkoseki
 * 
 */
public class JavaSourceFromString extends SimpleJavaFileObject {
	
	protected final String	code;
	
	protected JavaSourceFromString(final String name, final String code) {
		super(URI.create(new StringBuilder().append("string:///")
				.append(name.replace(".", "/")).append(Kind.SOURCE.extension)
				.toString()), Kind.SOURCE);
		
		this.code = code;
	}
	
	protected JavaSourceFromString(final SourceBean source) {
		super(URI.create(new StringBuilder().append("string:///")
				.append(source.getClassName().replace(".", "/"))
				.append(Kind.SOURCE.extension).toString()), Kind.SOURCE);
		
		this.code = source.getSourceCode();
	}
	
	@Override
	public CharSequence getCharContent(final boolean ignoreEncodingErrors) {
		return this.code;
	}
	
}
