/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class NaiveBayesSimple
extends Classifier {
    protected double[][][] m_Counts;
    protected double[][] m_Means;
    protected double[][] m_Devs;
    protected double[] m_Priors;
    protected Instances m_Instances;
    protected static double NORM_CONST = Math.sqrt(Math.PI * 2);

    public String globalInfo() {
        return LocalString.get("Class for building and using a simple Naive Bayes classifier.") + LocalString.get("Numeric attributes are modelled by a normal distribution. For more ") + LocalString.get("information, see\n\n") + LocalString.get("Richard Duda and Peter Hart (1973). Pattern ") + LocalString.get("Classification and Scene Analysis. Wiley, New York.");
    }

    public void buildClassifier(Instances instances) throws Exception {
        double d;
        Object object;
        Object object2;
        int n = 0;
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        if (instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException(LocalString.get("Naive Bayes: Class is numeric!"));
        }
        this.m_Instances = new Instances(instances, 0);
        this.m_Counts = new double[instances.numClasses()][instances.numAttributes() - 1][0];
        this.m_Means = new double[instances.numClasses()][instances.numAttributes() - 1];
        this.m_Devs = new double[instances.numClasses()][instances.numAttributes() - 1];
        this.m_Priors = new double[instances.numClasses()];
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            int n2;
            object2 = (Attribute)enumeration.nextElement();
            if (((Attribute)object2).isNominal()) {
                for (n2 = 0; n2 < instances.numClasses(); ++n2) {
                    this.m_Counts[n2][n] = new double[((Attribute)object2).numValues()];
                }
            } else {
                for (n2 = 0; n2 < instances.numClasses(); ++n2) {
                    this.m_Counts[n2][n] = new double[1];
                }
            }
            ++n;
        }
        object2 = instances.enumerateInstances();
        while (object2.hasMoreElements()) {
            Instance instance = (Instance)object2.nextElement();
            if (instance.classIsMissing()) continue;
            object = instances.enumerateAttributes();
            n = 0;
            while (object.hasMoreElements()) {
                Attribute attribute = (Attribute)object.nextElement();
                if (!instance.isMissing(attribute)) {
                    if (attribute.isNominal()) {
                        double[] dArray = this.m_Counts[(int)instance.classValue()][n];
                        int n3 = (int)instance.value(attribute);
                        dArray[n3] = dArray[n3] + 1.0;
                    } else {
                        double[] dArray = this.m_Means[(int)instance.classValue()];
                        int n4 = n;
                        dArray[n4] = dArray[n4] + instance.value(attribute);
                        double[] dArray2 = this.m_Counts[(int)instance.classValue()][n];
                        dArray2[0] = dArray2[0] + 1.0;
                    }
                }
                ++n;
            }
            int n5 = (int)instance.classValue();
            this.m_Priors[n5] = this.m_Priors[n5] + 1.0;
        }
        Enumeration enumeration2 = instances.enumerateAttributes();
        n = 0;
        while (enumeration2.hasMoreElements()) {
            object = (Attribute)enumeration2.nextElement();
            if (((Attribute)object).isNumeric()) {
                for (int i = 0; i < instances.numClasses(); ++i) {
                    if (this.m_Counts[i][n][0] < 2.0) {
                        throw new Exception(LocalString.get("attribute ") + ((Attribute)object).name() + LocalString.get(": less than two values for class ") + instances.classAttribute().value(i));
                    }
                    double[] dArray = this.m_Means[i];
                    int n6 = n;
                    dArray[n6] = dArray[n6] / this.m_Counts[i][n][0];
                }
            }
            ++n;
        }
        object2 = instances.enumerateInstances();
        while (object2.hasMoreElements()) {
            object = (Instance)object2.nextElement();
            if (((Instance)object).classIsMissing()) continue;
            enumeration2 = instances.enumerateAttributes();
            n = 0;
            while (enumeration2.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration2.nextElement();
                if (!((Instance)object).isMissing(attribute) && attribute.isNumeric()) {
                    double[] dArray = this.m_Devs[(int)((Instance)object).classValue()];
                    int n7 = n;
                    dArray[n7] = dArray[n7] + (this.m_Means[(int)((Instance)object).classValue()][n] - ((Instance)object).value(attribute)) * (this.m_Means[(int)((Instance)object).classValue()][n] - ((Instance)object).value(attribute));
                }
                ++n;
            }
        }
        enumeration2 = instances.enumerateAttributes();
        n = 0;
        while (enumeration2.hasMoreElements()) {
            object = (Attribute)enumeration2.nextElement();
            if (((Attribute)object).isNumeric()) {
                for (int i = 0; i < instances.numClasses(); ++i) {
                    if (this.m_Devs[i][n] <= 0.0) {
                        throw new Exception(LocalString.get("attribute ") + ((Attribute)object).name() + LocalString.get(": standard deviation is 0 for class ") + instances.classAttribute().value(i));
                    }
                    double[] dArray = this.m_Devs[i];
                    int n8 = n;
                    dArray[n8] = dArray[n8] / (this.m_Counts[i][n][0] - 1.0);
                    this.m_Devs[i][n] = Math.sqrt(this.m_Devs[i][n]);
                }
            }
            ++n;
        }
        enumeration2 = instances.enumerateAttributes();
        n = 0;
        while (enumeration2.hasMoreElements()) {
            object = (Attribute)enumeration2.nextElement();
            if (((Attribute)object).isNominal()) {
                for (int i = 0; i < instances.numClasses(); ++i) {
                    d = Utils.sum(this.m_Counts[i][n]);
                    for (int j = 0; j < ((Attribute)object).numValues(); ++j) {
                        this.m_Counts[i][n][j] = (this.m_Counts[i][n][j] + 1.0) / (d + (double)((Attribute)object).numValues());
                    }
                }
            }
            ++n;
        }
        d = Utils.sum(this.m_Priors);
        for (int i = 0; i < instances.numClasses(); ++i) {
            this.m_Priors[i] = (this.m_Priors[i] + 1.0) / (d + (double)instances.numClasses());
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < instance.numClasses(); ++i) {
            dArray[i] = 1.0;
            Enumeration enumeration = instance.enumerateAttributes();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (!instance.isMissing(attribute)) {
                    if (attribute.isNominal()) {
                        int n2 = i;
                        dArray[n2] = dArray[n2] * this.m_Counts[i][n][(int)instance.value(attribute)];
                    } else {
                        int n3 = i;
                        dArray[n3] = dArray[n3] * this.normalDens(instance.value(attribute), this.m_Means[i][n], this.m_Devs[i][n]);
                    }
                }
                ++n;
            }
            int n4 = i;
            dArray[n4] = dArray[n4] * this.m_Priors[i];
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        if (this.m_Instances == null) {
            return LocalString.get("Naive Bayes (simple): No model built yet.");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(LocalString.get("Naive Bayes (simple)"));
            for (int i = 0; i < this.m_Instances.numClasses(); ++i) {
                stringBuffer.append(LocalString.get("\n\nClass ") + this.m_Instances.classAttribute().value(i) + ": P(C) = " + Utils.doubleToString(this.m_Priors[i], 10, 8) + "\n\n");
                Enumeration enumeration = this.m_Instances.enumerateAttributes();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    stringBuffer.append(LocalString.get("Attribute ") + attribute.name() + "\n");
                    if (attribute.isNominal()) {
                        int n2;
                        for (n2 = 0; n2 < attribute.numValues(); ++n2) {
                            stringBuffer.append(attribute.value(n2) + "\t");
                        }
                        stringBuffer.append("\n");
                        for (n2 = 0; n2 < attribute.numValues(); ++n2) {
                            stringBuffer.append(Utils.doubleToString(this.m_Counts[i][n][n2], 10, 8) + "\t");
                        }
                    } else {
                        stringBuffer.append(LocalString.get("Mean: ") + Utils.doubleToString(this.m_Means[i][n], 10, 8) + "\t");
                        stringBuffer.append(LocalString.get("Standard Deviation: ") + Utils.doubleToString(this.m_Devs[i][n], 10, 8));
                    }
                    stringBuffer.append("\n\n");
                    ++n;
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return LocalString.get("Can't print Naive Bayes classifier!");
        }
    }

    protected double normalDens(double d, double d2, double d3) {
        double d4 = d - d2;
        return 1.0 / (NORM_CONST * d3) * Math.exp(-(d4 * d4 / (2.0 * d3 * d3)));
    }

    public static void main(String[] stringArray) {
        try {
            NaiveBayesSimple naiveBayesSimple = new NaiveBayesSimple();
            System.out.println(Evaluation.evaluateModel(naiveBayesSimple, stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

