/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy.kstar;

import weka.LocalString;
import weka.classifiers.lazy.kstar.KStarCache;
import weka.classifiers.lazy.kstar.KStarConstants;
import weka.classifiers.lazy.kstar.KStarWrapper;
import weka.core.Instance;
import weka.core.Instances;

public class KStarNominalAttribute
implements KStarConstants {
    protected Instances m_TrainSet;
    protected Instance m_Test;
    protected Instance m_Train;
    protected int m_AttrIndex;
    protected double m_Stop = 1.0;
    protected double m_MissingProb = 1.0;
    protected double m_AverageProb = 1.0;
    protected double m_SmallestProb = 1.0;
    protected int m_TotalCount;
    protected int[] m_Distribution;
    protected int[][] m_RandClassCols;
    protected KStarCache m_Cache;
    protected int m_NumInstances;
    protected int m_NumClasses;
    protected int m_NumAttributes;
    protected int m_ClassType;
    protected int m_MissingMode = 4;
    protected int m_BlendMethod = 1;
    protected int m_BlendFactor = 20;

    public KStarNominalAttribute(Instance instance, Instance instance2, int n, Instances instances, int[][] nArray, KStarCache kStarCache) {
        this.m_Test = instance;
        this.m_Train = instance2;
        this.m_AttrIndex = n;
        this.m_TrainSet = instances;
        this.m_RandClassCols = nArray;
        this.m_Cache = kStarCache;
        this.init();
    }

    private void init() {
        try {
            this.m_NumInstances = this.m_TrainSet.numInstances();
            this.m_NumClasses = this.m_TrainSet.numClasses();
            this.m_NumAttributes = this.m_TrainSet.numAttributes();
            this.m_ClassType = this.m_TrainSet.classAttribute().type();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double transProb() {
        String string = LocalString.get("(KStarNominalAttribute.transProb) ");
        double d = 0.0;
        if (this.m_Cache.containsKey(this.m_Test.value(this.m_AttrIndex))) {
            KStarCache.TableEntry tableEntry = this.m_Cache.getCacheValues(this.m_Test.value(this.m_AttrIndex));
            this.m_Stop = tableEntry.value;
            this.m_MissingProb = tableEntry.pmiss;
        } else {
            this.generateAttrDistribution();
            this.m_Stop = this.m_BlendMethod == 2 ? this.stopProbUsingEntropy() : this.stopProbUsingBlend();
            this.m_Cache.store(this.m_Test.value(this.m_AttrIndex), this.m_Stop, this.m_MissingProb);
        }
        if (this.m_Train.isMissing(this.m_AttrIndex)) {
            d = this.m_MissingProb;
        } else {
            try {
                d = (1.0 - this.m_Stop) / (double)this.m_Test.attribute(this.m_AttrIndex).numValues();
                if ((int)this.m_Test.value(this.m_AttrIndex) == (int)this.m_Train.value(this.m_AttrIndex)) {
                    d += this.m_Stop;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return d;
    }

    private double stopProbUsingEntropy() {
        String string = "(KStarNominalAttribute.stopProbUsingEntropy)";
        if (this.m_ClassType != 1) {
            System.err.println(LocalString.get("Error: ") + string + LocalString.get(" attribute class must be nominal!"));
            System.exit(1);
        }
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        KStarWrapper kStarWrapper = new KStarWrapper();
        KStarWrapper kStarWrapper2 = new KStarWrapper();
        KStarWrapper kStarWrapper3 = new KStarWrapper();
        double d5 = 0.005;
        double d6 = 0.995;
        this.calculateEntropy(d6, kStarWrapper2);
        this.calculateEntropy(d5, kStarWrapper);
        if (kStarWrapper2.avgProb == 0.0) {
            this.calculateEntropy(d5, kStarWrapper3);
        } else {
            double d7;
            double d8;
            if (kStarWrapper2.randEntropy - kStarWrapper2.actEntropy < kStarWrapper.randEntropy - kStarWrapper.actEntropy && kStarWrapper.randEntropy - kStarWrapper.actEntropy > 0.0) {
                d4 = d8 = d5;
                d7 = 0.05;
                d = kStarWrapper.minProb;
                d2 = kStarWrapper.avgProb;
            } else {
                d4 = d8 = d6;
                d7 = -0.05;
                d = kStarWrapper2.minProb;
                d2 = kStarWrapper2.avgProb;
            }
            double d9 = 0.0;
            d3 = 0.0;
            n = 0;
            do {
                double d10;
                ++n;
                double d11 = d9;
                if ((d8 += d7) <= d5) {
                    d8 = d5;
                    d9 = 0.0;
                    d10 = -1.0;
                } else if (d8 >= d6) {
                    d8 = d6;
                    d9 = 0.0;
                    d10 = -1.0;
                } else {
                    this.calculateEntropy(d8, kStarWrapper3);
                    d9 = kStarWrapper3.randEntropy - kStarWrapper3.actEntropy;
                    if (d9 < 0.0) {
                        d9 = 0.0;
                        if (Math.abs(d7) < 0.05 && d3 == 0.0) {
                            d4 = d5;
                            d = kStarWrapper.minProb;
                            d2 = kStarWrapper.avgProb;
                            break;
                        }
                    }
                    d10 = d9 - d11;
                }
                if (d9 > d3) {
                    d3 = d9;
                    d4 = d8;
                    d = kStarWrapper3.minProb;
                    d2 = kStarWrapper3.avgProb;
                }
                if (!(d10 < 0.0)) continue;
                if (Math.abs(d7) < 0.01) break;
                d7 /= -2.0;
            } while (n <= 40);
        }
        this.m_SmallestProb = d;
        this.m_AverageProb = d2;
        switch (this.m_MissingMode) {
            case 1: {
                this.m_MissingProb = 0.0;
                break;
            }
            case 3: {
                this.m_MissingProb = 1.0;
                break;
            }
            case 2: {
                this.m_MissingProb = this.m_SmallestProb;
                break;
            }
            case 4: {
                this.m_MissingProb = this.m_AverageProb;
            }
        }
        double d12 = Math.abs(d2 - (double)this.m_TotalCount) < 1.0E-5 ? 1.0 : d4;
        return d12;
    }

    private void calculateEntropy(double d, KStarWrapper kStarWrapper) {
        int n;
        int n2;
        int n3;
        String string = "(KStarNominalAttribute.calculateEntropy)";
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        double[][] dArray = new double[6][this.m_NumClasses];
        for (n3 = 0; n3 <= 5; ++n3) {
            for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
                dArray[n3][n2] = 0.0;
            }
        }
        for (n2 = 0; n2 < this.m_NumInstances; ++n2) {
            Instance instance = this.m_TrainSet.instance(n2);
            if (instance.isMissing(this.m_AttrIndex)) continue;
            double d6 = this.PStar(this.m_Test, instance, this.m_AttrIndex, d);
            double d7 = d6 / (double)this.m_TotalCount;
            if (d6 < d5) {
                d5 = d6;
            }
            d4 += d7;
            for (n = 0; n <= 5; ++n) {
                double[] dArray2 = dArray[n];
                int n4 = this.m_RandClassCols[n][n2];
                dArray2[n4] = dArray2[n4] + d7;
            }
        }
        for (n3 = this.m_NumClasses - 1; n3 >= 0; --n3) {
            double d8 = dArray[5][n3] / d4;
            if (!(d8 > 0.0)) continue;
            d2 -= d8 * Math.log(d8) / 0.693147181;
        }
        for (n = 0; n < 5; ++n) {
            for (n2 = this.m_NumClasses - 1; n2 >= 0; --n2) {
                double d9 = dArray[n][n2] / d4;
                if (!(d9 > 0.0)) continue;
                d3 -= d9 * Math.log(d9) / 0.693147181;
            }
        }
        kStarWrapper.actEntropy = d2;
        kStarWrapper.randEntropy = d3 /= 5.0;
        kStarWrapper.avgProb = d4;
        kStarWrapper.minProb = d5;
    }

    private double stopProbUsingBlend() {
        String string = LocalString.get("(KStarNominalAttribute.stopProbUsingBlend) ");
        int n = 0;
        KStarWrapper kStarWrapper = new KStarWrapper();
        KStarWrapper kStarWrapper2 = new KStarWrapper();
        KStarWrapper kStarWrapper3 = new KStarWrapper();
        int n2 = (int)this.m_Test.value(this.m_AttrIndex);
        double d = (double)(this.m_TotalCount - this.m_Distribution[n2]) * (double)this.m_BlendFactor / 100.0 + (double)this.m_Distribution[n2];
        double d2 = 1.0 - (double)this.m_BlendFactor / 100.0;
        double d3 = 0.005;
        double d4 = 0.995;
        this.calculateSphereSize(n2, d3, kStarWrapper);
        kStarWrapper.sphere -= d;
        this.calculateSphereSize(n2, d4, kStarWrapper2);
        kStarWrapper2.sphere -= d;
        if (kStarWrapper2.avgProb == 0.0) {
            this.calculateSphereSize(n2, d2, kStarWrapper3);
        } else if (kStarWrapper2.sphere > 0.0) {
            d2 = d4;
            kStarWrapper3.avgProb = kStarWrapper2.avgProb;
        } else {
            while (true) {
                this.calculateSphereSize(n2, d2, kStarWrapper3);
                kStarWrapper3.sphere -= d;
                if (Math.abs(kStarWrapper3.sphere) <= 0.01 || ++n >= 40) break;
                if (kStarWrapper3.sphere > 0.0) {
                    d3 = d2;
                    d2 = (d4 + d3) / 2.0;
                    continue;
                }
                d4 = d2;
                d2 = (d4 + d3) / 2.0;
            }
        }
        this.m_SmallestProb = kStarWrapper3.minProb;
        this.m_AverageProb = kStarWrapper3.avgProb;
        switch (this.m_MissingMode) {
            case 1: {
                this.m_MissingProb = 0.0;
                break;
            }
            case 3: {
                this.m_MissingProb = 1.0;
                break;
            }
            case 2: {
                this.m_MissingProb = this.m_SmallestProb;
                break;
            }
            case 4: {
                this.m_MissingProb = this.m_AverageProb;
            }
        }
        double d5 = Math.abs(kStarWrapper3.avgProb - (double)this.m_TotalCount) < 1.0E-5 ? 1.0 : d2;
        return d5;
    }

    private void calculateSphereSize(int n, double d, KStarWrapper kStarWrapper) {
        double d2;
        String string = LocalString.get("(KStarNominalAttribute.calculateSphereSize) ");
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = 0.0;
        for (int i = 0; i < this.m_Distribution.length; ++i) {
            double d7;
            int n2 = this.m_Distribution[i];
            if (n2 == 0) continue;
            if (n == i) {
                d7 = (d + (1.0 - d) / (double)this.m_Distribution.length) / (double)this.m_TotalCount;
                d3 += d7 * (double)n2;
                d4 += d7 * d7 * (double)n2;
            } else {
                d7 = (1.0 - d) / (double)this.m_Distribution.length / (double)this.m_TotalCount;
                d3 += d7 * (double)n2;
                d4 += d7 * d7 * (double)n2;
            }
            if (!(d5 > d7 * (double)this.m_TotalCount)) continue;
            d5 = d7 * (double)this.m_TotalCount;
        }
        d6 = d3;
        kStarWrapper.sphere = d2 = d4 == 0.0 ? 0.0 : d3 * d3 / d4;
        kStarWrapper.avgProb = d6;
        kStarWrapper.minProb = d5;
    }

    private double PStar(Instance instance, Instance instance2, int n, double d) {
        String string = LocalString.get("(KStarNominalAttribute.PStar) ");
        int n2 = 0;
        try {
            n2 = instance.attribute(n).numValues();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d2 = (int)instance.value(n) == (int)instance2.value(n) ? d + (1.0 - d) / (double)n2 : (1.0 - d) / (double)n2;
        return d2;
    }

    private void generateAttrDistribution() {
        String string = "(KStarNominalAttribute.generateAttrDistribution)";
        this.m_Distribution = new int[this.m_TrainSet.attribute(this.m_AttrIndex).numValues()];
        for (int i = 0; i < this.m_NumInstances; ++i) {
            Instance instance = this.m_TrainSet.instance(i);
            if (instance.isMissing(this.m_AttrIndex)) continue;
            ++this.m_TotalCount;
            int n = (int)instance.value(this.m_AttrIndex);
            this.m_Distribution[n] = this.m_Distribution[n] + 1;
        }
    }

    public void setOptions(int n, int n2, int n3) {
        this.m_MissingMode = n;
        this.m_BlendMethod = n2;
        this.m_BlendFactor = n3;
    }
}

