/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Random;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.Stacking;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class Grading
extends Stacking {
    protected Classifier[] m_MetaClassifiers = new Classifier[0];
    protected double[] m_InstPerClass = null;

    public String globalInfo() {
        return LocalString.get("Implements Grading. The base classifiers are \"graded\". ") + LocalString.get("For more information, see\n\n") + LocalString.get("Seewald A.K., Fuernkranz J. (2001): An Evaluation of Grading ") + LocalString.get("Classifiers, in Hoffmann F. et al. (eds.), Advances in Intelligent ") + LocalString.get("Data Analysis, 4th International Conference, IDA 2001, Proceedings, ") + LocalString.get("Springer, Berlin/Heidelberg/New York/Tokyo, pp.115-124, 2001");
    }

    protected void generateMetaLevel(Instances instances, Random random) throws Exception {
        int n;
        this.m_MetaFormat = this.metaFormat(instances);
        Instances[] instancesArray = new Instances[this.m_Classifiers.length];
        for (n = 0; n < this.m_Classifiers.length; ++n) {
            instancesArray[n] = this.metaFormat(instances);
        }
        for (n = 0; n < this.m_NumFolds; ++n) {
            Instances instances2 = instances.trainCV(this.m_NumFolds, n, random);
            Instances instances3 = instances.testCV(this.m_NumFolds, n);
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                this.getClassifier(i).buildClassifier(instances2);
                for (int j = 0; j < instances3.numInstances(); ++j) {
                    instancesArray[i].add(this.metaInstance(instances3.instance(j), i));
                }
            }
        }
        this.m_InstPerClass = new double[instances.numClasses()];
        for (n = 0; n < instances.numClasses(); ++n) {
            this.m_InstPerClass[n] = 0.0;
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            int n2 = (int)instances.instance(n).classValue();
            this.m_InstPerClass[n2] = this.m_InstPerClass[n2] + 1.0;
        }
        this.m_MetaClassifiers = Classifier.makeCopies(this.m_MetaClassifier, this.m_Classifiers.length);
        for (n = 0; n < this.m_Classifiers.length; ++n) {
            this.m_MetaClassifiers[n].buildClassifier(instancesArray[n]);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray;
        int n2;
        int n3 = 0;
        int n4 = this.m_Classifiers.length;
        double[] dArray2 = new double[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            dArray = this.m_MetaClassifiers[n2].distributionForInstance(this.metaInstance(instance, n2));
            dArray2[n2] = this.m_MetaClassifiers[n2].classifyInstance(this.metaInstance(instance, n2)) == 1.0 ? dArray[1] : -dArray[0];
        }
        if (dArray2[Utils.maxIndex(dArray2)] < 0.0) {
            for (n2 = 0; n2 < n4; ++n2) {
                dArray2[n2] = 1.0 + dArray2[n2];
            }
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                if (!(dArray2[n2] < 0.0)) continue;
                dArray2[n2] = 0.0;
            }
        }
        dArray = new double[instance.numClasses()];
        for (n2 = 0; n2 < instance.numClasses(); ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            int n6 = n5 = (int)this.m_Classifiers[n2].classifyInstance(instance);
            dArray[n6] = dArray[n6] + dArray2[n2];
        }
        double d = dArray[Utils.maxIndex(dArray)];
        n2 = -100;
        int n7 = -1;
        for (n = 0; n < instance.numClasses(); ++n) {
            if (dArray[n] != d) continue;
            ++n3;
            if (!(this.m_InstPerClass[n] > (double)n2)) continue;
            n2 = (int)this.m_InstPerClass[n];
            n7 = n;
        }
        n = n3 == 1 ? Utils.maxIndex(dArray) : n7;
        double[] dArray3 = new double[instance.numClasses()];
        dArray3[n] = 1.0;
        return dArray3;
    }

    public String toString() {
        int n;
        if (this.m_Classifiers.length == 0) {
            return LocalString.get("Grading: No base schemes entered.");
        }
        if (this.m_MetaClassifiers.length == 0) {
            return LocalString.get("Grading: No meta scheme selected.");
        }
        if (this.m_MetaFormat == null) {
            return LocalString.get("Grading: No model built yet.");
        }
        String string = LocalString.get("Grading\n\nBase classifiers\n\n");
        for (n = 0; n < this.m_Classifiers.length; ++n) {
            string = string + this.getClassifier(n).toString() + "\n\n";
        }
        string = string + LocalString.get("\n\nMeta classifiers\n\n");
        for (n = 0; n < this.m_Classifiers.length; ++n) {
            string = string + this.m_MetaClassifiers[n].toString() + "\n\n";
        }
        return string;
    }

    protected Instances metaFormat(Instances instances) throws Exception {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex()) continue;
            fastVector.addElement(instances.attribute(i));
        }
        FastVector fastVector2 = new FastVector(2);
        fastVector2.addElement("0");
        fastVector2.addElement("1");
        fastVector.addElement(new Attribute(LocalString.get("PredConf"), fastVector2));
        Instances instances2 = new Instances(LocalString.get("Meta format"), fastVector, 0);
        instances2.setClassIndex(instances2.numAttributes() - 1);
        return instances2;
    }

    protected Instance metaInstance(Instance instance, int n) throws Exception {
        double d;
        double[] dArray = new double[this.m_MetaFormat.numAttributes()];
        int n2 = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex()) continue;
            dArray[n2] = instance.value(i);
            ++n2;
        }
        Classifier classifier = this.getClassifier(n);
        if (this.m_BaseFormat.classAttribute().isNumeric()) {
            throw new Exception(LocalString.get("Class Attribute must not be numeric!"));
        }
        double[] dArray2 = classifier.distributionForInstance(instance);
        int n3 = 0;
        double d2 = dArray2[0];
        for (int i = 1; i < dArray2.length; ++i) {
            if (!(dArray2[i] > d2)) continue;
            d2 = dArray2[i];
            n3 = i;
        }
        dArray[n2] = d = instance.classValue() == (double)n3 ? 1.0 : 0.0;
        Instance instance2 = new Instance(1.0, dArray);
        instance2.setDataset(this.m_MetaFormat);
        return instance2;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Grading(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

