/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Random;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.meta.Stacking;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.attribute.Remove;

public class StackingC
extends Stacking
implements OptionHandler {
    protected Classifier[] m_MetaClassifiers = null;
    protected Remove m_attrFilter = null;
    protected MakeIndicator m_makeIndicatorFilter = null;

    public String globalInfo() {
        return LocalString.get("Implements StackingC (more efficient version of stacking). For more ") + LocalString.get("information, see\n\n") + LocalString.get("Seewald A.K.: \"How to Make Stacking Better and Faster While Also Taking Care ") + LocalString.get("of an Unknown Weakness\", in Sammut C., Hoffmann A. (eds.), Proceedings of the ") + LocalString.get("Nineteenth International Conference on Machine Learning (ICML 2002), Morgan ") + LocalString.get("Kaufmann Publishers, pp.554-561, 2002.\n\n") + LocalString.get("Note: requires meta classifier to be a numeric prediction scheme.");
    }

    public StackingC() {
        this.m_MetaClassifier = new LinearRegression();
        ((LinearRegression)this.getMetaClassifier()).setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
    }

    protected String metaOption() {
        return LocalString.get("\tFull name of meta classifier, followed by options.\n") + LocalString.get("\tMust be a numeric prediction scheme. Default: Linear Regression.");
    }

    protected void processMetaOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('M', stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setMetaClassifier(Classifier.forName(string2, stringArray2));
        } else {
            ((LinearRegression)this.getMetaClassifier()).setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
        }
    }

    protected void generateMetaLevel(Instances instances, Random random) throws Exception {
        int n;
        Instances instances2;
        Instances instances3 = this.metaFormat(instances);
        this.m_MetaFormat = new Instances(instances3, 0);
        for (int i = 0; i < this.m_NumFolds; ++i) {
            instances2 = instances.trainCV(this.m_NumFolds, i, random);
            for (int j = 0; j < this.m_Classifiers.length; ++j) {
                this.getClassifier(j).buildClassifier(instances2);
            }
            Instances instances4 = instances.testCV(this.m_NumFolds, i);
            for (n = 0; n < instances4.numInstances(); ++n) {
                instances3.add(this.metaInstance(instances4.instance(n)));
            }
        }
        this.m_MetaClassifiers = Classifier.makeCopies(this.m_MetaClassifier, this.m_BaseFormat.numClasses());
        int[] nArray = new int[this.m_Classifiers.length + 1];
        nArray[this.m_Classifiers.length] = instances3.numAttributes() - 1;
        for (int i = 0; i < this.m_MetaClassifiers.length; ++i) {
            for (n = 0; n < this.m_Classifiers.length; ++n) {
                nArray[n] = this.m_BaseFormat.numClasses() * n + i;
            }
            this.m_makeIndicatorFilter = new MakeIndicator();
            this.m_makeIndicatorFilter.setAttributeIndex("" + (instances3.classIndex() + 1));
            this.m_makeIndicatorFilter.setNumeric(true);
            this.m_makeIndicatorFilter.setValueIndex(i);
            this.m_makeIndicatorFilter.setInputFormat(instances3);
            instances2 = Filter.useFilter(instances3, this.m_makeIndicatorFilter);
            this.m_attrFilter = new Remove();
            this.m_attrFilter.setInvertSelection(true);
            this.m_attrFilter.setAttributeIndicesArray(nArray);
            this.m_attrFilter.setInputFormat(this.m_makeIndicatorFilter.getOutputFormat());
            instances2 = Filter.useFilter(instances2, this.m_attrFilter);
            instances2.setClassIndex(instances2.numAttributes() - 1);
            this.m_MetaClassifiers[i].buildClassifier(instances2);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int[] nArray = new int[this.m_Classifiers.length + 1];
        nArray[this.m_Classifiers.length] = this.m_MetaFormat.numAttributes() - 1;
        double[] dArray = new double[this.m_BaseFormat.numClasses()];
        double d = 0.0;
        for (int i = 0; i < this.m_MetaClassifiers.length; ++i) {
            for (int j = 0; j < this.m_Classifiers.length; ++j) {
                nArray[j] = this.m_BaseFormat.numClasses() * j + i;
            }
            this.m_makeIndicatorFilter.setAttributeIndex("" + (this.m_MetaFormat.classIndex() + 1));
            this.m_makeIndicatorFilter.setNumeric(true);
            this.m_makeIndicatorFilter.setValueIndex(i);
            this.m_makeIndicatorFilter.setInputFormat(this.m_MetaFormat);
            this.m_makeIndicatorFilter.input(this.metaInstance(instance));
            this.m_makeIndicatorFilter.batchFinished();
            Instance instance2 = this.m_makeIndicatorFilter.output();
            this.m_attrFilter.setAttributeIndicesArray(nArray);
            this.m_attrFilter.setInvertSelection(true);
            this.m_attrFilter.setInputFormat(this.m_makeIndicatorFilter.getOutputFormat());
            this.m_attrFilter.input(instance2);
            this.m_attrFilter.batchFinished();
            instance2 = this.m_attrFilter.output();
            dArray[i] = this.m_MetaClassifiers[i].classifyInstance(instance2);
            if (dArray[i] > 1.0) {
                dArray[i] = 1.0;
            }
            if (dArray[i] < 0.0) {
                dArray[i] = 0.0;
            }
            d += dArray[i];
        }
        if (d != 0.0) {
            Utils.normalize(dArray, d);
        }
        return dArray;
    }

    public String toString() {
        int n;
        if (this.m_MetaFormat == null) {
            return LocalString.get("StackingC: No model built yet.");
        }
        String string = LocalString.get("StackingC\n\nBase classifiers\n\n");
        for (n = 0; n < this.m_Classifiers.length; ++n) {
            string = string + this.getClassifier(n).toString() + "\n\n";
        }
        string = string + LocalString.get("\n\nMeta classifiers (one for each class)\n\n");
        for (n = 0; n < this.m_MetaClassifiers.length; ++n) {
            string = string + this.m_MetaClassifiers[n].toString() + "\n\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new StackingC(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

